/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportModelVersionResponse extends LookoutEquipmentResponse implements
        ToCopyableBuilder<ImportModelVersionResponse.Builder, ImportModelVersionResponse> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelName").getter(getter(ImportModelVersionResponse::modelName)).setter(setter(Builder::modelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()).build();

    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelArn").getter(getter(ImportModelVersionResponse::modelArn)).setter(setter(Builder::modelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelArn").build()).build();

    private static final SdkField<String> MODEL_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelVersionArn").getter(getter(ImportModelVersionResponse::modelVersionArn))
            .setter(setter(Builder::modelVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersionArn").build()).build();

    private static final SdkField<Long> MODEL_VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ModelVersion").getter(getter(ImportModelVersionResponse::modelVersion))
            .setter(setter(Builder::modelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersion").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ImportModelVersionResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD,
            MODEL_ARN_FIELD, MODEL_VERSION_ARN_FIELD, MODEL_VERSION_FIELD, STATUS_FIELD));

    private final String modelName;

    private final String modelArn;

    private final String modelVersionArn;

    private final Long modelVersion;

    private final String status;

    private ImportModelVersionResponse(BuilderImpl builder) {
        super(builder);
        this.modelName = builder.modelName;
        this.modelArn = builder.modelArn;
        this.modelVersionArn = builder.modelVersionArn;
        this.modelVersion = builder.modelVersion;
        this.status = builder.status;
    }

    /**
     * <p>
     * The name for the machine learning model.
     * </p>
     * 
     * @return The name for the machine learning model.
     */
    public final String modelName() {
        return modelName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the model being created.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the model being created.
     */
    public final String modelArn() {
        return modelArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the model version being created.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the model version being created.
     */
    public final String modelVersionArn() {
        return modelVersionArn;
    }

    /**
     * <p>
     * The version of the model being created.
     * </p>
     * 
     * @return The version of the model being created.
     */
    public final Long modelVersion() {
        return modelVersion;
    }

    /**
     * <p>
     * The status of the <code>ImportModelVersion</code> operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ModelVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the <code>ImportModelVersion</code> operation.
     * @see ModelVersionStatus
     */
    public final ModelVersionStatus status() {
        return ModelVersionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the <code>ImportModelVersion</code> operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ModelVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the <code>ImportModelVersion</code> operation.
     * @see ModelVersionStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modelName());
        hashCode = 31 * hashCode + Objects.hashCode(modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(modelVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(modelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportModelVersionResponse)) {
            return false;
        }
        ImportModelVersionResponse other = (ImportModelVersionResponse) obj;
        return Objects.equals(modelName(), other.modelName()) && Objects.equals(modelArn(), other.modelArn())
                && Objects.equals(modelVersionArn(), other.modelVersionArn())
                && Objects.equals(modelVersion(), other.modelVersion())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportModelVersionResponse").add("ModelName", modelName()).add("ModelArn", modelArn())
                .add("ModelVersionArn", modelVersionArn()).add("ModelVersion", modelVersion()).add("Status", statusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelName":
            return Optional.ofNullable(clazz.cast(modelName()));
        case "ModelArn":
            return Optional.ofNullable(clazz.cast(modelArn()));
        case "ModelVersionArn":
            return Optional.ofNullable(clazz.cast(modelVersionArn()));
        case "ModelVersion":
            return Optional.ofNullable(clazz.cast(modelVersion()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportModelVersionResponse, T> g) {
        return obj -> g.apply((ImportModelVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutEquipmentResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ImportModelVersionResponse> {
        /**
         * <p>
         * The name for the machine learning model.
         * </p>
         * 
         * @param modelName
         *        The name for the machine learning model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelName(String modelName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the model being created.
         * </p>
         * 
         * @param modelArn
         *        The Amazon Resource Name (ARN) of the model being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelArn(String modelArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the model version being created.
         * </p>
         * 
         * @param modelVersionArn
         *        The Amazon Resource Name (ARN) of the model version being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVersionArn(String modelVersionArn);

        /**
         * <p>
         * The version of the model being created.
         * </p>
         * 
         * @param modelVersion
         *        The version of the model being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVersion(Long modelVersion);

        /**
         * <p>
         * The status of the <code>ImportModelVersion</code> operation.
         * </p>
         * 
         * @param status
         *        The status of the <code>ImportModelVersion</code> operation.
         * @see ModelVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelVersionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the <code>ImportModelVersion</code> operation.
         * </p>
         * 
         * @param status
         *        The status of the <code>ImportModelVersion</code> operation.
         * @see ModelVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelVersionStatus
         */
        Builder status(ModelVersionStatus status);
    }

    static final class BuilderImpl extends LookoutEquipmentResponse.BuilderImpl implements Builder {
        private String modelName;

        private String modelArn;

        private String modelVersionArn;

        private Long modelVersion;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportModelVersionResponse model) {
            super(model);
            modelName(model.modelName);
            modelArn(model.modelArn);
            modelVersionArn(model.modelVersionArn);
            modelVersion(model.modelVersion);
            status(model.status);
        }

        public final String getModelName() {
            return modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getModelArn() {
            return modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final String getModelVersionArn() {
            return modelVersionArn;
        }

        public final void setModelVersionArn(String modelVersionArn) {
            this.modelVersionArn = modelVersionArn;
        }

        @Override
        public final Builder modelVersionArn(String modelVersionArn) {
            this.modelVersionArn = modelVersionArn;
            return this;
        }

        public final Long getModelVersion() {
            return modelVersion;
        }

        public final void setModelVersion(Long modelVersion) {
            this.modelVersion = modelVersion;
        }

        @Override
        public final Builder modelVersion(Long modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ModelVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public ImportModelVersionResponse build() {
            return new ImportModelVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
