/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Entity that comprises information on categorical values in data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CategoricalValues implements SdkPojo, Serializable,
        ToCopyableBuilder<CategoricalValues.Builder, CategoricalValues> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(CategoricalValues::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Integer> NUMBER_OF_CATEGORY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfCategory").getter(getter(CategoricalValues::numberOfCategory))
            .setter(setter(Builder::numberOfCategory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfCategory").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            NUMBER_OF_CATEGORY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String status;

    private final Integer numberOfCategory;

    private CategoricalValues(BuilderImpl builder) {
        this.status = builder.status;
        this.numberOfCategory = builder.numberOfCategory;
    }

    /**
     * <p>
     * Indicates whether there is a potential data issue related to categorical values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StatisticalIssueStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates whether there is a potential data issue related to categorical values.
     * @see StatisticalIssueStatus
     */
    public final StatisticalIssueStatus status() {
        return StatisticalIssueStatus.fromValue(status);
    }

    /**
     * <p>
     * Indicates whether there is a potential data issue related to categorical values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StatisticalIssueStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates whether there is a potential data issue related to categorical values.
     * @see StatisticalIssueStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Indicates the number of categories in the data.
     * </p>
     * 
     * @return Indicates the number of categories in the data.
     */
    public final Integer numberOfCategory() {
        return numberOfCategory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfCategory());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CategoricalValues)) {
            return false;
        }
        CategoricalValues other = (CategoricalValues) obj;
        return Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(numberOfCategory(), other.numberOfCategory());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CategoricalValues").add("Status", statusAsString()).add("NumberOfCategory", numberOfCategory())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "NumberOfCategory":
            return Optional.ofNullable(clazz.cast(numberOfCategory()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CategoricalValues, T> g) {
        return obj -> g.apply((CategoricalValues) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CategoricalValues> {
        /**
         * <p>
         * Indicates whether there is a potential data issue related to categorical values.
         * </p>
         * 
         * @param status
         *        Indicates whether there is a potential data issue related to categorical values.
         * @see StatisticalIssueStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatisticalIssueStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Indicates whether there is a potential data issue related to categorical values.
         * </p>
         * 
         * @param status
         *        Indicates whether there is a potential data issue related to categorical values.
         * @see StatisticalIssueStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatisticalIssueStatus
         */
        Builder status(StatisticalIssueStatus status);

        /**
         * <p>
         * Indicates the number of categories in the data.
         * </p>
         * 
         * @param numberOfCategory
         *        Indicates the number of categories in the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfCategory(Integer numberOfCategory);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private Integer numberOfCategory;

        private BuilderImpl() {
        }

        private BuilderImpl(CategoricalValues model) {
            status(model.status);
            numberOfCategory(model.numberOfCategory);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StatisticalIssueStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Integer getNumberOfCategory() {
            return numberOfCategory;
        }

        public final void setNumberOfCategory(Integer numberOfCategory) {
            this.numberOfCategory = numberOfCategory;
        }

        @Override
        public final Builder numberOfCategory(Integer numberOfCategory) {
            this.numberOfCategory = numberOfCategory;
            return this;
        }

        @Override
        public CategoricalValues build() {
            return new CategoricalValues(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
