/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.lookoutequipment.model.CreateDatasetRequest;
import software.amazon.awssdk.services.lookoutequipment.model.CreateDatasetResponse;
import software.amazon.awssdk.services.lookoutequipment.model.CreateInferenceSchedulerRequest;
import software.amazon.awssdk.services.lookoutequipment.model.CreateInferenceSchedulerResponse;
import software.amazon.awssdk.services.lookoutequipment.model.CreateLabelGroupRequest;
import software.amazon.awssdk.services.lookoutequipment.model.CreateLabelGroupResponse;
import software.amazon.awssdk.services.lookoutequipment.model.CreateLabelRequest;
import software.amazon.awssdk.services.lookoutequipment.model.CreateLabelResponse;
import software.amazon.awssdk.services.lookoutequipment.model.CreateModelRequest;
import software.amazon.awssdk.services.lookoutequipment.model.CreateModelResponse;
import software.amazon.awssdk.services.lookoutequipment.model.CreateRetrainingSchedulerRequest;
import software.amazon.awssdk.services.lookoutequipment.model.CreateRetrainingSchedulerResponse;
import software.amazon.awssdk.services.lookoutequipment.model.DeleteDatasetRequest;
import software.amazon.awssdk.services.lookoutequipment.model.DeleteDatasetResponse;
import software.amazon.awssdk.services.lookoutequipment.model.DeleteInferenceSchedulerRequest;
import software.amazon.awssdk.services.lookoutequipment.model.DeleteInferenceSchedulerResponse;
import software.amazon.awssdk.services.lookoutequipment.model.DeleteLabelGroupRequest;
import software.amazon.awssdk.services.lookoutequipment.model.DeleteLabelGroupResponse;
import software.amazon.awssdk.services.lookoutequipment.model.DeleteLabelRequest;
import software.amazon.awssdk.services.lookoutequipment.model.DeleteLabelResponse;
import software.amazon.awssdk.services.lookoutequipment.model.DeleteModelRequest;
import software.amazon.awssdk.services.lookoutequipment.model.DeleteModelResponse;
import software.amazon.awssdk.services.lookoutequipment.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.lookoutequipment.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.lookoutequipment.model.DeleteRetrainingSchedulerRequest;
import software.amazon.awssdk.services.lookoutequipment.model.DeleteRetrainingSchedulerResponse;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeDataIngestionJobRequest;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeDataIngestionJobResponse;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeDatasetRequest;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeDatasetResponse;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeInferenceSchedulerRequest;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeInferenceSchedulerResponse;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeLabelGroupRequest;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeLabelGroupResponse;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeLabelRequest;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeLabelResponse;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeModelRequest;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeModelResponse;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeModelVersionRequest;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeModelVersionResponse;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeResourcePolicyRequest;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeResourcePolicyResponse;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeRetrainingSchedulerRequest;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeRetrainingSchedulerResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ImportDatasetRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ImportDatasetResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ImportModelVersionRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ImportModelVersionResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ListDataIngestionJobsRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListDataIngestionJobsResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ListDatasetsRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListDatasetsResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ListInferenceEventsRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListInferenceEventsResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ListInferenceExecutionsRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListInferenceExecutionsResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ListLabelGroupsRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListLabelGroupsResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ListLabelsRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListLabelsResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ListModelVersionsRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListModelVersionsResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ListModelsRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListModelsResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ListRetrainingSchedulersRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListRetrainingSchedulersResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ListSensorStatisticsRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListSensorStatisticsResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.lookoutequipment.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.lookoutequipment.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.lookoutequipment.model.StartDataIngestionJobRequest;
import software.amazon.awssdk.services.lookoutequipment.model.StartDataIngestionJobResponse;
import software.amazon.awssdk.services.lookoutequipment.model.StartInferenceSchedulerRequest;
import software.amazon.awssdk.services.lookoutequipment.model.StartInferenceSchedulerResponse;
import software.amazon.awssdk.services.lookoutequipment.model.StartRetrainingSchedulerRequest;
import software.amazon.awssdk.services.lookoutequipment.model.StartRetrainingSchedulerResponse;
import software.amazon.awssdk.services.lookoutequipment.model.StopInferenceSchedulerRequest;
import software.amazon.awssdk.services.lookoutequipment.model.StopInferenceSchedulerResponse;
import software.amazon.awssdk.services.lookoutequipment.model.StopRetrainingSchedulerRequest;
import software.amazon.awssdk.services.lookoutequipment.model.StopRetrainingSchedulerResponse;
import software.amazon.awssdk.services.lookoutequipment.model.TagResourceRequest;
import software.amazon.awssdk.services.lookoutequipment.model.TagResourceResponse;
import software.amazon.awssdk.services.lookoutequipment.model.UntagResourceRequest;
import software.amazon.awssdk.services.lookoutequipment.model.UntagResourceResponse;
import software.amazon.awssdk.services.lookoutequipment.model.UpdateActiveModelVersionRequest;
import software.amazon.awssdk.services.lookoutequipment.model.UpdateActiveModelVersionResponse;
import software.amazon.awssdk.services.lookoutequipment.model.UpdateInferenceSchedulerRequest;
import software.amazon.awssdk.services.lookoutequipment.model.UpdateInferenceSchedulerResponse;
import software.amazon.awssdk.services.lookoutequipment.model.UpdateLabelGroupRequest;
import software.amazon.awssdk.services.lookoutequipment.model.UpdateLabelGroupResponse;
import software.amazon.awssdk.services.lookoutequipment.model.UpdateModelRequest;
import software.amazon.awssdk.services.lookoutequipment.model.UpdateModelResponse;
import software.amazon.awssdk.services.lookoutequipment.model.UpdateRetrainingSchedulerRequest;
import software.amazon.awssdk.services.lookoutequipment.model.UpdateRetrainingSchedulerResponse;
import software.amazon.awssdk.services.lookoutequipment.paginators.ListDataIngestionJobsPublisher;
import software.amazon.awssdk.services.lookoutequipment.paginators.ListDatasetsPublisher;
import software.amazon.awssdk.services.lookoutequipment.paginators.ListInferenceEventsPublisher;
import software.amazon.awssdk.services.lookoutequipment.paginators.ListInferenceExecutionsPublisher;
import software.amazon.awssdk.services.lookoutequipment.paginators.ListInferenceSchedulersPublisher;
import software.amazon.awssdk.services.lookoutequipment.paginators.ListLabelGroupsPublisher;
import software.amazon.awssdk.services.lookoutequipment.paginators.ListLabelsPublisher;
import software.amazon.awssdk.services.lookoutequipment.paginators.ListModelVersionsPublisher;
import software.amazon.awssdk.services.lookoutequipment.paginators.ListModelsPublisher;
import software.amazon.awssdk.services.lookoutequipment.paginators.ListRetrainingSchedulersPublisher;
import software.amazon.awssdk.services.lookoutequipment.paginators.ListSensorStatisticsPublisher;

/**
 * Service client for accessing LookoutEquipment asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * Amazon Lookout for Equipment is a machine learning service that uses advanced analytics to identify anomalies in
 * machines from sensor data for use in predictive maintenance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface LookoutEquipmentAsyncClient extends AwsClient {
    String SERVICE_NAME = "lookoutequipment";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "lookoutequipment";

    /**
     * <p>
     * Creates a container for a collection of data being ingested for analysis. The dataset contains the metadata
     * describing where the data is and what the data actually looks like. For example, it contains the location of the
     * data source, the data schema, and other information. A dataset also contains any tags associated with the
     * ingested data.
     * </p>
     *
     * @param createDatasetRequest
     * @return A Java Future containing the result of the CreateDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException Resource limitations have been exceeded.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.CreateDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/CreateDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDatasetResponse> createDataset(CreateDatasetRequest createDatasetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a container for a collection of data being ingested for analysis. The dataset contains the metadata
     * describing where the data is and what the data actually looks like. For example, it contains the location of the
     * data source, the data schema, and other information. A dataset also contains any tags associated with the
     * ingested data.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDatasetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateDatasetRequest#builder()}
     * </p>
     *
     * @param createDatasetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.CreateDatasetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException Resource limitations have been exceeded.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.CreateDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/CreateDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDatasetResponse> createDataset(Consumer<CreateDatasetRequest.Builder> createDatasetRequest) {
        return createDataset(CreateDatasetRequest.builder().applyMutation(createDatasetRequest).build());
    }

    /**
     * <p>
     * Creates a scheduled inference. Scheduling an inference is setting up a continuous real-time inference plan to
     * analyze new measurement data. When setting up the schedule, you provide an S3 bucket location for the input data,
     * assign it a delimiter between separate entries in the data, set an offset delay if desired, and set the frequency
     * of inferencing. You must also provide an S3 bucket location for the output data.
     * </p>
     *
     * @param createInferenceSchedulerRequest
     * @return A Java Future containing the result of the CreateInferenceScheduler operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ServiceQuotaExceededException Resource limitations have been exceeded.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.CreateInferenceScheduler
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/CreateInferenceScheduler"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateInferenceSchedulerResponse> createInferenceScheduler(
            CreateInferenceSchedulerRequest createInferenceSchedulerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a scheduled inference. Scheduling an inference is setting up a continuous real-time inference plan to
     * analyze new measurement data. When setting up the schedule, you provide an S3 bucket location for the input data,
     * assign it a delimiter between separate entries in the data, set an offset delay if desired, and set the frequency
     * of inferencing. You must also provide an S3 bucket location for the output data.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInferenceSchedulerRequest.Builder} avoiding
     * the need to create one manually via {@link CreateInferenceSchedulerRequest#builder()}
     * </p>
     *
     * @param createInferenceSchedulerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.CreateInferenceSchedulerRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateInferenceScheduler operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ServiceQuotaExceededException Resource limitations have been exceeded.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.CreateInferenceScheduler
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/CreateInferenceScheduler"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateInferenceSchedulerResponse> createInferenceScheduler(
            Consumer<CreateInferenceSchedulerRequest.Builder> createInferenceSchedulerRequest) {
        return createInferenceScheduler(CreateInferenceSchedulerRequest.builder().applyMutation(createInferenceSchedulerRequest)
                .build());
    }

    /**
     * <p>
     * Creates a label for an event.
     * </p>
     *
     * @param createLabelRequest
     * @return A Java Future containing the result of the CreateLabel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException Resource limitations have been exceeded.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.CreateLabel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/CreateLabel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateLabelResponse> createLabel(CreateLabelRequest createLabelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a label for an event.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLabelRequest.Builder} avoiding the need to
     * create one manually via {@link CreateLabelRequest#builder()}
     * </p>
     *
     * @param createLabelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.CreateLabelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateLabel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException Resource limitations have been exceeded.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.CreateLabel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/CreateLabel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateLabelResponse> createLabel(Consumer<CreateLabelRequest.Builder> createLabelRequest) {
        return createLabel(CreateLabelRequest.builder().applyMutation(createLabelRequest).build());
    }

    /**
     * <p>
     * Creates a group of labels.
     * </p>
     *
     * @param createLabelGroupRequest
     * @return A Java Future containing the result of the CreateLabelGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException Resource limitations have been exceeded.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.CreateLabelGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/CreateLabelGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLabelGroupResponse> createLabelGroup(CreateLabelGroupRequest createLabelGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a group of labels.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLabelGroupRequest.Builder} avoiding the need
     * to create one manually via {@link CreateLabelGroupRequest#builder()}
     * </p>
     *
     * @param createLabelGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.CreateLabelGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateLabelGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException Resource limitations have been exceeded.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.CreateLabelGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/CreateLabelGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLabelGroupResponse> createLabelGroup(
            Consumer<CreateLabelGroupRequest.Builder> createLabelGroupRequest) {
        return createLabelGroup(CreateLabelGroupRequest.builder().applyMutation(createLabelGroupRequest).build());
    }

    /**
     * <p>
     * Creates a machine learning model for data inference.
     * </p>
     * <p>
     * A machine-learning (ML) model is a mathematical model that finds patterns in your data. In Amazon Lookout for
     * Equipment, the model learns the patterns of normal behavior and detects abnormal behavior that could be potential
     * equipment failure (or maintenance events). The models are made by analyzing normal data and abnormalities in
     * machine behavior that have already occurred.
     * </p>
     * <p>
     * Your model is trained using a portion of the data from your dataset and uses that data to learn patterns of
     * normal behavior and abnormal patterns that lead to equipment failure. Another portion of the data is used to
     * evaluate the model's accuracy.
     * </p>
     *
     * @param createModelRequest
     * @return A Java Future containing the result of the CreateModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException Resource limitations have been exceeded.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.CreateModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/CreateModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateModelResponse> createModel(CreateModelRequest createModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a machine learning model for data inference.
     * </p>
     * <p>
     * A machine-learning (ML) model is a mathematical model that finds patterns in your data. In Amazon Lookout for
     * Equipment, the model learns the patterns of normal behavior and detects abnormal behavior that could be potential
     * equipment failure (or maintenance events). The models are made by analyzing normal data and abnormalities in
     * machine behavior that have already occurred.
     * </p>
     * <p>
     * Your model is trained using a portion of the data from your dataset and uses that data to learn patterns of
     * normal behavior and abnormal patterns that lead to equipment failure. Another portion of the data is used to
     * evaluate the model's accuracy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateModelRequest.Builder} avoiding the need to
     * create one manually via {@link CreateModelRequest#builder()}
     * </p>
     *
     * @param createModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.CreateModelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException Resource limitations have been exceeded.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.CreateModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/CreateModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateModelResponse> createModel(Consumer<CreateModelRequest.Builder> createModelRequest) {
        return createModel(CreateModelRequest.builder().applyMutation(createModelRequest).build());
    }

    /**
     * <p>
     * Creates a retraining scheduler on the specified model.
     * </p>
     *
     * @param createRetrainingSchedulerRequest
     * @return A Java Future containing the result of the CreateRetrainingScheduler operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.CreateRetrainingScheduler
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/CreateRetrainingScheduler"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRetrainingSchedulerResponse> createRetrainingScheduler(
            CreateRetrainingSchedulerRequest createRetrainingSchedulerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a retraining scheduler on the specified model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRetrainingSchedulerRequest.Builder} avoiding
     * the need to create one manually via {@link CreateRetrainingSchedulerRequest#builder()}
     * </p>
     *
     * @param createRetrainingSchedulerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.CreateRetrainingSchedulerRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateRetrainingScheduler operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.CreateRetrainingScheduler
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/CreateRetrainingScheduler"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRetrainingSchedulerResponse> createRetrainingScheduler(
            Consumer<CreateRetrainingSchedulerRequest.Builder> createRetrainingSchedulerRequest) {
        return createRetrainingScheduler(CreateRetrainingSchedulerRequest.builder()
                .applyMutation(createRetrainingSchedulerRequest).build());
    }

    /**
     * <p>
     * Deletes a dataset and associated artifacts. The operation will check to see if any inference scheduler or data
     * ingestion job is currently using the dataset, and if there isn't, the dataset, its metadata, and any associated
     * data stored in S3 will be deleted. This does not affect any models that used this dataset for training and
     * evaluation, but does prevent it from being used in the future.
     * </p>
     *
     * @param deleteDatasetRequest
     * @return A Java Future containing the result of the DeleteDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.DeleteDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DeleteDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDatasetResponse> deleteDataset(DeleteDatasetRequest deleteDatasetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a dataset and associated artifacts. The operation will check to see if any inference scheduler or data
     * ingestion job is currently using the dataset, and if there isn't, the dataset, its metadata, and any associated
     * data stored in S3 will be deleted. This does not affect any models that used this dataset for training and
     * evaluation, but does prevent it from being used in the future.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDatasetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDatasetRequest#builder()}
     * </p>
     *
     * @param deleteDatasetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.DeleteDatasetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.DeleteDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DeleteDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDatasetResponse> deleteDataset(Consumer<DeleteDatasetRequest.Builder> deleteDatasetRequest) {
        return deleteDataset(DeleteDatasetRequest.builder().applyMutation(deleteDatasetRequest).build());
    }

    /**
     * <p>
     * Deletes an inference scheduler that has been set up. Prior inference results will not be deleted.
     * </p>
     *
     * @param deleteInferenceSchedulerRequest
     * @return A Java Future containing the result of the DeleteInferenceScheduler operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.DeleteInferenceScheduler
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DeleteInferenceScheduler"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteInferenceSchedulerResponse> deleteInferenceScheduler(
            DeleteInferenceSchedulerRequest deleteInferenceSchedulerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an inference scheduler that has been set up. Prior inference results will not be deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInferenceSchedulerRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteInferenceSchedulerRequest#builder()}
     * </p>
     *
     * @param deleteInferenceSchedulerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.DeleteInferenceSchedulerRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteInferenceScheduler operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.DeleteInferenceScheduler
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DeleteInferenceScheduler"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteInferenceSchedulerResponse> deleteInferenceScheduler(
            Consumer<DeleteInferenceSchedulerRequest.Builder> deleteInferenceSchedulerRequest) {
        return deleteInferenceScheduler(DeleteInferenceSchedulerRequest.builder().applyMutation(deleteInferenceSchedulerRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a label.
     * </p>
     *
     * @param deleteLabelRequest
     * @return A Java Future containing the result of the DeleteLabel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.DeleteLabel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DeleteLabel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteLabelResponse> deleteLabel(DeleteLabelRequest deleteLabelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a label.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLabelRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteLabelRequest#builder()}
     * </p>
     *
     * @param deleteLabelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.DeleteLabelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteLabel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.DeleteLabel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DeleteLabel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteLabelResponse> deleteLabel(Consumer<DeleteLabelRequest.Builder> deleteLabelRequest) {
        return deleteLabel(DeleteLabelRequest.builder().applyMutation(deleteLabelRequest).build());
    }

    /**
     * <p>
     * Deletes a group of labels.
     * </p>
     *
     * @param deleteLabelGroupRequest
     * @return A Java Future containing the result of the DeleteLabelGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.DeleteLabelGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DeleteLabelGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteLabelGroupResponse> deleteLabelGroup(DeleteLabelGroupRequest deleteLabelGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a group of labels.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLabelGroupRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteLabelGroupRequest#builder()}
     * </p>
     *
     * @param deleteLabelGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.DeleteLabelGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteLabelGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.DeleteLabelGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DeleteLabelGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteLabelGroupResponse> deleteLabelGroup(
            Consumer<DeleteLabelGroupRequest.Builder> deleteLabelGroupRequest) {
        return deleteLabelGroup(DeleteLabelGroupRequest.builder().applyMutation(deleteLabelGroupRequest).build());
    }

    /**
     * <p>
     * Deletes a machine learning model currently available for Amazon Lookout for Equipment. This will prevent it from
     * being used with an inference scheduler, even one that is already set up.
     * </p>
     *
     * @param deleteModelRequest
     * @return A Java Future containing the result of the DeleteModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.DeleteModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DeleteModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteModelResponse> deleteModel(DeleteModelRequest deleteModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a machine learning model currently available for Amazon Lookout for Equipment. This will prevent it from
     * being used with an inference scheduler, even one that is already set up.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteModelRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteModelRequest#builder()}
     * </p>
     *
     * @param deleteModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.DeleteModelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.DeleteModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DeleteModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteModelResponse> deleteModel(Consumer<DeleteModelRequest.Builder> deleteModelRequest) {
        return deleteModel(DeleteModelRequest.builder().applyMutation(deleteModelRequest).build());
    }

    /**
     * <p>
     * Deletes the resource policy attached to the resource.
     * </p>
     *
     * @param deleteResourcePolicyRequest
     * @return A Java Future containing the result of the DeleteResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResourcePolicyResponse> deleteResourcePolicy(
            DeleteResourcePolicyRequest deleteResourcePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the resource policy attached to the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourcePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResourcePolicyRequest#builder()}
     * </p>
     *
     * @param deleteResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.DeleteResourcePolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResourcePolicyResponse> deleteResourcePolicy(
            Consumer<DeleteResourcePolicyRequest.Builder> deleteResourcePolicyRequest) {
        return deleteResourcePolicy(DeleteResourcePolicyRequest.builder().applyMutation(deleteResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Deletes a retraining scheduler from a model. The retraining scheduler must be in the <code>STOPPED</code> status.
     * </p>
     *
     * @param deleteRetrainingSchedulerRequest
     * @return A Java Future containing the result of the DeleteRetrainingScheduler operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.DeleteRetrainingScheduler
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DeleteRetrainingScheduler"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRetrainingSchedulerResponse> deleteRetrainingScheduler(
            DeleteRetrainingSchedulerRequest deleteRetrainingSchedulerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a retraining scheduler from a model. The retraining scheduler must be in the <code>STOPPED</code> status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRetrainingSchedulerRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteRetrainingSchedulerRequest#builder()}
     * </p>
     *
     * @param deleteRetrainingSchedulerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.DeleteRetrainingSchedulerRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteRetrainingScheduler operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.DeleteRetrainingScheduler
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DeleteRetrainingScheduler"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRetrainingSchedulerResponse> deleteRetrainingScheduler(
            Consumer<DeleteRetrainingSchedulerRequest.Builder> deleteRetrainingSchedulerRequest) {
        return deleteRetrainingScheduler(DeleteRetrainingSchedulerRequest.builder()
                .applyMutation(deleteRetrainingSchedulerRequest).build());
    }

    /**
     * <p>
     * Provides information on a specific data ingestion job such as creation time, dataset ARN, and status.
     * </p>
     *
     * @param describeDataIngestionJobRequest
     * @return A Java Future containing the result of the DescribeDataIngestionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.DescribeDataIngestionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DescribeDataIngestionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDataIngestionJobResponse> describeDataIngestionJob(
            DescribeDataIngestionJobRequest describeDataIngestionJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information on a specific data ingestion job such as creation time, dataset ARN, and status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDataIngestionJobRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDataIngestionJobRequest#builder()}
     * </p>
     *
     * @param describeDataIngestionJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.DescribeDataIngestionJobRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeDataIngestionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.DescribeDataIngestionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DescribeDataIngestionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDataIngestionJobResponse> describeDataIngestionJob(
            Consumer<DescribeDataIngestionJobRequest.Builder> describeDataIngestionJobRequest) {
        return describeDataIngestionJob(DescribeDataIngestionJobRequest.builder().applyMutation(describeDataIngestionJobRequest)
                .build());
    }

    /**
     * <p>
     * Provides a JSON description of the data in each time series dataset, including names, column names, and data
     * types.
     * </p>
     *
     * @param describeDatasetRequest
     * @return A Java Future containing the result of the DescribeDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.DescribeDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DescribeDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDatasetResponse> describeDataset(DescribeDatasetRequest describeDatasetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a JSON description of the data in each time series dataset, including names, column names, and data
     * types.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDatasetRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeDatasetRequest#builder()}
     * </p>
     *
     * @param describeDatasetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.DescribeDatasetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.DescribeDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DescribeDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDatasetResponse> describeDataset(
            Consumer<DescribeDatasetRequest.Builder> describeDatasetRequest) {
        return describeDataset(DescribeDatasetRequest.builder().applyMutation(describeDatasetRequest).build());
    }

    /**
     * <p>
     * Specifies information about the inference scheduler being used, including name, model, status, and associated
     * metadata
     * </p>
     *
     * @param describeInferenceSchedulerRequest
     * @return A Java Future containing the result of the DescribeInferenceScheduler operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.DescribeInferenceScheduler
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DescribeInferenceScheduler"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInferenceSchedulerResponse> describeInferenceScheduler(
            DescribeInferenceSchedulerRequest describeInferenceSchedulerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Specifies information about the inference scheduler being used, including name, model, status, and associated
     * metadata
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInferenceSchedulerRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeInferenceSchedulerRequest#builder()}
     * </p>
     *
     * @param describeInferenceSchedulerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.DescribeInferenceSchedulerRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeInferenceScheduler operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.DescribeInferenceScheduler
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DescribeInferenceScheduler"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInferenceSchedulerResponse> describeInferenceScheduler(
            Consumer<DescribeInferenceSchedulerRequest.Builder> describeInferenceSchedulerRequest) {
        return describeInferenceScheduler(DescribeInferenceSchedulerRequest.builder()
                .applyMutation(describeInferenceSchedulerRequest).build());
    }

    /**
     * <p>
     * Returns the name of the label.
     * </p>
     *
     * @param describeLabelRequest
     * @return A Java Future containing the result of the DescribeLabel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.DescribeLabel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DescribeLabel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLabelResponse> describeLabel(DescribeLabelRequest describeLabelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the name of the label.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLabelRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeLabelRequest#builder()}
     * </p>
     *
     * @param describeLabelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.DescribeLabelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeLabel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.DescribeLabel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DescribeLabel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLabelResponse> describeLabel(Consumer<DescribeLabelRequest.Builder> describeLabelRequest) {
        return describeLabel(DescribeLabelRequest.builder().applyMutation(describeLabelRequest).build());
    }

    /**
     * <p>
     * Returns information about the label group.
     * </p>
     *
     * @param describeLabelGroupRequest
     * @return A Java Future containing the result of the DescribeLabelGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.DescribeLabelGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DescribeLabelGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLabelGroupResponse> describeLabelGroup(DescribeLabelGroupRequest describeLabelGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the label group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLabelGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeLabelGroupRequest#builder()}
     * </p>
     *
     * @param describeLabelGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.DescribeLabelGroupRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeLabelGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.DescribeLabelGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DescribeLabelGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLabelGroupResponse> describeLabelGroup(
            Consumer<DescribeLabelGroupRequest.Builder> describeLabelGroupRequest) {
        return describeLabelGroup(DescribeLabelGroupRequest.builder().applyMutation(describeLabelGroupRequest).build());
    }

    /**
     * <p>
     * Provides a JSON containing the overall information about a specific machine learning model, including model name
     * and ARN, dataset, training and evaluation information, status, and so on.
     * </p>
     *
     * @param describeModelRequest
     * @return A Java Future containing the result of the DescribeModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.DescribeModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DescribeModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeModelResponse> describeModel(DescribeModelRequest describeModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a JSON containing the overall information about a specific machine learning model, including model name
     * and ARN, dataset, training and evaluation information, status, and so on.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeModelRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeModelRequest#builder()}
     * </p>
     *
     * @param describeModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.DescribeModelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.DescribeModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DescribeModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeModelResponse> describeModel(Consumer<DescribeModelRequest.Builder> describeModelRequest) {
        return describeModel(DescribeModelRequest.builder().applyMutation(describeModelRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a specific machine learning model version.
     * </p>
     *
     * @param describeModelVersionRequest
     * @return A Java Future containing the result of the DescribeModelVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.DescribeModelVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DescribeModelVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeModelVersionResponse> describeModelVersion(
            DescribeModelVersionRequest describeModelVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a specific machine learning model version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeModelVersionRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeModelVersionRequest#builder()}
     * </p>
     *
     * @param describeModelVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.DescribeModelVersionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeModelVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.DescribeModelVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DescribeModelVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeModelVersionResponse> describeModelVersion(
            Consumer<DescribeModelVersionRequest.Builder> describeModelVersionRequest) {
        return describeModelVersion(DescribeModelVersionRequest.builder().applyMutation(describeModelVersionRequest).build());
    }

    /**
     * <p>
     * Provides the details of a resource policy attached to a resource.
     * </p>
     *
     * @param describeResourcePolicyRequest
     * @return A Java Future containing the result of the DescribeResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.DescribeResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DescribeResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeResourcePolicyResponse> describeResourcePolicy(
            DescribeResourcePolicyRequest describeResourcePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides the details of a resource policy attached to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeResourcePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeResourcePolicyRequest#builder()}
     * </p>
     *
     * @param describeResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.DescribeResourcePolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.DescribeResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DescribeResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeResourcePolicyResponse> describeResourcePolicy(
            Consumer<DescribeResourcePolicyRequest.Builder> describeResourcePolicyRequest) {
        return describeResourcePolicy(DescribeResourcePolicyRequest.builder().applyMutation(describeResourcePolicyRequest)
                .build());
    }

    /**
     * <p>
     * Provides a description of the retraining scheduler, including information such as the model name and retraining
     * parameters.
     * </p>
     *
     * @param describeRetrainingSchedulerRequest
     * @return A Java Future containing the result of the DescribeRetrainingScheduler operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.DescribeRetrainingScheduler
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DescribeRetrainingScheduler"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRetrainingSchedulerResponse> describeRetrainingScheduler(
            DescribeRetrainingSchedulerRequest describeRetrainingSchedulerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a description of the retraining scheduler, including information such as the model name and retraining
     * parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRetrainingSchedulerRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRetrainingSchedulerRequest#builder()}
     * </p>
     *
     * @param describeRetrainingSchedulerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.DescribeRetrainingSchedulerRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeRetrainingScheduler operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.DescribeRetrainingScheduler
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DescribeRetrainingScheduler"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRetrainingSchedulerResponse> describeRetrainingScheduler(
            Consumer<DescribeRetrainingSchedulerRequest.Builder> describeRetrainingSchedulerRequest) {
        return describeRetrainingScheduler(DescribeRetrainingSchedulerRequest.builder()
                .applyMutation(describeRetrainingSchedulerRequest).build());
    }

    /**
     * <p>
     * Imports a dataset.
     * </p>
     *
     * @param importDatasetRequest
     * @return A Java Future containing the result of the ImportDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ServiceQuotaExceededException Resource limitations have been exceeded.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ImportDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ImportDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ImportDatasetResponse> importDataset(ImportDatasetRequest importDatasetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Imports a dataset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportDatasetRequest.Builder} avoiding the need to
     * create one manually via {@link ImportDatasetRequest#builder()}
     * </p>
     *
     * @param importDatasetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.ImportDatasetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ImportDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ServiceQuotaExceededException Resource limitations have been exceeded.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ImportDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ImportDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ImportDatasetResponse> importDataset(Consumer<ImportDatasetRequest.Builder> importDatasetRequest) {
        return importDataset(ImportDatasetRequest.builder().applyMutation(importDatasetRequest).build());
    }

    /**
     * <p>
     * Imports a model that has been trained successfully.
     * </p>
     *
     * @param importModelVersionRequest
     * @return A Java Future containing the result of the ImportModelVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ServiceQuotaExceededException Resource limitations have been exceeded.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ImportModelVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ImportModelVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ImportModelVersionResponse> importModelVersion(ImportModelVersionRequest importModelVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Imports a model that has been trained successfully.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportModelVersionRequest.Builder} avoiding the
     * need to create one manually via {@link ImportModelVersionRequest#builder()}
     * </p>
     *
     * @param importModelVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.ImportModelVersionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ImportModelVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ServiceQuotaExceededException Resource limitations have been exceeded.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ImportModelVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ImportModelVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ImportModelVersionResponse> importModelVersion(
            Consumer<ImportModelVersionRequest.Builder> importModelVersionRequest) {
        return importModelVersion(ImportModelVersionRequest.builder().applyMutation(importModelVersionRequest).build());
    }

    /**
     * <p>
     * Provides a list of all data ingestion jobs, including dataset name and ARN, S3 location of the input data,
     * status, and so on.
     * </p>
     *
     * @param listDataIngestionJobsRequest
     * @return A Java Future containing the result of the ListDataIngestionJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ListDataIngestionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListDataIngestionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDataIngestionJobsResponse> listDataIngestionJobs(
            ListDataIngestionJobsRequest listDataIngestionJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of all data ingestion jobs, including dataset name and ARN, S3 location of the input data,
     * status, and so on.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataIngestionJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDataIngestionJobsRequest#builder()}
     * </p>
     *
     * @param listDataIngestionJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.ListDataIngestionJobsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListDataIngestionJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ListDataIngestionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListDataIngestionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDataIngestionJobsResponse> listDataIngestionJobs(
            Consumer<ListDataIngestionJobsRequest.Builder> listDataIngestionJobsRequest) {
        return listDataIngestionJobs(ListDataIngestionJobsRequest.builder().applyMutation(listDataIngestionJobsRequest).build());
    }

    /**
     * <p>
     * Provides a list of all data ingestion jobs, including dataset name and ARN, S3 location of the input data,
     * status, and so on.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDataIngestionJobs(software.amazon.awssdk.services.lookoutequipment.model.ListDataIngestionJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListDataIngestionJobsPublisher publisher = client.listDataIngestionJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListDataIngestionJobsPublisher publisher = client.listDataIngestionJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lookoutequipment.model.ListDataIngestionJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lookoutequipment.model.ListDataIngestionJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataIngestionJobs(software.amazon.awssdk.services.lookoutequipment.model.ListDataIngestionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDataIngestionJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ListDataIngestionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListDataIngestionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataIngestionJobsPublisher listDataIngestionJobsPaginator(
            ListDataIngestionJobsRequest listDataIngestionJobsRequest) {
        return new ListDataIngestionJobsPublisher(this, listDataIngestionJobsRequest);
    }

    /**
     * <p>
     * Provides a list of all data ingestion jobs, including dataset name and ARN, S3 location of the input data,
     * status, and so on.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDataIngestionJobs(software.amazon.awssdk.services.lookoutequipment.model.ListDataIngestionJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListDataIngestionJobsPublisher publisher = client.listDataIngestionJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListDataIngestionJobsPublisher publisher = client.listDataIngestionJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lookoutequipment.model.ListDataIngestionJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lookoutequipment.model.ListDataIngestionJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataIngestionJobs(software.amazon.awssdk.services.lookoutequipment.model.ListDataIngestionJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataIngestionJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDataIngestionJobsRequest#builder()}
     * </p>
     *
     * @param listDataIngestionJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.ListDataIngestionJobsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ListDataIngestionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListDataIngestionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataIngestionJobsPublisher listDataIngestionJobsPaginator(
            Consumer<ListDataIngestionJobsRequest.Builder> listDataIngestionJobsRequest) {
        return listDataIngestionJobsPaginator(ListDataIngestionJobsRequest.builder().applyMutation(listDataIngestionJobsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all datasets currently available in your account, filtering on the dataset name.
     * </p>
     *
     * @param listDatasetsRequest
     * @return A Java Future containing the result of the ListDatasets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ListDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListDatasets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDatasetsResponse> listDatasets(ListDatasetsRequest listDatasetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all datasets currently available in your account, filtering on the dataset name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDatasetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDatasetsRequest#builder()}
     * </p>
     *
     * @param listDatasetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.ListDatasetsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListDatasets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ListDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListDatasets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDatasetsResponse> listDatasets(Consumer<ListDatasetsRequest.Builder> listDatasetsRequest) {
        return listDatasets(ListDatasetsRequest.builder().applyMutation(listDatasetsRequest).build());
    }

    /**
     * <p>
     * Lists all datasets currently available in your account, filtering on the dataset name.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDatasets(software.amazon.awssdk.services.lookoutequipment.model.ListDatasetsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListDatasetsPublisher publisher = client.listDatasetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListDatasetsPublisher publisher = client.listDatasetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lookoutequipment.model.ListDatasetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lookoutequipment.model.ListDatasetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDatasets(software.amazon.awssdk.services.lookoutequipment.model.ListDatasetsRequest)} operation.</b>
     * </p>
     *
     * @param listDatasetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ListDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListDatasets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDatasetsPublisher listDatasetsPaginator(ListDatasetsRequest listDatasetsRequest) {
        return new ListDatasetsPublisher(this, listDatasetsRequest);
    }

    /**
     * <p>
     * Lists all datasets currently available in your account, filtering on the dataset name.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDatasets(software.amazon.awssdk.services.lookoutequipment.model.ListDatasetsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListDatasetsPublisher publisher = client.listDatasetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListDatasetsPublisher publisher = client.listDatasetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lookoutequipment.model.ListDatasetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lookoutequipment.model.ListDatasetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDatasets(software.amazon.awssdk.services.lookoutequipment.model.ListDatasetsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDatasetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDatasetsRequest#builder()}
     * </p>
     *
     * @param listDatasetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.ListDatasetsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ListDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListDatasets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDatasetsPublisher listDatasetsPaginator(Consumer<ListDatasetsRequest.Builder> listDatasetsRequest) {
        return listDatasetsPaginator(ListDatasetsRequest.builder().applyMutation(listDatasetsRequest).build());
    }

    /**
     * <p>
     * Lists all inference events that have been found for the specified inference scheduler.
     * </p>
     *
     * @param listInferenceEventsRequest
     * @return A Java Future containing the result of the ListInferenceEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ListInferenceEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListInferenceEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListInferenceEventsResponse> listInferenceEvents(
            ListInferenceEventsRequest listInferenceEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all inference events that have been found for the specified inference scheduler.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInferenceEventsRequest.Builder} avoiding the
     * need to create one manually via {@link ListInferenceEventsRequest#builder()}
     * </p>
     *
     * @param listInferenceEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.ListInferenceEventsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListInferenceEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ListInferenceEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListInferenceEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListInferenceEventsResponse> listInferenceEvents(
            Consumer<ListInferenceEventsRequest.Builder> listInferenceEventsRequest) {
        return listInferenceEvents(ListInferenceEventsRequest.builder().applyMutation(listInferenceEventsRequest).build());
    }

    /**
     * <p>
     * Lists all inference events that have been found for the specified inference scheduler.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInferenceEvents(software.amazon.awssdk.services.lookoutequipment.model.ListInferenceEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListInferenceEventsPublisher publisher = client.listInferenceEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListInferenceEventsPublisher publisher = client.listInferenceEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lookoutequipment.model.ListInferenceEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lookoutequipment.model.ListInferenceEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInferenceEvents(software.amazon.awssdk.services.lookoutequipment.model.ListInferenceEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInferenceEventsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ListInferenceEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListInferenceEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInferenceEventsPublisher listInferenceEventsPaginator(ListInferenceEventsRequest listInferenceEventsRequest) {
        return new ListInferenceEventsPublisher(this, listInferenceEventsRequest);
    }

    /**
     * <p>
     * Lists all inference events that have been found for the specified inference scheduler.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInferenceEvents(software.amazon.awssdk.services.lookoutequipment.model.ListInferenceEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListInferenceEventsPublisher publisher = client.listInferenceEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListInferenceEventsPublisher publisher = client.listInferenceEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lookoutequipment.model.ListInferenceEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lookoutequipment.model.ListInferenceEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInferenceEvents(software.amazon.awssdk.services.lookoutequipment.model.ListInferenceEventsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInferenceEventsRequest.Builder} avoiding the
     * need to create one manually via {@link ListInferenceEventsRequest#builder()}
     * </p>
     *
     * @param listInferenceEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.ListInferenceEventsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ListInferenceEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListInferenceEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInferenceEventsPublisher listInferenceEventsPaginator(
            Consumer<ListInferenceEventsRequest.Builder> listInferenceEventsRequest) {
        return listInferenceEventsPaginator(ListInferenceEventsRequest.builder().applyMutation(listInferenceEventsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all inference executions that have been performed by the specified inference scheduler.
     * </p>
     *
     * @param listInferenceExecutionsRequest
     * @return A Java Future containing the result of the ListInferenceExecutions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ListInferenceExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListInferenceExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListInferenceExecutionsResponse> listInferenceExecutions(
            ListInferenceExecutionsRequest listInferenceExecutionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all inference executions that have been performed by the specified inference scheduler.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInferenceExecutionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListInferenceExecutionsRequest#builder()}
     * </p>
     *
     * @param listInferenceExecutionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.ListInferenceExecutionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListInferenceExecutions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ListInferenceExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListInferenceExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListInferenceExecutionsResponse> listInferenceExecutions(
            Consumer<ListInferenceExecutionsRequest.Builder> listInferenceExecutionsRequest) {
        return listInferenceExecutions(ListInferenceExecutionsRequest.builder().applyMutation(listInferenceExecutionsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all inference executions that have been performed by the specified inference scheduler.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInferenceExecutions(software.amazon.awssdk.services.lookoutequipment.model.ListInferenceExecutionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListInferenceExecutionsPublisher publisher = client.listInferenceExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListInferenceExecutionsPublisher publisher = client.listInferenceExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lookoutequipment.model.ListInferenceExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lookoutequipment.model.ListInferenceExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInferenceExecutions(software.amazon.awssdk.services.lookoutequipment.model.ListInferenceExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInferenceExecutionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ListInferenceExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListInferenceExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInferenceExecutionsPublisher listInferenceExecutionsPaginator(
            ListInferenceExecutionsRequest listInferenceExecutionsRequest) {
        return new ListInferenceExecutionsPublisher(this, listInferenceExecutionsRequest);
    }

    /**
     * <p>
     * Lists all inference executions that have been performed by the specified inference scheduler.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInferenceExecutions(software.amazon.awssdk.services.lookoutequipment.model.ListInferenceExecutionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListInferenceExecutionsPublisher publisher = client.listInferenceExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListInferenceExecutionsPublisher publisher = client.listInferenceExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lookoutequipment.model.ListInferenceExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lookoutequipment.model.ListInferenceExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInferenceExecutions(software.amazon.awssdk.services.lookoutequipment.model.ListInferenceExecutionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInferenceExecutionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListInferenceExecutionsRequest#builder()}
     * </p>
     *
     * @param listInferenceExecutionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.ListInferenceExecutionsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ListInferenceExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListInferenceExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInferenceExecutionsPublisher listInferenceExecutionsPaginator(
            Consumer<ListInferenceExecutionsRequest.Builder> listInferenceExecutionsRequest) {
        return listInferenceExecutionsPaginator(ListInferenceExecutionsRequest.builder()
                .applyMutation(listInferenceExecutionsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of all inference schedulers currently available for your account.
     * </p>
     *
     * @param listInferenceSchedulersRequest
     * @return A Java Future containing the result of the ListInferenceSchedulers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ListInferenceSchedulers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListInferenceSchedulers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListInferenceSchedulersResponse> listInferenceSchedulers(
            ListInferenceSchedulersRequest listInferenceSchedulersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of all inference schedulers currently available for your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInferenceSchedulersRequest.Builder} avoiding
     * the need to create one manually via {@link ListInferenceSchedulersRequest#builder()}
     * </p>
     *
     * @param listInferenceSchedulersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListInferenceSchedulers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ListInferenceSchedulers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListInferenceSchedulers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListInferenceSchedulersResponse> listInferenceSchedulers(
            Consumer<ListInferenceSchedulersRequest.Builder> listInferenceSchedulersRequest) {
        return listInferenceSchedulers(ListInferenceSchedulersRequest.builder().applyMutation(listInferenceSchedulersRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list of all inference schedulers currently available for your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInferenceSchedulers(software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListInferenceSchedulersPublisher publisher = client.listInferenceSchedulersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListInferenceSchedulersPublisher publisher = client.listInferenceSchedulersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInferenceSchedulers(software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInferenceSchedulersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ListInferenceSchedulers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListInferenceSchedulers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInferenceSchedulersPublisher listInferenceSchedulersPaginator(
            ListInferenceSchedulersRequest listInferenceSchedulersRequest) {
        return new ListInferenceSchedulersPublisher(this, listInferenceSchedulersRequest);
    }

    /**
     * <p>
     * Retrieves a list of all inference schedulers currently available for your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInferenceSchedulers(software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListInferenceSchedulersPublisher publisher = client.listInferenceSchedulersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListInferenceSchedulersPublisher publisher = client.listInferenceSchedulersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInferenceSchedulers(software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInferenceSchedulersRequest.Builder} avoiding
     * the need to create one manually via {@link ListInferenceSchedulersRequest#builder()}
     * </p>
     *
     * @param listInferenceSchedulersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ListInferenceSchedulers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListInferenceSchedulers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInferenceSchedulersPublisher listInferenceSchedulersPaginator(
            Consumer<ListInferenceSchedulersRequest.Builder> listInferenceSchedulersRequest) {
        return listInferenceSchedulersPaginator(ListInferenceSchedulersRequest.builder()
                .applyMutation(listInferenceSchedulersRequest).build());
    }

    /**
     * <p>
     * Returns a list of the label groups.
     * </p>
     *
     * @param listLabelGroupsRequest
     * @return A Java Future containing the result of the ListLabelGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ListLabelGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListLabelGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListLabelGroupsResponse> listLabelGroups(ListLabelGroupsRequest listLabelGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the label groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLabelGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link ListLabelGroupsRequest#builder()}
     * </p>
     *
     * @param listLabelGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.ListLabelGroupsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListLabelGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ListLabelGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListLabelGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListLabelGroupsResponse> listLabelGroups(
            Consumer<ListLabelGroupsRequest.Builder> listLabelGroupsRequest) {
        return listLabelGroups(ListLabelGroupsRequest.builder().applyMutation(listLabelGroupsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the label groups.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLabelGroups(software.amazon.awssdk.services.lookoutequipment.model.ListLabelGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListLabelGroupsPublisher publisher = client.listLabelGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListLabelGroupsPublisher publisher = client.listLabelGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lookoutequipment.model.ListLabelGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lookoutequipment.model.ListLabelGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLabelGroups(software.amazon.awssdk.services.lookoutequipment.model.ListLabelGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLabelGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ListLabelGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListLabelGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLabelGroupsPublisher listLabelGroupsPaginator(ListLabelGroupsRequest listLabelGroupsRequest) {
        return new ListLabelGroupsPublisher(this, listLabelGroupsRequest);
    }

    /**
     * <p>
     * Returns a list of the label groups.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLabelGroups(software.amazon.awssdk.services.lookoutequipment.model.ListLabelGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListLabelGroupsPublisher publisher = client.listLabelGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListLabelGroupsPublisher publisher = client.listLabelGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lookoutequipment.model.ListLabelGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lookoutequipment.model.ListLabelGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLabelGroups(software.amazon.awssdk.services.lookoutequipment.model.ListLabelGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLabelGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link ListLabelGroupsRequest#builder()}
     * </p>
     *
     * @param listLabelGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.ListLabelGroupsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ListLabelGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListLabelGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLabelGroupsPublisher listLabelGroupsPaginator(Consumer<ListLabelGroupsRequest.Builder> listLabelGroupsRequest) {
        return listLabelGroupsPaginator(ListLabelGroupsRequest.builder().applyMutation(listLabelGroupsRequest).build());
    }

    /**
     * <p>
     * Provides a list of labels.
     * </p>
     *
     * @param listLabelsRequest
     * @return A Java Future containing the result of the ListLabels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ListLabels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListLabels" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListLabelsResponse> listLabels(ListLabelsRequest listLabelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of labels.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLabelsRequest.Builder} avoiding the need to
     * create one manually via {@link ListLabelsRequest#builder()}
     * </p>
     *
     * @param listLabelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.ListLabelsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListLabels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ListLabels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListLabels" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListLabelsResponse> listLabels(Consumer<ListLabelsRequest.Builder> listLabelsRequest) {
        return listLabels(ListLabelsRequest.builder().applyMutation(listLabelsRequest).build());
    }

    /**
     * <p>
     * Provides a list of labels.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLabels(software.amazon.awssdk.services.lookoutequipment.model.ListLabelsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListLabelsPublisher publisher = client.listLabelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListLabelsPublisher publisher = client.listLabelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lookoutequipment.model.ListLabelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lookoutequipment.model.ListLabelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLabels(software.amazon.awssdk.services.lookoutequipment.model.ListLabelsRequest)} operation.</b>
     * </p>
     *
     * @param listLabelsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ListLabels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListLabels" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLabelsPublisher listLabelsPaginator(ListLabelsRequest listLabelsRequest) {
        return new ListLabelsPublisher(this, listLabelsRequest);
    }

    /**
     * <p>
     * Provides a list of labels.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLabels(software.amazon.awssdk.services.lookoutequipment.model.ListLabelsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListLabelsPublisher publisher = client.listLabelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListLabelsPublisher publisher = client.listLabelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lookoutequipment.model.ListLabelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lookoutequipment.model.ListLabelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLabels(software.amazon.awssdk.services.lookoutequipment.model.ListLabelsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLabelsRequest.Builder} avoiding the need to
     * create one manually via {@link ListLabelsRequest#builder()}
     * </p>
     *
     * @param listLabelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.ListLabelsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ListLabels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListLabels" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLabelsPublisher listLabelsPaginator(Consumer<ListLabelsRequest.Builder> listLabelsRequest) {
        return listLabelsPaginator(ListLabelsRequest.builder().applyMutation(listLabelsRequest).build());
    }

    /**
     * <p>
     * Generates a list of all model versions for a given model, including the model version, model version ARN, and
     * status. To list a subset of versions, use the <code>MaxModelVersion</code> and <code>MinModelVersion</code>
     * fields.
     * </p>
     *
     * @param listModelVersionsRequest
     * @return A Java Future containing the result of the ListModelVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ListModelVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListModelVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListModelVersionsResponse> listModelVersions(ListModelVersionsRequest listModelVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates a list of all model versions for a given model, including the model version, model version ARN, and
     * status. To list a subset of versions, use the <code>MaxModelVersion</code> and <code>MinModelVersion</code>
     * fields.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListModelVersionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListModelVersionsRequest#builder()}
     * </p>
     *
     * @param listModelVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.ListModelVersionsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListModelVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ListModelVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListModelVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListModelVersionsResponse> listModelVersions(
            Consumer<ListModelVersionsRequest.Builder> listModelVersionsRequest) {
        return listModelVersions(ListModelVersionsRequest.builder().applyMutation(listModelVersionsRequest).build());
    }

    /**
     * <p>
     * Generates a list of all model versions for a given model, including the model version, model version ARN, and
     * status. To list a subset of versions, use the <code>MaxModelVersion</code> and <code>MinModelVersion</code>
     * fields.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listModelVersions(software.amazon.awssdk.services.lookoutequipment.model.ListModelVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListModelVersionsPublisher publisher = client.listModelVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListModelVersionsPublisher publisher = client.listModelVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lookoutequipment.model.ListModelVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lookoutequipment.model.ListModelVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listModelVersions(software.amazon.awssdk.services.lookoutequipment.model.ListModelVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listModelVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ListModelVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListModelVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListModelVersionsPublisher listModelVersionsPaginator(ListModelVersionsRequest listModelVersionsRequest) {
        return new ListModelVersionsPublisher(this, listModelVersionsRequest);
    }

    /**
     * <p>
     * Generates a list of all model versions for a given model, including the model version, model version ARN, and
     * status. To list a subset of versions, use the <code>MaxModelVersion</code> and <code>MinModelVersion</code>
     * fields.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listModelVersions(software.amazon.awssdk.services.lookoutequipment.model.ListModelVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListModelVersionsPublisher publisher = client.listModelVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListModelVersionsPublisher publisher = client.listModelVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lookoutequipment.model.ListModelVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lookoutequipment.model.ListModelVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listModelVersions(software.amazon.awssdk.services.lookoutequipment.model.ListModelVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListModelVersionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListModelVersionsRequest#builder()}
     * </p>
     *
     * @param listModelVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.ListModelVersionsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ListModelVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListModelVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListModelVersionsPublisher listModelVersionsPaginator(
            Consumer<ListModelVersionsRequest.Builder> listModelVersionsRequest) {
        return listModelVersionsPaginator(ListModelVersionsRequest.builder().applyMutation(listModelVersionsRequest).build());
    }

    /**
     * <p>
     * Generates a list of all models in the account, including model name and ARN, dataset, and status.
     * </p>
     *
     * @param listModelsRequest
     * @return A Java Future containing the result of the ListModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ListModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListModels" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListModelsResponse> listModels(ListModelsRequest listModelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates a list of all models in the account, including model name and ARN, dataset, and status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListModelsRequest.Builder} avoiding the need to
     * create one manually via {@link ListModelsRequest#builder()}
     * </p>
     *
     * @param listModelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.ListModelsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ListModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListModels" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListModelsResponse> listModels(Consumer<ListModelsRequest.Builder> listModelsRequest) {
        return listModels(ListModelsRequest.builder().applyMutation(listModelsRequest).build());
    }

    /**
     * <p>
     * Generates a list of all models in the account, including model name and ARN, dataset, and status.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listModels(software.amazon.awssdk.services.lookoutequipment.model.ListModelsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListModelsPublisher publisher = client.listModelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListModelsPublisher publisher = client.listModelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lookoutequipment.model.ListModelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lookoutequipment.model.ListModelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listModels(software.amazon.awssdk.services.lookoutequipment.model.ListModelsRequest)} operation.</b>
     * </p>
     *
     * @param listModelsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ListModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListModels" target="_top">AWS
     *      API Documentation</a>
     */
    default ListModelsPublisher listModelsPaginator(ListModelsRequest listModelsRequest) {
        return new ListModelsPublisher(this, listModelsRequest);
    }

    /**
     * <p>
     * Generates a list of all models in the account, including model name and ARN, dataset, and status.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listModels(software.amazon.awssdk.services.lookoutequipment.model.ListModelsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListModelsPublisher publisher = client.listModelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListModelsPublisher publisher = client.listModelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lookoutequipment.model.ListModelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lookoutequipment.model.ListModelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listModels(software.amazon.awssdk.services.lookoutequipment.model.ListModelsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListModelsRequest.Builder} avoiding the need to
     * create one manually via {@link ListModelsRequest#builder()}
     * </p>
     *
     * @param listModelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.ListModelsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ListModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListModels" target="_top">AWS
     *      API Documentation</a>
     */
    default ListModelsPublisher listModelsPaginator(Consumer<ListModelsRequest.Builder> listModelsRequest) {
        return listModelsPaginator(ListModelsRequest.builder().applyMutation(listModelsRequest).build());
    }

    /**
     * <p>
     * Lists all retraining schedulers in your account, filtering by model name prefix and status.
     * </p>
     *
     * @param listRetrainingSchedulersRequest
     * @return A Java Future containing the result of the ListRetrainingSchedulers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ListRetrainingSchedulers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListRetrainingSchedulers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRetrainingSchedulersResponse> listRetrainingSchedulers(
            ListRetrainingSchedulersRequest listRetrainingSchedulersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all retraining schedulers in your account, filtering by model name prefix and status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRetrainingSchedulersRequest.Builder} avoiding
     * the need to create one manually via {@link ListRetrainingSchedulersRequest#builder()}
     * </p>
     *
     * @param listRetrainingSchedulersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.ListRetrainingSchedulersRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListRetrainingSchedulers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ListRetrainingSchedulers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListRetrainingSchedulers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRetrainingSchedulersResponse> listRetrainingSchedulers(
            Consumer<ListRetrainingSchedulersRequest.Builder> listRetrainingSchedulersRequest) {
        return listRetrainingSchedulers(ListRetrainingSchedulersRequest.builder().applyMutation(listRetrainingSchedulersRequest)
                .build());
    }

    /**
     * <p>
     * Lists all retraining schedulers in your account, filtering by model name prefix and status.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRetrainingSchedulers(software.amazon.awssdk.services.lookoutequipment.model.ListRetrainingSchedulersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListRetrainingSchedulersPublisher publisher = client.listRetrainingSchedulersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListRetrainingSchedulersPublisher publisher = client.listRetrainingSchedulersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lookoutequipment.model.ListRetrainingSchedulersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lookoutequipment.model.ListRetrainingSchedulersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRetrainingSchedulers(software.amazon.awssdk.services.lookoutequipment.model.ListRetrainingSchedulersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRetrainingSchedulersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ListRetrainingSchedulers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListRetrainingSchedulers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRetrainingSchedulersPublisher listRetrainingSchedulersPaginator(
            ListRetrainingSchedulersRequest listRetrainingSchedulersRequest) {
        return new ListRetrainingSchedulersPublisher(this, listRetrainingSchedulersRequest);
    }

    /**
     * <p>
     * Lists all retraining schedulers in your account, filtering by model name prefix and status.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRetrainingSchedulers(software.amazon.awssdk.services.lookoutequipment.model.ListRetrainingSchedulersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListRetrainingSchedulersPublisher publisher = client.listRetrainingSchedulersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListRetrainingSchedulersPublisher publisher = client.listRetrainingSchedulersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lookoutequipment.model.ListRetrainingSchedulersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lookoutequipment.model.ListRetrainingSchedulersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRetrainingSchedulers(software.amazon.awssdk.services.lookoutequipment.model.ListRetrainingSchedulersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRetrainingSchedulersRequest.Builder} avoiding
     * the need to create one manually via {@link ListRetrainingSchedulersRequest#builder()}
     * </p>
     *
     * @param listRetrainingSchedulersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.ListRetrainingSchedulersRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ListRetrainingSchedulers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListRetrainingSchedulers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRetrainingSchedulersPublisher listRetrainingSchedulersPaginator(
            Consumer<ListRetrainingSchedulersRequest.Builder> listRetrainingSchedulersRequest) {
        return listRetrainingSchedulersPaginator(ListRetrainingSchedulersRequest.builder()
                .applyMutation(listRetrainingSchedulersRequest).build());
    }

    /**
     * <p>
     * Lists statistics about the data collected for each of the sensors that have been successfully ingested in the
     * particular dataset. Can also be used to retreive Sensor Statistics for a previous ingestion job.
     * </p>
     *
     * @param listSensorStatisticsRequest
     * @return A Java Future containing the result of the ListSensorStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ListSensorStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListSensorStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSensorStatisticsResponse> listSensorStatistics(
            ListSensorStatisticsRequest listSensorStatisticsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists statistics about the data collected for each of the sensors that have been successfully ingested in the
     * particular dataset. Can also be used to retreive Sensor Statistics for a previous ingestion job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSensorStatisticsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSensorStatisticsRequest#builder()}
     * </p>
     *
     * @param listSensorStatisticsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.ListSensorStatisticsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListSensorStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ListSensorStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListSensorStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSensorStatisticsResponse> listSensorStatistics(
            Consumer<ListSensorStatisticsRequest.Builder> listSensorStatisticsRequest) {
        return listSensorStatistics(ListSensorStatisticsRequest.builder().applyMutation(listSensorStatisticsRequest).build());
    }

    /**
     * <p>
     * Lists statistics about the data collected for each of the sensors that have been successfully ingested in the
     * particular dataset. Can also be used to retreive Sensor Statistics for a previous ingestion job.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSensorStatistics(software.amazon.awssdk.services.lookoutequipment.model.ListSensorStatisticsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListSensorStatisticsPublisher publisher = client.listSensorStatisticsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListSensorStatisticsPublisher publisher = client.listSensorStatisticsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lookoutequipment.model.ListSensorStatisticsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lookoutequipment.model.ListSensorStatisticsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSensorStatistics(software.amazon.awssdk.services.lookoutequipment.model.ListSensorStatisticsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSensorStatisticsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ListSensorStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListSensorStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSensorStatisticsPublisher listSensorStatisticsPaginator(ListSensorStatisticsRequest listSensorStatisticsRequest) {
        return new ListSensorStatisticsPublisher(this, listSensorStatisticsRequest);
    }

    /**
     * <p>
     * Lists statistics about the data collected for each of the sensors that have been successfully ingested in the
     * particular dataset. Can also be used to retreive Sensor Statistics for a previous ingestion job.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSensorStatistics(software.amazon.awssdk.services.lookoutequipment.model.ListSensorStatisticsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListSensorStatisticsPublisher publisher = client.listSensorStatisticsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListSensorStatisticsPublisher publisher = client.listSensorStatisticsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lookoutequipment.model.ListSensorStatisticsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lookoutequipment.model.ListSensorStatisticsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSensorStatistics(software.amazon.awssdk.services.lookoutequipment.model.ListSensorStatisticsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSensorStatisticsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSensorStatisticsRequest#builder()}
     * </p>
     *
     * @param listSensorStatisticsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.ListSensorStatisticsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ListSensorStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListSensorStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSensorStatisticsPublisher listSensorStatisticsPaginator(
            Consumer<ListSensorStatisticsRequest.Builder> listSensorStatisticsRequest) {
        return listSensorStatisticsPaginator(ListSensorStatisticsRequest.builder().applyMutation(listSensorStatisticsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all the tags for a specified resource, including key and value.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the tags for a specified resource, including key and value.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.ListTagsForResourceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Creates a resource control policy for a given resource.
     * </p>
     *
     * @param putResourcePolicyRequest
     * @return A Java Future containing the result of the PutResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException Resource limitations have been exceeded.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/PutResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutResourcePolicyResponse> putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a resource control policy for a given resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link PutResourcePolicyRequest#builder()}
     * </p>
     *
     * @param putResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.PutResourcePolicyRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the PutResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException Resource limitations have been exceeded.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/PutResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutResourcePolicyResponse> putResourcePolicy(
            Consumer<PutResourcePolicyRequest.Builder> putResourcePolicyRequest) {
        return putResourcePolicy(PutResourcePolicyRequest.builder().applyMutation(putResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Starts a data ingestion job. Amazon Lookout for Equipment returns the job status.
     * </p>
     *
     * @param startDataIngestionJobRequest
     * @return A Java Future containing the result of the StartDataIngestionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException Resource limitations have been exceeded.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.StartDataIngestionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/StartDataIngestionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartDataIngestionJobResponse> startDataIngestionJob(
            StartDataIngestionJobRequest startDataIngestionJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a data ingestion job. Amazon Lookout for Equipment returns the job status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartDataIngestionJobRequest.Builder} avoiding the
     * need to create one manually via {@link StartDataIngestionJobRequest#builder()}
     * </p>
     *
     * @param startDataIngestionJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.StartDataIngestionJobRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the StartDataIngestionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException Resource limitations have been exceeded.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.StartDataIngestionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/StartDataIngestionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartDataIngestionJobResponse> startDataIngestionJob(
            Consumer<StartDataIngestionJobRequest.Builder> startDataIngestionJobRequest) {
        return startDataIngestionJob(StartDataIngestionJobRequest.builder().applyMutation(startDataIngestionJobRequest).build());
    }

    /**
     * <p>
     * Starts an inference scheduler.
     * </p>
     *
     * @param startInferenceSchedulerRequest
     * @return A Java Future containing the result of the StartInferenceScheduler operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.StartInferenceScheduler
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/StartInferenceScheduler"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartInferenceSchedulerResponse> startInferenceScheduler(
            StartInferenceSchedulerRequest startInferenceSchedulerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an inference scheduler.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartInferenceSchedulerRequest.Builder} avoiding
     * the need to create one manually via {@link StartInferenceSchedulerRequest#builder()}
     * </p>
     *
     * @param startInferenceSchedulerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.StartInferenceSchedulerRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the StartInferenceScheduler operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.StartInferenceScheduler
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/StartInferenceScheduler"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartInferenceSchedulerResponse> startInferenceScheduler(
            Consumer<StartInferenceSchedulerRequest.Builder> startInferenceSchedulerRequest) {
        return startInferenceScheduler(StartInferenceSchedulerRequest.builder().applyMutation(startInferenceSchedulerRequest)
                .build());
    }

    /**
     * <p>
     * Starts a retraining scheduler.
     * </p>
     *
     * @param startRetrainingSchedulerRequest
     * @return A Java Future containing the result of the StartRetrainingScheduler operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.StartRetrainingScheduler
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/StartRetrainingScheduler"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartRetrainingSchedulerResponse> startRetrainingScheduler(
            StartRetrainingSchedulerRequest startRetrainingSchedulerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a retraining scheduler.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartRetrainingSchedulerRequest.Builder} avoiding
     * the need to create one manually via {@link StartRetrainingSchedulerRequest#builder()}
     * </p>
     *
     * @param startRetrainingSchedulerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.StartRetrainingSchedulerRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the StartRetrainingScheduler operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.StartRetrainingScheduler
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/StartRetrainingScheduler"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartRetrainingSchedulerResponse> startRetrainingScheduler(
            Consumer<StartRetrainingSchedulerRequest.Builder> startRetrainingSchedulerRequest) {
        return startRetrainingScheduler(StartRetrainingSchedulerRequest.builder().applyMutation(startRetrainingSchedulerRequest)
                .build());
    }

    /**
     * <p>
     * Stops an inference scheduler.
     * </p>
     *
     * @param stopInferenceSchedulerRequest
     * @return A Java Future containing the result of the StopInferenceScheduler operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.StopInferenceScheduler
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/StopInferenceScheduler"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopInferenceSchedulerResponse> stopInferenceScheduler(
            StopInferenceSchedulerRequest stopInferenceSchedulerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops an inference scheduler.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopInferenceSchedulerRequest.Builder} avoiding the
     * need to create one manually via {@link StopInferenceSchedulerRequest#builder()}
     * </p>
     *
     * @param stopInferenceSchedulerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.StopInferenceSchedulerRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the StopInferenceScheduler operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.StopInferenceScheduler
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/StopInferenceScheduler"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopInferenceSchedulerResponse> stopInferenceScheduler(
            Consumer<StopInferenceSchedulerRequest.Builder> stopInferenceSchedulerRequest) {
        return stopInferenceScheduler(StopInferenceSchedulerRequest.builder().applyMutation(stopInferenceSchedulerRequest)
                .build());
    }

    /**
     * <p>
     * Stops a retraining scheduler.
     * </p>
     *
     * @param stopRetrainingSchedulerRequest
     * @return A Java Future containing the result of the StopRetrainingScheduler operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.StopRetrainingScheduler
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/StopRetrainingScheduler"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopRetrainingSchedulerResponse> stopRetrainingScheduler(
            StopRetrainingSchedulerRequest stopRetrainingSchedulerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a retraining scheduler.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopRetrainingSchedulerRequest.Builder} avoiding
     * the need to create one manually via {@link StopRetrainingSchedulerRequest#builder()}
     * </p>
     *
     * @param stopRetrainingSchedulerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.StopRetrainingSchedulerRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the StopRetrainingScheduler operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.StopRetrainingScheduler
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/StopRetrainingScheduler"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopRetrainingSchedulerResponse> stopRetrainingScheduler(
            Consumer<StopRetrainingSchedulerRequest.Builder> stopRetrainingSchedulerRequest) {
        return stopRetrainingScheduler(StopRetrainingSchedulerRequest.builder().applyMutation(stopRetrainingSchedulerRequest)
                .build());
    }

    /**
     * <p>
     * Associates a given tag to a resource in your account. A tag is a key-value pair which can be added to an Amazon
     * Lookout for Equipment resource as metadata. Tags can be used for organizing your resources as well as helping you
     * to search and filter by tag. Multiple tags can be added to a resource, either when you create it, or later. Up to
     * 50 tags can be associated with each resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ServiceQuotaExceededException Resource limitations have been exceeded.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a given tag to a resource in your account. A tag is a key-value pair which can be added to an Amazon
     * Lookout for Equipment resource as metadata. Tags can be used for organizing your resources as well as helping you
     * to search and filter by tag. Multiple tags can be added to a resource, either when you create it, or later. Up to
     * 50 tags can be associated with each resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ServiceQuotaExceededException Resource limitations have been exceeded.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a specific tag from a given resource. The tag is specified by its key.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a specific tag from a given resource. The tag is specified by its key.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Sets the active model version for a given machine learning model.
     * </p>
     *
     * @param updateActiveModelVersionRequest
     * @return A Java Future containing the result of the UpdateActiveModelVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.UpdateActiveModelVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/UpdateActiveModelVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateActiveModelVersionResponse> updateActiveModelVersion(
            UpdateActiveModelVersionRequest updateActiveModelVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the active model version for a given machine learning model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateActiveModelVersionRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateActiveModelVersionRequest#builder()}
     * </p>
     *
     * @param updateActiveModelVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.UpdateActiveModelVersionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateActiveModelVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.UpdateActiveModelVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/UpdateActiveModelVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateActiveModelVersionResponse> updateActiveModelVersion(
            Consumer<UpdateActiveModelVersionRequest.Builder> updateActiveModelVersionRequest) {
        return updateActiveModelVersion(UpdateActiveModelVersionRequest.builder().applyMutation(updateActiveModelVersionRequest)
                .build());
    }

    /**
     * <p>
     * Updates an inference scheduler.
     * </p>
     *
     * @param updateInferenceSchedulerRequest
     * @return A Java Future containing the result of the UpdateInferenceScheduler operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.UpdateInferenceScheduler
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/UpdateInferenceScheduler"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateInferenceSchedulerResponse> updateInferenceScheduler(
            UpdateInferenceSchedulerRequest updateInferenceSchedulerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an inference scheduler.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateInferenceSchedulerRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateInferenceSchedulerRequest#builder()}
     * </p>
     *
     * @param updateInferenceSchedulerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.UpdateInferenceSchedulerRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateInferenceScheduler operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.UpdateInferenceScheduler
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/UpdateInferenceScheduler"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateInferenceSchedulerResponse> updateInferenceScheduler(
            Consumer<UpdateInferenceSchedulerRequest.Builder> updateInferenceSchedulerRequest) {
        return updateInferenceScheduler(UpdateInferenceSchedulerRequest.builder().applyMutation(updateInferenceSchedulerRequest)
                .build());
    }

    /**
     * <p>
     * Updates the label group.
     * </p>
     *
     * @param updateLabelGroupRequest
     * @return A Java Future containing the result of the UpdateLabelGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.UpdateLabelGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/UpdateLabelGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateLabelGroupResponse> updateLabelGroup(UpdateLabelGroupRequest updateLabelGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the label group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLabelGroupRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateLabelGroupRequest#builder()}
     * </p>
     *
     * @param updateLabelGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.UpdateLabelGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateLabelGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.UpdateLabelGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/UpdateLabelGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateLabelGroupResponse> updateLabelGroup(
            Consumer<UpdateLabelGroupRequest.Builder> updateLabelGroupRequest) {
        return updateLabelGroup(UpdateLabelGroupRequest.builder().applyMutation(updateLabelGroupRequest).build());
    }

    /**
     * <p>
     * Updates a model in the account.
     * </p>
     *
     * @param updateModelRequest
     * @return A Java Future containing the result of the UpdateModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.UpdateModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/UpdateModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateModelResponse> updateModel(UpdateModelRequest updateModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a model in the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateModelRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateModelRequest#builder()}
     * </p>
     *
     * @param updateModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.UpdateModelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.UpdateModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/UpdateModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateModelResponse> updateModel(Consumer<UpdateModelRequest.Builder> updateModelRequest) {
        return updateModel(UpdateModelRequest.builder().applyMutation(updateModelRequest).build());
    }

    /**
     * <p>
     * Updates a retraining scheduler.
     * </p>
     *
     * @param updateRetrainingSchedulerRequest
     * @return A Java Future containing the result of the UpdateRetrainingScheduler operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.UpdateRetrainingScheduler
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/UpdateRetrainingScheduler"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRetrainingSchedulerResponse> updateRetrainingScheduler(
            UpdateRetrainingSchedulerRequest updateRetrainingSchedulerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a retraining scheduler.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRetrainingSchedulerRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateRetrainingSchedulerRequest#builder()}
     * </p>
     *
     * @param updateRetrainingSchedulerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutequipment.model.UpdateRetrainingSchedulerRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateRetrainingScheduler operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy constraints specified by Amazon Lookout for Equipment
     *         or a related Amazon Web Services service that's being utilized.</li>
     *         <li>ResourceNotFoundException The resource requested could not be found. Verify the resource ID and retry
     *         your request.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have access to the
     *         resource.</li>
     *         <li>InternalServerException Processing of the request has failed because of an unknown error, exception
     *         or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutEquipmentException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutEquipmentAsyncClient.UpdateRetrainingScheduler
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/UpdateRetrainingScheduler"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRetrainingSchedulerResponse> updateRetrainingScheduler(
            Consumer<UpdateRetrainingSchedulerRequest.Builder> updateRetrainingSchedulerRequest) {
        return updateRetrainingScheduler(UpdateRetrainingSchedulerRequest.builder()
                .applyMutation(updateRetrainingSchedulerRequest).build());
    }

    @Override
    default LookoutEquipmentServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link LookoutEquipmentAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static LookoutEquipmentAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link LookoutEquipmentAsyncClient}.
     */
    static LookoutEquipmentAsyncClientBuilder builder() {
        return new DefaultLookoutEquipmentAsyncClientBuilder();
    }
}
