/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLabelGroupsResponse extends LookoutEquipmentResponse implements
        ToCopyableBuilder<ListLabelGroupsResponse.Builder, ListLabelGroupsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListLabelGroupsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<LabelGroupSummary>> LABEL_GROUP_SUMMARIES_FIELD = SdkField
            .<List<LabelGroupSummary>> builder(MarshallingType.LIST)
            .memberName("LabelGroupSummaries")
            .getter(getter(ListLabelGroupsResponse::labelGroupSummaries))
            .setter(setter(Builder::labelGroupSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelGroupSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LabelGroupSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(LabelGroupSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            LABEL_GROUP_SUMMARIES_FIELD));

    private final String nextToken;

    private final List<LabelGroupSummary> labelGroupSummaries;

    private ListLabelGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.labelGroupSummaries = builder.labelGroupSummaries;
    }

    /**
     * <p>
     * An opaque pagination token indicating where to continue the listing of label groups.
     * </p>
     * 
     * @return An opaque pagination token indicating where to continue the listing of label groups.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the LabelGroupSummaries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLabelGroupSummaries() {
        return labelGroupSummaries != null && !(labelGroupSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A summary of the label groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLabelGroupSummaries} method.
     * </p>
     * 
     * @return A summary of the label groups.
     */
    public final List<LabelGroupSummary> labelGroupSummaries() {
        return labelGroupSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasLabelGroupSummaries() ? labelGroupSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLabelGroupsResponse)) {
            return false;
        }
        ListLabelGroupsResponse other = (ListLabelGroupsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasLabelGroupSummaries() == other.hasLabelGroupSummaries()
                && Objects.equals(labelGroupSummaries(), other.labelGroupSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLabelGroupsResponse").add("NextToken", nextToken())
                .add("LabelGroupSummaries", hasLabelGroupSummaries() ? labelGroupSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "LabelGroupSummaries":
            return Optional.ofNullable(clazz.cast(labelGroupSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLabelGroupsResponse, T> g) {
        return obj -> g.apply((ListLabelGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutEquipmentResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListLabelGroupsResponse> {
        /**
         * <p>
         * An opaque pagination token indicating where to continue the listing of label groups.
         * </p>
         * 
         * @param nextToken
         *        An opaque pagination token indicating where to continue the listing of label groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A summary of the label groups.
         * </p>
         * 
         * @param labelGroupSummaries
         *        A summary of the label groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelGroupSummaries(Collection<LabelGroupSummary> labelGroupSummaries);

        /**
         * <p>
         * A summary of the label groups.
         * </p>
         * 
         * @param labelGroupSummaries
         *        A summary of the label groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelGroupSummaries(LabelGroupSummary... labelGroupSummaries);

        /**
         * <p>
         * A summary of the label groups.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lookoutequipment.model.LabelGroupSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.lookoutequipment.model.LabelGroupSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lookoutequipment.model.LabelGroupSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #labelGroupSummaries(List<LabelGroupSummary>)}.
         * 
         * @param labelGroupSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lookoutequipment.model.LabelGroupSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #labelGroupSummaries(java.util.Collection<LabelGroupSummary>)
         */
        Builder labelGroupSummaries(Consumer<LabelGroupSummary.Builder>... labelGroupSummaries);
    }

    static final class BuilderImpl extends LookoutEquipmentResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<LabelGroupSummary> labelGroupSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListLabelGroupsResponse model) {
            super(model);
            nextToken(model.nextToken);
            labelGroupSummaries(model.labelGroupSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<LabelGroupSummary.Builder> getLabelGroupSummaries() {
            List<LabelGroupSummary.Builder> result = LabelGroupSummariesCopier.copyToBuilder(this.labelGroupSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLabelGroupSummaries(Collection<LabelGroupSummary.BuilderImpl> labelGroupSummaries) {
            this.labelGroupSummaries = LabelGroupSummariesCopier.copyFromBuilder(labelGroupSummaries);
        }

        @Override
        public final Builder labelGroupSummaries(Collection<LabelGroupSummary> labelGroupSummaries) {
            this.labelGroupSummaries = LabelGroupSummariesCopier.copy(labelGroupSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labelGroupSummaries(LabelGroupSummary... labelGroupSummaries) {
            labelGroupSummaries(Arrays.asList(labelGroupSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labelGroupSummaries(Consumer<LabelGroupSummary.Builder>... labelGroupSummaries) {
            labelGroupSummaries(Stream.of(labelGroupSummaries).map(c -> LabelGroupSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListLabelGroupsResponse build() {
            return new ListLabelGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
