/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies configuration information for the input data for the data ingestion job, including input data S3 location.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IngestionInputConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<IngestionInputConfiguration.Builder, IngestionInputConfiguration> {
    private static final SdkField<IngestionS3InputConfiguration> S3_INPUT_CONFIGURATION_FIELD = SdkField
            .<IngestionS3InputConfiguration> builder(MarshallingType.SDK_POJO).memberName("S3InputConfiguration")
            .getter(getter(IngestionInputConfiguration::s3InputConfiguration)).setter(setter(Builder::s3InputConfiguration))
            .constructor(IngestionS3InputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3InputConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_INPUT_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final IngestionS3InputConfiguration s3InputConfiguration;

    private IngestionInputConfiguration(BuilderImpl builder) {
        this.s3InputConfiguration = builder.s3InputConfiguration;
    }

    /**
     * <p>
     * The location information for the S3 bucket used for input data for the data ingestion.
     * </p>
     * 
     * @return The location information for the S3 bucket used for input data for the data ingestion.
     */
    public final IngestionS3InputConfiguration s3InputConfiguration() {
        return s3InputConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3InputConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngestionInputConfiguration)) {
            return false;
        }
        IngestionInputConfiguration other = (IngestionInputConfiguration) obj;
        return Objects.equals(s3InputConfiguration(), other.s3InputConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IngestionInputConfiguration").add("S3InputConfiguration", s3InputConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3InputConfiguration":
            return Optional.ofNullable(clazz.cast(s3InputConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IngestionInputConfiguration, T> g) {
        return obj -> g.apply((IngestionInputConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IngestionInputConfiguration> {
        /**
         * <p>
         * The location information for the S3 bucket used for input data for the data ingestion.
         * </p>
         * 
         * @param s3InputConfiguration
         *        The location information for the S3 bucket used for input data for the data ingestion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3InputConfiguration(IngestionS3InputConfiguration s3InputConfiguration);

        /**
         * <p>
         * The location information for the S3 bucket used for input data for the data ingestion.
         * </p>
         * This is a convenience method that creates an instance of the {@link IngestionS3InputConfiguration.Builder}
         * avoiding the need to create one manually via {@link IngestionS3InputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IngestionS3InputConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #s3InputConfiguration(IngestionS3InputConfiguration)}.
         * 
         * @param s3InputConfiguration
         *        a consumer that will call methods on {@link IngestionS3InputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3InputConfiguration(IngestionS3InputConfiguration)
         */
        default Builder s3InputConfiguration(Consumer<IngestionS3InputConfiguration.Builder> s3InputConfiguration) {
            return s3InputConfiguration(IngestionS3InputConfiguration.builder().applyMutation(s3InputConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private IngestionS3InputConfiguration s3InputConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(IngestionInputConfiguration model) {
            s3InputConfiguration(model.s3InputConfiguration);
        }

        public final IngestionS3InputConfiguration.Builder getS3InputConfiguration() {
            return s3InputConfiguration != null ? s3InputConfiguration.toBuilder() : null;
        }

        public final void setS3InputConfiguration(IngestionS3InputConfiguration.BuilderImpl s3InputConfiguration) {
            this.s3InputConfiguration = s3InputConfiguration != null ? s3InputConfiguration.build() : null;
        }

        @Override
        public final Builder s3InputConfiguration(IngestionS3InputConfiguration s3InputConfiguration) {
            this.s3InputConfiguration = s3InputConfiguration;
            return this;
        }

        @Override
        public IngestionInputConfiguration build() {
            return new IngestionInputConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
