/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLabelResponse extends LookoutEquipmentResponse implements
        ToCopyableBuilder<DescribeLabelResponse.Builder, DescribeLabelResponse> {
    private static final SdkField<String> LABEL_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LabelGroupName").getter(getter(DescribeLabelResponse::labelGroupName))
            .setter(setter(Builder::labelGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelGroupName").build()).build();

    private static final SdkField<String> LABEL_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LabelGroupArn").getter(getter(DescribeLabelResponse::labelGroupArn))
            .setter(setter(Builder::labelGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelGroupArn").build()).build();

    private static final SdkField<String> LABEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LabelId").getter(getter(DescribeLabelResponse::labelId)).setter(setter(Builder::labelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelId").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(DescribeLabelResponse::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(DescribeLabelResponse::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<String> RATING_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Rating")
            .getter(getter(DescribeLabelResponse::ratingAsString)).setter(setter(Builder::rating))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rating").build()).build();

    private static final SdkField<String> FAULT_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FaultCode").getter(getter(DescribeLabelResponse::faultCode)).setter(setter(Builder::faultCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaultCode").build()).build();

    private static final SdkField<String> NOTES_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Notes")
            .getter(getter(DescribeLabelResponse::notes)).setter(setter(Builder::notes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notes").build()).build();

    private static final SdkField<String> EQUIPMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Equipment").getter(getter(DescribeLabelResponse::equipment)).setter(setter(Builder::equipment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Equipment").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(DescribeLabelResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABEL_GROUP_NAME_FIELD,
            LABEL_GROUP_ARN_FIELD, LABEL_ID_FIELD, START_TIME_FIELD, END_TIME_FIELD, RATING_FIELD, FAULT_CODE_FIELD, NOTES_FIELD,
            EQUIPMENT_FIELD, CREATED_AT_FIELD));

    private final String labelGroupName;

    private final String labelGroupArn;

    private final String labelId;

    private final Instant startTime;

    private final Instant endTime;

    private final String rating;

    private final String faultCode;

    private final String notes;

    private final String equipment;

    private final Instant createdAt;

    private DescribeLabelResponse(BuilderImpl builder) {
        super(builder);
        this.labelGroupName = builder.labelGroupName;
        this.labelGroupArn = builder.labelGroupArn;
        this.labelId = builder.labelId;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.rating = builder.rating;
        this.faultCode = builder.faultCode;
        this.notes = builder.notes;
        this.equipment = builder.equipment;
        this.createdAt = builder.createdAt;
    }

    /**
     * <p>
     * The name of the requested label group.
     * </p>
     * 
     * @return The name of the requested label group.
     */
    public final String labelGroupName() {
        return labelGroupName;
    }

    /**
     * <p>
     * The ARN of the requested label group.
     * </p>
     * 
     * @return The ARN of the requested label group.
     */
    public final String labelGroupArn() {
        return labelGroupArn;
    }

    /**
     * <p>
     * The ID of the requested label.
     * </p>
     * 
     * @return The ID of the requested label.
     */
    public final String labelId() {
        return labelId;
    }

    /**
     * <p>
     * The start time of the requested label.
     * </p>
     * 
     * @return The start time of the requested label.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end time of the requested label.
     * </p>
     * 
     * @return The end time of the requested label.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * Indicates whether a labeled event represents an anomaly.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rating} will
     * return {@link LabelRating#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ratingAsString}.
     * </p>
     * 
     * @return Indicates whether a labeled event represents an anomaly.
     * @see LabelRating
     */
    public final LabelRating rating() {
        return LabelRating.fromValue(rating);
    }

    /**
     * <p>
     * Indicates whether a labeled event represents an anomaly.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rating} will
     * return {@link LabelRating#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ratingAsString}.
     * </p>
     * 
     * @return Indicates whether a labeled event represents an anomaly.
     * @see LabelRating
     */
    public final String ratingAsString() {
        return rating;
    }

    /**
     * <p>
     * Indicates the type of anomaly associated with the label.
     * </p>
     * <p>
     * Data in this field will be retained for service usage. Follow best practices for the security of your data.
     * </p>
     * 
     * @return Indicates the type of anomaly associated with the label. </p>
     *         <p>
     *         Data in this field will be retained for service usage. Follow best practices for the security of your
     *         data.
     */
    public final String faultCode() {
        return faultCode;
    }

    /**
     * <p>
     * Metadata providing additional information about the label.
     * </p>
     * <p>
     * Data in this field will be retained for service usage. Follow best practices for the security of your data.
     * </p>
     * 
     * @return Metadata providing additional information about the label.</p>
     *         <p>
     *         Data in this field will be retained for service usage. Follow best practices for the security of your
     *         data.
     */
    public final String notes() {
        return notes;
    }

    /**
     * <p>
     * Indicates that a label pertains to a particular piece of equipment.
     * </p>
     * 
     * @return Indicates that a label pertains to a particular piece of equipment.
     */
    public final String equipment() {
        return equipment;
    }

    /**
     * <p>
     * The time at which the label was created.
     * </p>
     * 
     * @return The time at which the label was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(labelGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(labelGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(labelId());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(ratingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(faultCode());
        hashCode = 31 * hashCode + Objects.hashCode(notes());
        hashCode = 31 * hashCode + Objects.hashCode(equipment());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLabelResponse)) {
            return false;
        }
        DescribeLabelResponse other = (DescribeLabelResponse) obj;
        return Objects.equals(labelGroupName(), other.labelGroupName()) && Objects.equals(labelGroupArn(), other.labelGroupArn())
                && Objects.equals(labelId(), other.labelId()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(ratingAsString(), other.ratingAsString())
                && Objects.equals(faultCode(), other.faultCode()) && Objects.equals(notes(), other.notes())
                && Objects.equals(equipment(), other.equipment()) && Objects.equals(createdAt(), other.createdAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeLabelResponse").add("LabelGroupName", labelGroupName())
                .add("LabelGroupArn", labelGroupArn()).add("LabelId", labelId()).add("StartTime", startTime())
                .add("EndTime", endTime()).add("Rating", ratingAsString()).add("FaultCode", faultCode()).add("Notes", notes())
                .add("Equipment", equipment()).add("CreatedAt", createdAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LabelGroupName":
            return Optional.ofNullable(clazz.cast(labelGroupName()));
        case "LabelGroupArn":
            return Optional.ofNullable(clazz.cast(labelGroupArn()));
        case "LabelId":
            return Optional.ofNullable(clazz.cast(labelId()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "Rating":
            return Optional.ofNullable(clazz.cast(ratingAsString()));
        case "FaultCode":
            return Optional.ofNullable(clazz.cast(faultCode()));
        case "Notes":
            return Optional.ofNullable(clazz.cast(notes()));
        case "Equipment":
            return Optional.ofNullable(clazz.cast(equipment()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLabelResponse, T> g) {
        return obj -> g.apply((DescribeLabelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutEquipmentResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeLabelResponse> {
        /**
         * <p>
         * The name of the requested label group.
         * </p>
         * 
         * @param labelGroupName
         *        The name of the requested label group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelGroupName(String labelGroupName);

        /**
         * <p>
         * The ARN of the requested label group.
         * </p>
         * 
         * @param labelGroupArn
         *        The ARN of the requested label group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelGroupArn(String labelGroupArn);

        /**
         * <p>
         * The ID of the requested label.
         * </p>
         * 
         * @param labelId
         *        The ID of the requested label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelId(String labelId);

        /**
         * <p>
         * The start time of the requested label.
         * </p>
         * 
         * @param startTime
         *        The start time of the requested label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The end time of the requested label.
         * </p>
         * 
         * @param endTime
         *        The end time of the requested label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * Indicates whether a labeled event represents an anomaly.
         * </p>
         * 
         * @param rating
         *        Indicates whether a labeled event represents an anomaly.
         * @see LabelRating
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LabelRating
         */
        Builder rating(String rating);

        /**
         * <p>
         * Indicates whether a labeled event represents an anomaly.
         * </p>
         * 
         * @param rating
         *        Indicates whether a labeled event represents an anomaly.
         * @see LabelRating
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LabelRating
         */
        Builder rating(LabelRating rating);

        /**
         * <p>
         * Indicates the type of anomaly associated with the label.
         * </p>
         * <p>
         * Data in this field will be retained for service usage. Follow best practices for the security of your data.
         * </p>
         * 
         * @param faultCode
         *        Indicates the type of anomaly associated with the label. </p>
         *        <p>
         *        Data in this field will be retained for service usage. Follow best practices for the security of your
         *        data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faultCode(String faultCode);

        /**
         * <p>
         * Metadata providing additional information about the label.
         * </p>
         * <p>
         * Data in this field will be retained for service usage. Follow best practices for the security of your data.
         * </p>
         * 
         * @param notes
         *        Metadata providing additional information about the label.</p>
         *        <p>
         *        Data in this field will be retained for service usage. Follow best practices for the security of your
         *        data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notes(String notes);

        /**
         * <p>
         * Indicates that a label pertains to a particular piece of equipment.
         * </p>
         * 
         * @param equipment
         *        Indicates that a label pertains to a particular piece of equipment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder equipment(String equipment);

        /**
         * <p>
         * The time at which the label was created.
         * </p>
         * 
         * @param createdAt
         *        The time at which the label was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);
    }

    static final class BuilderImpl extends LookoutEquipmentResponse.BuilderImpl implements Builder {
        private String labelGroupName;

        private String labelGroupArn;

        private String labelId;

        private Instant startTime;

        private Instant endTime;

        private String rating;

        private String faultCode;

        private String notes;

        private String equipment;

        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLabelResponse model) {
            super(model);
            labelGroupName(model.labelGroupName);
            labelGroupArn(model.labelGroupArn);
            labelId(model.labelId);
            startTime(model.startTime);
            endTime(model.endTime);
            rating(model.rating);
            faultCode(model.faultCode);
            notes(model.notes);
            equipment(model.equipment);
            createdAt(model.createdAt);
        }

        public final String getLabelGroupName() {
            return labelGroupName;
        }

        public final void setLabelGroupName(String labelGroupName) {
            this.labelGroupName = labelGroupName;
        }

        @Override
        public final Builder labelGroupName(String labelGroupName) {
            this.labelGroupName = labelGroupName;
            return this;
        }

        public final String getLabelGroupArn() {
            return labelGroupArn;
        }

        public final void setLabelGroupArn(String labelGroupArn) {
            this.labelGroupArn = labelGroupArn;
        }

        @Override
        public final Builder labelGroupArn(String labelGroupArn) {
            this.labelGroupArn = labelGroupArn;
            return this;
        }

        public final String getLabelId() {
            return labelId;
        }

        public final void setLabelId(String labelId) {
            this.labelId = labelId;
        }

        @Override
        public final Builder labelId(String labelId) {
            this.labelId = labelId;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getRating() {
            return rating;
        }

        public final void setRating(String rating) {
            this.rating = rating;
        }

        @Override
        public final Builder rating(String rating) {
            this.rating = rating;
            return this;
        }

        @Override
        public final Builder rating(LabelRating rating) {
            this.rating(rating == null ? null : rating.toString());
            return this;
        }

        public final String getFaultCode() {
            return faultCode;
        }

        public final void setFaultCode(String faultCode) {
            this.faultCode = faultCode;
        }

        @Override
        public final Builder faultCode(String faultCode) {
            this.faultCode = faultCode;
            return this;
        }

        public final String getNotes() {
            return notes;
        }

        public final void setNotes(String notes) {
            this.notes = notes;
        }

        @Override
        public final Builder notes(String notes) {
            this.notes = notes;
            return this;
        }

        public final String getEquipment() {
            return equipment;
        }

        public final void setEquipment(String equipment) {
            this.equipment = equipment;
        }

        @Override
        public final Builder equipment(String equipment) {
            this.equipment = equipment;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public DescribeLabelResponse build() {
            return new DescribeLabelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
