/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDatasetResponse extends LookoutEquipmentResponse implements
        ToCopyableBuilder<DescribeDatasetResponse.Builder, DescribeDatasetResponse> {
    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetName").getter(getter(DescribeDatasetResponse::datasetName)).setter(setter(Builder::datasetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetName").build()).build();

    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetArn").getter(getter(DescribeDatasetResponse::datasetArn)).setter(setter(Builder::datasetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetArn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(DescribeDatasetResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedAt").getter(getter(DescribeDatasetResponse::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeDatasetResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> SCHEMA_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Schema")
            .getter(getter(DescribeDatasetResponse::schema))
            .setter(setter(Builder::schema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build(),
                    JsonValueTrait.create()).build();

    private static final SdkField<String> SERVER_SIDE_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerSideKmsKeyId").getter(getter(DescribeDatasetResponse::serverSideKmsKeyId))
            .setter(setter(Builder::serverSideKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerSideKmsKeyId").build())
            .build();

    private static final SdkField<IngestionInputConfiguration> INGESTION_INPUT_CONFIGURATION_FIELD = SdkField
            .<IngestionInputConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("IngestionInputConfiguration")
            .getter(getter(DescribeDatasetResponse::ingestionInputConfiguration))
            .setter(setter(Builder::ingestionInputConfiguration))
            .constructor(IngestionInputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngestionInputConfiguration")
                    .build()).build();

    private static final SdkField<DataQualitySummary> DATA_QUALITY_SUMMARY_FIELD = SdkField
            .<DataQualitySummary> builder(MarshallingType.SDK_POJO).memberName("DataQualitySummary")
            .getter(getter(DescribeDatasetResponse::dataQualitySummary)).setter(setter(Builder::dataQualitySummary))
            .constructor(DataQualitySummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataQualitySummary").build())
            .build();

    private static final SdkField<IngestedFilesSummary> INGESTED_FILES_SUMMARY_FIELD = SdkField
            .<IngestedFilesSummary> builder(MarshallingType.SDK_POJO).memberName("IngestedFilesSummary")
            .getter(getter(DescribeDatasetResponse::ingestedFilesSummary)).setter(setter(Builder::ingestedFilesSummary))
            .constructor(IngestedFilesSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngestedFilesSummary").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(DescribeDatasetResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<Instant> DATA_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DataStartTime").getter(getter(DescribeDatasetResponse::dataStartTime))
            .setter(setter(Builder::dataStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataStartTime").build()).build();

    private static final SdkField<Instant> DATA_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DataEndTime").getter(getter(DescribeDatasetResponse::dataEndTime)).setter(setter(Builder::dataEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataEndTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_NAME_FIELD,
            DATASET_ARN_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, STATUS_FIELD, SCHEMA_FIELD, SERVER_SIDE_KMS_KEY_ID_FIELD,
            INGESTION_INPUT_CONFIGURATION_FIELD, DATA_QUALITY_SUMMARY_FIELD, INGESTED_FILES_SUMMARY_FIELD, ROLE_ARN_FIELD,
            DATA_START_TIME_FIELD, DATA_END_TIME_FIELD));

    private final String datasetName;

    private final String datasetArn;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private final String status;

    private final String schema;

    private final String serverSideKmsKeyId;

    private final IngestionInputConfiguration ingestionInputConfiguration;

    private final DataQualitySummary dataQualitySummary;

    private final IngestedFilesSummary ingestedFilesSummary;

    private final String roleArn;

    private final Instant dataStartTime;

    private final Instant dataEndTime;

    private DescribeDatasetResponse(BuilderImpl builder) {
        super(builder);
        this.datasetName = builder.datasetName;
        this.datasetArn = builder.datasetArn;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.status = builder.status;
        this.schema = builder.schema;
        this.serverSideKmsKeyId = builder.serverSideKmsKeyId;
        this.ingestionInputConfiguration = builder.ingestionInputConfiguration;
        this.dataQualitySummary = builder.dataQualitySummary;
        this.ingestedFilesSummary = builder.ingestedFilesSummary;
        this.roleArn = builder.roleArn;
        this.dataStartTime = builder.dataStartTime;
        this.dataEndTime = builder.dataEndTime;
    }

    /**
     * <p>
     * The name of the dataset being described.
     * </p>
     * 
     * @return The name of the dataset being described.
     */
    public final String datasetName() {
        return datasetName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the dataset being described.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the dataset being described.
     */
    public final String datasetArn() {
        return datasetArn;
    }

    /**
     * <p>
     * Specifies the time the dataset was created in Lookout for Equipment.
     * </p>
     * 
     * @return Specifies the time the dataset was created in Lookout for Equipment.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Specifies the time the dataset was last updated, if it was.
     * </p>
     * 
     * @return Specifies the time the dataset was last updated, if it was.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * Indicates the status of the dataset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DatasetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates the status of the dataset.
     * @see DatasetStatus
     */
    public final DatasetStatus status() {
        return DatasetStatus.fromValue(status);
    }

    /**
     * <p>
     * Indicates the status of the dataset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DatasetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates the status of the dataset.
     * @see DatasetStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A JSON description of the data that is in each time series dataset, including names, column names, and data
     * types.
     * </p>
     * 
     * @return A JSON description of the data that is in each time series dataset, including names, column names, and
     *         data types.
     */
    public final String schema() {
        return schema;
    }

    /**
     * <p>
     * Provides the identifier of the KMS key used to encrypt dataset data by Amazon Lookout for Equipment.
     * </p>
     * 
     * @return Provides the identifier of the KMS key used to encrypt dataset data by Amazon Lookout for Equipment.
     */
    public final String serverSideKmsKeyId() {
        return serverSideKmsKeyId;
    }

    /**
     * <p>
     * Specifies the S3 location configuration for the data input for the data ingestion job.
     * </p>
     * 
     * @return Specifies the S3 location configuration for the data input for the data ingestion job.
     */
    public final IngestionInputConfiguration ingestionInputConfiguration() {
        return ingestionInputConfiguration;
    }

    /**
     * <p>
     * Gives statistics associated with the given dataset for the latest successful associated ingestion job id. These
     * statistics primarily relate to quantifying incorrect data such as MissingCompleteSensorData, MissingSensorData,
     * UnsupportedDateFormats, InsufficientSensorData, and DuplicateTimeStamps.
     * </p>
     * 
     * @return Gives statistics associated with the given dataset for the latest successful associated ingestion job id.
     *         These statistics primarily relate to quantifying incorrect data such as MissingCompleteSensorData,
     *         MissingSensorData, UnsupportedDateFormats, InsufficientSensorData, and DuplicateTimeStamps.
     */
    public final DataQualitySummary dataQualitySummary() {
        return dataQualitySummary;
    }

    /**
     * <p>
     * IngestedFilesSummary associated with the given dataset for the latest successful associated ingestion job id.
     * </p>
     * 
     * @return IngestedFilesSummary associated with the given dataset for the latest successful associated ingestion job
     *         id.
     */
    public final IngestedFilesSummary ingestedFilesSummary() {
        return ingestedFilesSummary;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that you are using for this the data ingestion job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that you are using for this the data ingestion job.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * Indicates the earliest timestamp corresponding to data that was successfully ingested during the most recent
     * ingestion of this particular dataset.
     * </p>
     * 
     * @return Indicates the earliest timestamp corresponding to data that was successfully ingested during the most
     *         recent ingestion of this particular dataset.
     */
    public final Instant dataStartTime() {
        return dataStartTime;
    }

    /**
     * <p>
     * Indicates the latest timestamp corresponding to data that was successfully ingested during the most recent
     * ingestion of this particular dataset.
     * </p>
     * 
     * @return Indicates the latest timestamp corresponding to data that was successfully ingested during the most
     *         recent ingestion of this particular dataset.
     */
    public final Instant dataEndTime() {
        return dataEndTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(schema());
        hashCode = 31 * hashCode + Objects.hashCode(serverSideKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(ingestionInputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(dataQualitySummary());
        hashCode = 31 * hashCode + Objects.hashCode(ingestedFilesSummary());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(dataStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(dataEndTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDatasetResponse)) {
            return false;
        }
        DescribeDatasetResponse other = (DescribeDatasetResponse) obj;
        return Objects.equals(datasetName(), other.datasetName()) && Objects.equals(datasetArn(), other.datasetArn())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(schema(), other.schema())
                && Objects.equals(serverSideKmsKeyId(), other.serverSideKmsKeyId())
                && Objects.equals(ingestionInputConfiguration(), other.ingestionInputConfiguration())
                && Objects.equals(dataQualitySummary(), other.dataQualitySummary())
                && Objects.equals(ingestedFilesSummary(), other.ingestedFilesSummary())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(dataStartTime(), other.dataStartTime())
                && Objects.equals(dataEndTime(), other.dataEndTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDatasetResponse").add("DatasetName", datasetName()).add("DatasetArn", datasetArn())
                .add("CreatedAt", createdAt()).add("LastUpdatedAt", lastUpdatedAt()).add("Status", statusAsString())
                .add("Schema", schema()).add("ServerSideKmsKeyId", serverSideKmsKeyId())
                .add("IngestionInputConfiguration", ingestionInputConfiguration())
                .add("DataQualitySummary", dataQualitySummary()).add("IngestedFilesSummary", ingestedFilesSummary())
                .add("RoleArn", roleArn()).add("DataStartTime", dataStartTime()).add("DataEndTime", dataEndTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatasetName":
            return Optional.ofNullable(clazz.cast(datasetName()));
        case "DatasetArn":
            return Optional.ofNullable(clazz.cast(datasetArn()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "LastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Schema":
            return Optional.ofNullable(clazz.cast(schema()));
        case "ServerSideKmsKeyId":
            return Optional.ofNullable(clazz.cast(serverSideKmsKeyId()));
        case "IngestionInputConfiguration":
            return Optional.ofNullable(clazz.cast(ingestionInputConfiguration()));
        case "DataQualitySummary":
            return Optional.ofNullable(clazz.cast(dataQualitySummary()));
        case "IngestedFilesSummary":
            return Optional.ofNullable(clazz.cast(ingestedFilesSummary()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "DataStartTime":
            return Optional.ofNullable(clazz.cast(dataStartTime()));
        case "DataEndTime":
            return Optional.ofNullable(clazz.cast(dataEndTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDatasetResponse, T> g) {
        return obj -> g.apply((DescribeDatasetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutEquipmentResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDatasetResponse> {
        /**
         * <p>
         * The name of the dataset being described.
         * </p>
         * 
         * @param datasetName
         *        The name of the dataset being described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetName(String datasetName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the dataset being described.
         * </p>
         * 
         * @param datasetArn
         *        The Amazon Resource Name (ARN) of the dataset being described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetArn(String datasetArn);

        /**
         * <p>
         * Specifies the time the dataset was created in Lookout for Equipment.
         * </p>
         * 
         * @param createdAt
         *        Specifies the time the dataset was created in Lookout for Equipment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Specifies the time the dataset was last updated, if it was.
         * </p>
         * 
         * @param lastUpdatedAt
         *        Specifies the time the dataset was last updated, if it was.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * Indicates the status of the dataset.
         * </p>
         * 
         * @param status
         *        Indicates the status of the dataset.
         * @see DatasetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Indicates the status of the dataset.
         * </p>
         * 
         * @param status
         *        Indicates the status of the dataset.
         * @see DatasetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetStatus
         */
        Builder status(DatasetStatus status);

        /**
         * <p>
         * A JSON description of the data that is in each time series dataset, including names, column names, and data
         * types.
         * </p>
         * 
         * @param schema
         *        A JSON description of the data that is in each time series dataset, including names, column names, and
         *        data types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(String schema);

        /**
         * <p>
         * Provides the identifier of the KMS key used to encrypt dataset data by Amazon Lookout for Equipment.
         * </p>
         * 
         * @param serverSideKmsKeyId
         *        Provides the identifier of the KMS key used to encrypt dataset data by Amazon Lookout for Equipment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverSideKmsKeyId(String serverSideKmsKeyId);

        /**
         * <p>
         * Specifies the S3 location configuration for the data input for the data ingestion job.
         * </p>
         * 
         * @param ingestionInputConfiguration
         *        Specifies the S3 location configuration for the data input for the data ingestion job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestionInputConfiguration(IngestionInputConfiguration ingestionInputConfiguration);

        /**
         * <p>
         * Specifies the S3 location configuration for the data input for the data ingestion job.
         * </p>
         * This is a convenience method that creates an instance of the {@link IngestionInputConfiguration.Builder}
         * avoiding the need to create one manually via {@link IngestionInputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IngestionInputConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #ingestionInputConfiguration(IngestionInputConfiguration)}.
         * 
         * @param ingestionInputConfiguration
         *        a consumer that will call methods on {@link IngestionInputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ingestionInputConfiguration(IngestionInputConfiguration)
         */
        default Builder ingestionInputConfiguration(Consumer<IngestionInputConfiguration.Builder> ingestionInputConfiguration) {
            return ingestionInputConfiguration(IngestionInputConfiguration.builder().applyMutation(ingestionInputConfiguration)
                    .build());
        }

        /**
         * <p>
         * Gives statistics associated with the given dataset for the latest successful associated ingestion job id.
         * These statistics primarily relate to quantifying incorrect data such as MissingCompleteSensorData,
         * MissingSensorData, UnsupportedDateFormats, InsufficientSensorData, and DuplicateTimeStamps.
         * </p>
         * 
         * @param dataQualitySummary
         *        Gives statistics associated with the given dataset for the latest successful associated ingestion job
         *        id. These statistics primarily relate to quantifying incorrect data such as MissingCompleteSensorData,
         *        MissingSensorData, UnsupportedDateFormats, InsufficientSensorData, and DuplicateTimeStamps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataQualitySummary(DataQualitySummary dataQualitySummary);

        /**
         * <p>
         * Gives statistics associated with the given dataset for the latest successful associated ingestion job id.
         * These statistics primarily relate to quantifying incorrect data such as MissingCompleteSensorData,
         * MissingSensorData, UnsupportedDateFormats, InsufficientSensorData, and DuplicateTimeStamps.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataQualitySummary.Builder} avoiding the
         * need to create one manually via {@link DataQualitySummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataQualitySummary.Builder#build()} is called immediately and its
         * result is passed to {@link #dataQualitySummary(DataQualitySummary)}.
         * 
         * @param dataQualitySummary
         *        a consumer that will call methods on {@link DataQualitySummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataQualitySummary(DataQualitySummary)
         */
        default Builder dataQualitySummary(Consumer<DataQualitySummary.Builder> dataQualitySummary) {
            return dataQualitySummary(DataQualitySummary.builder().applyMutation(dataQualitySummary).build());
        }

        /**
         * <p>
         * IngestedFilesSummary associated with the given dataset for the latest successful associated ingestion job id.
         * </p>
         * 
         * @param ingestedFilesSummary
         *        IngestedFilesSummary associated with the given dataset for the latest successful associated ingestion
         *        job id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestedFilesSummary(IngestedFilesSummary ingestedFilesSummary);

        /**
         * <p>
         * IngestedFilesSummary associated with the given dataset for the latest successful associated ingestion job id.
         * </p>
         * This is a convenience method that creates an instance of the {@link IngestedFilesSummary.Builder} avoiding
         * the need to create one manually via {@link IngestedFilesSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IngestedFilesSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #ingestedFilesSummary(IngestedFilesSummary)}.
         * 
         * @param ingestedFilesSummary
         *        a consumer that will call methods on {@link IngestedFilesSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ingestedFilesSummary(IngestedFilesSummary)
         */
        default Builder ingestedFilesSummary(Consumer<IngestedFilesSummary.Builder> ingestedFilesSummary) {
            return ingestedFilesSummary(IngestedFilesSummary.builder().applyMutation(ingestedFilesSummary).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that you are using for this the data ingestion job.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role that you are using for this the data ingestion job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Indicates the earliest timestamp corresponding to data that was successfully ingested during the most recent
         * ingestion of this particular dataset.
         * </p>
         * 
         * @param dataStartTime
         *        Indicates the earliest timestamp corresponding to data that was successfully ingested during the most
         *        recent ingestion of this particular dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataStartTime(Instant dataStartTime);

        /**
         * <p>
         * Indicates the latest timestamp corresponding to data that was successfully ingested during the most recent
         * ingestion of this particular dataset.
         * </p>
         * 
         * @param dataEndTime
         *        Indicates the latest timestamp corresponding to data that was successfully ingested during the most
         *        recent ingestion of this particular dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataEndTime(Instant dataEndTime);
    }

    static final class BuilderImpl extends LookoutEquipmentResponse.BuilderImpl implements Builder {
        private String datasetName;

        private String datasetArn;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private String status;

        private String schema;

        private String serverSideKmsKeyId;

        private IngestionInputConfiguration ingestionInputConfiguration;

        private DataQualitySummary dataQualitySummary;

        private IngestedFilesSummary ingestedFilesSummary;

        private String roleArn;

        private Instant dataStartTime;

        private Instant dataEndTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDatasetResponse model) {
            super(model);
            datasetName(model.datasetName);
            datasetArn(model.datasetArn);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
            status(model.status);
            schema(model.schema);
            serverSideKmsKeyId(model.serverSideKmsKeyId);
            ingestionInputConfiguration(model.ingestionInputConfiguration);
            dataQualitySummary(model.dataQualitySummary);
            ingestedFilesSummary(model.ingestedFilesSummary);
            roleArn(model.roleArn);
            dataStartTime(model.dataStartTime);
            dataEndTime(model.dataEndTime);
        }

        public final String getDatasetName() {
            return datasetName;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final String getDatasetArn() {
            return datasetArn;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DatasetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getSchema() {
            return schema;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        @Override
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public final String getServerSideKmsKeyId() {
            return serverSideKmsKeyId;
        }

        public final void setServerSideKmsKeyId(String serverSideKmsKeyId) {
            this.serverSideKmsKeyId = serverSideKmsKeyId;
        }

        @Override
        public final Builder serverSideKmsKeyId(String serverSideKmsKeyId) {
            this.serverSideKmsKeyId = serverSideKmsKeyId;
            return this;
        }

        public final IngestionInputConfiguration.Builder getIngestionInputConfiguration() {
            return ingestionInputConfiguration != null ? ingestionInputConfiguration.toBuilder() : null;
        }

        public final void setIngestionInputConfiguration(IngestionInputConfiguration.BuilderImpl ingestionInputConfiguration) {
            this.ingestionInputConfiguration = ingestionInputConfiguration != null ? ingestionInputConfiguration.build() : null;
        }

        @Override
        public final Builder ingestionInputConfiguration(IngestionInputConfiguration ingestionInputConfiguration) {
            this.ingestionInputConfiguration = ingestionInputConfiguration;
            return this;
        }

        public final DataQualitySummary.Builder getDataQualitySummary() {
            return dataQualitySummary != null ? dataQualitySummary.toBuilder() : null;
        }

        public final void setDataQualitySummary(DataQualitySummary.BuilderImpl dataQualitySummary) {
            this.dataQualitySummary = dataQualitySummary != null ? dataQualitySummary.build() : null;
        }

        @Override
        public final Builder dataQualitySummary(DataQualitySummary dataQualitySummary) {
            this.dataQualitySummary = dataQualitySummary;
            return this;
        }

        public final IngestedFilesSummary.Builder getIngestedFilesSummary() {
            return ingestedFilesSummary != null ? ingestedFilesSummary.toBuilder() : null;
        }

        public final void setIngestedFilesSummary(IngestedFilesSummary.BuilderImpl ingestedFilesSummary) {
            this.ingestedFilesSummary = ingestedFilesSummary != null ? ingestedFilesSummary.build() : null;
        }

        @Override
        public final Builder ingestedFilesSummary(IngestedFilesSummary ingestedFilesSummary) {
            this.ingestedFilesSummary = ingestedFilesSummary;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Instant getDataStartTime() {
            return dataStartTime;
        }

        public final void setDataStartTime(Instant dataStartTime) {
            this.dataStartTime = dataStartTime;
        }

        @Override
        public final Builder dataStartTime(Instant dataStartTime) {
            this.dataStartTime = dataStartTime;
            return this;
        }

        public final Instant getDataEndTime() {
            return dataEndTime;
        }

        public final void setDataEndTime(Instant dataEndTime) {
            this.dataEndTime = dataEndTime;
        }

        @Override
        public final Builder dataEndTime(Instant dataEndTime) {
            this.dataEndTime = dataEndTime;
            return this;
        }

        @Override
        public DescribeDatasetResponse build() {
            return new DescribeDatasetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
