/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lookoutequipment.model.FaultCodesCopier;
import software.amazon.awssdk.services.lookoutequipment.model.LookoutEquipmentRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateLabelGroupRequest
extends LookoutEquipmentRequest
implements ToCopyableBuilder<Builder, UpdateLabelGroupRequest> {
    private static final SdkField<String> LABEL_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LabelGroupName").getter(UpdateLabelGroupRequest.getter(UpdateLabelGroupRequest::labelGroupName)).setter(UpdateLabelGroupRequest.setter(Builder::labelGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelGroupName").build()}).build();
    private static final SdkField<List<String>> FAULT_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FaultCodes").getter(UpdateLabelGroupRequest.getter(UpdateLabelGroupRequest::faultCodes)).setter(UpdateLabelGroupRequest.setter(Builder::faultCodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaultCodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABEL_GROUP_NAME_FIELD, FAULT_CODES_FIELD));
    private final String labelGroupName;
    private final List<String> faultCodes;

    private UpdateLabelGroupRequest(BuilderImpl builder) {
        super(builder);
        this.labelGroupName = builder.labelGroupName;
        this.faultCodes = builder.faultCodes;
    }

    public final String labelGroupName() {
        return this.labelGroupName;
    }

    public final boolean hasFaultCodes() {
        return this.faultCodes != null && !(this.faultCodes instanceof SdkAutoConstructList);
    }

    public final List<String> faultCodes() {
        return this.faultCodes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.labelGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFaultCodes() ? this.faultCodes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLabelGroupRequest)) {
            return false;
        }
        UpdateLabelGroupRequest other = (UpdateLabelGroupRequest)((Object)obj);
        return Objects.equals(this.labelGroupName(), other.labelGroupName()) && this.hasFaultCodes() == other.hasFaultCodes() && Objects.equals(this.faultCodes(), other.faultCodes());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateLabelGroupRequest").add("LabelGroupName", (Object)this.labelGroupName()).add("FaultCodes", this.hasFaultCodes() ? this.faultCodes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LabelGroupName": {
                return Optional.ofNullable(clazz.cast(this.labelGroupName()));
            }
            case "FaultCodes": {
                return Optional.ofNullable(clazz.cast(this.faultCodes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLabelGroupRequest, T> g) {
        return obj -> g.apply((UpdateLabelGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutEquipmentRequest.BuilderImpl
    implements Builder {
        private String labelGroupName;
        private List<String> faultCodes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLabelGroupRequest model) {
            super(model);
            this.labelGroupName(model.labelGroupName);
            this.faultCodes(model.faultCodes);
        }

        public final String getLabelGroupName() {
            return this.labelGroupName;
        }

        public final void setLabelGroupName(String labelGroupName) {
            this.labelGroupName = labelGroupName;
        }

        @Override
        public final Builder labelGroupName(String labelGroupName) {
            this.labelGroupName = labelGroupName;
            return this;
        }

        public final Collection<String> getFaultCodes() {
            if (this.faultCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.faultCodes;
        }

        public final void setFaultCodes(Collection<String> faultCodes) {
            this.faultCodes = FaultCodesCopier.copy(faultCodes);
        }

        @Override
        public final Builder faultCodes(Collection<String> faultCodes) {
            this.faultCodes = FaultCodesCopier.copy(faultCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faultCodes(String ... faultCodes) {
            this.faultCodes(Arrays.asList(faultCodes));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLabelGroupRequest build() {
            return new UpdateLabelGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LookoutEquipmentRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateLabelGroupRequest> {
        public Builder labelGroupName(String var1);

        public Builder faultCodes(Collection<String> var1);

        public Builder faultCodes(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

