/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Entity that comprises aggregated information on sensors having insufficient data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvalidSensorData implements SdkPojo, Serializable,
        ToCopyableBuilder<InvalidSensorData.Builder, InvalidSensorData> {
    private static final SdkField<Integer> AFFECTED_SENSOR_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AffectedSensorCount").getter(getter(InvalidSensorData::affectedSensorCount))
            .setter(setter(Builder::affectedSensorCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AffectedSensorCount").build())
            .build();

    private static final SdkField<Integer> TOTAL_NUMBER_OF_INVALID_VALUES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalNumberOfInvalidValues")
            .getter(getter(InvalidSensorData::totalNumberOfInvalidValues))
            .setter(setter(Builder::totalNumberOfInvalidValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalNumberOfInvalidValues").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AFFECTED_SENSOR_COUNT_FIELD,
            TOTAL_NUMBER_OF_INVALID_VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer affectedSensorCount;

    private final Integer totalNumberOfInvalidValues;

    private InvalidSensorData(BuilderImpl builder) {
        this.affectedSensorCount = builder.affectedSensorCount;
        this.totalNumberOfInvalidValues = builder.totalNumberOfInvalidValues;
    }

    /**
     * <p>
     * Indicates the number of sensors that have at least some invalid values.
     * </p>
     * 
     * @return Indicates the number of sensors that have at least some invalid values.
     */
    public final Integer affectedSensorCount() {
        return affectedSensorCount;
    }

    /**
     * <p>
     * Indicates the total number of invalid values across all the sensors.
     * </p>
     * 
     * @return Indicates the total number of invalid values across all the sensors.
     */
    public final Integer totalNumberOfInvalidValues() {
        return totalNumberOfInvalidValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(affectedSensorCount());
        hashCode = 31 * hashCode + Objects.hashCode(totalNumberOfInvalidValues());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvalidSensorData)) {
            return false;
        }
        InvalidSensorData other = (InvalidSensorData) obj;
        return Objects.equals(affectedSensorCount(), other.affectedSensorCount())
                && Objects.equals(totalNumberOfInvalidValues(), other.totalNumberOfInvalidValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvalidSensorData").add("AffectedSensorCount", affectedSensorCount())
                .add("TotalNumberOfInvalidValues", totalNumberOfInvalidValues()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AffectedSensorCount":
            return Optional.ofNullable(clazz.cast(affectedSensorCount()));
        case "TotalNumberOfInvalidValues":
            return Optional.ofNullable(clazz.cast(totalNumberOfInvalidValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InvalidSensorData, T> g) {
        return obj -> g.apply((InvalidSensorData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InvalidSensorData> {
        /**
         * <p>
         * Indicates the number of sensors that have at least some invalid values.
         * </p>
         * 
         * @param affectedSensorCount
         *        Indicates the number of sensors that have at least some invalid values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder affectedSensorCount(Integer affectedSensorCount);

        /**
         * <p>
         * Indicates the total number of invalid values across all the sensors.
         * </p>
         * 
         * @param totalNumberOfInvalidValues
         *        Indicates the total number of invalid values across all the sensors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalNumberOfInvalidValues(Integer totalNumberOfInvalidValues);
    }

    static final class BuilderImpl implements Builder {
        private Integer affectedSensorCount;

        private Integer totalNumberOfInvalidValues;

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidSensorData model) {
            affectedSensorCount(model.affectedSensorCount);
            totalNumberOfInvalidValues(model.totalNumberOfInvalidValues);
        }

        public final Integer getAffectedSensorCount() {
            return affectedSensorCount;
        }

        public final void setAffectedSensorCount(Integer affectedSensorCount) {
            this.affectedSensorCount = affectedSensorCount;
        }

        @Override
        public final Builder affectedSensorCount(Integer affectedSensorCount) {
            this.affectedSensorCount = affectedSensorCount;
            return this;
        }

        public final Integer getTotalNumberOfInvalidValues() {
            return totalNumberOfInvalidValues;
        }

        public final void setTotalNumberOfInvalidValues(Integer totalNumberOfInvalidValues) {
            this.totalNumberOfInvalidValues = totalNumberOfInvalidValues;
        }

        @Override
        public final Builder totalNumberOfInvalidValues(Integer totalNumberOfInvalidValues) {
            this.totalNumberOfInvalidValues = totalNumberOfInvalidValues;
            return this;
        }

        @Override
        public InvalidSensorData build() {
            return new InvalidSensorData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
