/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum TargetSamplingRate {
    PT1_S("PT1S"),

    PT5_S("PT5S"),

    PT10_S("PT10S"),

    PT15_S("PT15S"),

    PT30_S("PT30S"),

    PT1_M("PT1M"),

    PT5_M("PT5M"),

    PT10_M("PT10M"),

    PT15_M("PT15M"),

    PT30_M("PT30M"),

    PT1_H("PT1H"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TargetSamplingRate> VALUE_MAP = EnumUtils.uniqueIndex(TargetSamplingRate.class,
            TargetSamplingRate::toString);

    private final String value;

    private TargetSamplingRate(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return TargetSamplingRate corresponding to the value
     */
    public static TargetSamplingRate fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link TargetSamplingRate}s
     */
    public static Set<TargetSamplingRate> knownValues() {
        Set<TargetSamplingRate> knownValues = EnumSet.allOf(TargetSamplingRate.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
