/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration is the <code>TargetSamplingRate</code>, which is the sampling rate of the data after post
 * processing by Amazon Lookout for Equipment. For example, if you provide data that has been collected at a 1 second
 * level and you want the system to resample the data at a 1 minute rate before training, the
 * <code>TargetSamplingRate</code> is 1 minute.
 * </p>
 * <p>
 * When providing a value for the <code>TargetSamplingRate</code>, you must attach the prefix "PT" to the rate you want.
 * The value for a 1 second rate is therefore <i>PT1S</i>, the value for a 15 minute rate is <i>PT15M</i>, and the value
 * for a 1 hour rate is <i>PT1H</i>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataPreProcessingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DataPreProcessingConfiguration.Builder, DataPreProcessingConfiguration> {
    private static final SdkField<String> TARGET_SAMPLING_RATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetSamplingRate").getter(getter(DataPreProcessingConfiguration::targetSamplingRateAsString))
            .setter(setter(Builder::targetSamplingRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetSamplingRate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_SAMPLING_RATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String targetSamplingRate;

    private DataPreProcessingConfiguration(BuilderImpl builder) {
        this.targetSamplingRate = builder.targetSamplingRate;
    }

    /**
     * <p>
     * The sampling rate of the data after post processing by Amazon Lookout for Equipment. For example, if you provide
     * data that has been collected at a 1 second level and you want the system to resample the data at a 1 minute rate
     * before training, the <code>TargetSamplingRate</code> is 1 minute.
     * </p>
     * <p>
     * When providing a value for the <code>TargetSamplingRate</code>, you must attach the prefix "PT" to the rate you
     * want. The value for a 1 second rate is therefore <i>PT1S</i>, the value for a 15 minute rate is <i>PT15M</i>, and
     * the value for a 1 hour rate is <i>PT1H</i>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetSamplingRate} will return {@link TargetSamplingRate#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #targetSamplingRateAsString}.
     * </p>
     * 
     * @return The sampling rate of the data after post processing by Amazon Lookout for Equipment. For example, if you
     *         provide data that has been collected at a 1 second level and you want the system to resample the data at
     *         a 1 minute rate before training, the <code>TargetSamplingRate</code> is 1 minute.</p>
     *         <p>
     *         When providing a value for the <code>TargetSamplingRate</code>, you must attach the prefix "PT" to the
     *         rate you want. The value for a 1 second rate is therefore <i>PT1S</i>, the value for a 15 minute rate is
     *         <i>PT15M</i>, and the value for a 1 hour rate is <i>PT1H</i>
     * @see TargetSamplingRate
     */
    public final TargetSamplingRate targetSamplingRate() {
        return TargetSamplingRate.fromValue(targetSamplingRate);
    }

    /**
     * <p>
     * The sampling rate of the data after post processing by Amazon Lookout for Equipment. For example, if you provide
     * data that has been collected at a 1 second level and you want the system to resample the data at a 1 minute rate
     * before training, the <code>TargetSamplingRate</code> is 1 minute.
     * </p>
     * <p>
     * When providing a value for the <code>TargetSamplingRate</code>, you must attach the prefix "PT" to the rate you
     * want. The value for a 1 second rate is therefore <i>PT1S</i>, the value for a 15 minute rate is <i>PT15M</i>, and
     * the value for a 1 hour rate is <i>PT1H</i>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetSamplingRate} will return {@link TargetSamplingRate#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #targetSamplingRateAsString}.
     * </p>
     * 
     * @return The sampling rate of the data after post processing by Amazon Lookout for Equipment. For example, if you
     *         provide data that has been collected at a 1 second level and you want the system to resample the data at
     *         a 1 minute rate before training, the <code>TargetSamplingRate</code> is 1 minute.</p>
     *         <p>
     *         When providing a value for the <code>TargetSamplingRate</code>, you must attach the prefix "PT" to the
     *         rate you want. The value for a 1 second rate is therefore <i>PT1S</i>, the value for a 15 minute rate is
     *         <i>PT15M</i>, and the value for a 1 hour rate is <i>PT1H</i>
     * @see TargetSamplingRate
     */
    public final String targetSamplingRateAsString() {
        return targetSamplingRate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetSamplingRateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataPreProcessingConfiguration)) {
            return false;
        }
        DataPreProcessingConfiguration other = (DataPreProcessingConfiguration) obj;
        return Objects.equals(targetSamplingRateAsString(), other.targetSamplingRateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataPreProcessingConfiguration").add("TargetSamplingRate", targetSamplingRateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetSamplingRate":
            return Optional.ofNullable(clazz.cast(targetSamplingRateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataPreProcessingConfiguration, T> g) {
        return obj -> g.apply((DataPreProcessingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataPreProcessingConfiguration> {
        /**
         * <p>
         * The sampling rate of the data after post processing by Amazon Lookout for Equipment. For example, if you
         * provide data that has been collected at a 1 second level and you want the system to resample the data at a 1
         * minute rate before training, the <code>TargetSamplingRate</code> is 1 minute.
         * </p>
         * <p>
         * When providing a value for the <code>TargetSamplingRate</code>, you must attach the prefix "PT" to the rate
         * you want. The value for a 1 second rate is therefore <i>PT1S</i>, the value for a 15 minute rate is
         * <i>PT15M</i>, and the value for a 1 hour rate is <i>PT1H</i>
         * </p>
         * 
         * @param targetSamplingRate
         *        The sampling rate of the data after post processing by Amazon Lookout for Equipment. For example, if
         *        you provide data that has been collected at a 1 second level and you want the system to resample the
         *        data at a 1 minute rate before training, the <code>TargetSamplingRate</code> is 1 minute.</p>
         *        <p>
         *        When providing a value for the <code>TargetSamplingRate</code>, you must attach the prefix "PT" to the
         *        rate you want. The value for a 1 second rate is therefore <i>PT1S</i>, the value for a 15 minute rate
         *        is <i>PT15M</i>, and the value for a 1 hour rate is <i>PT1H</i>
         * @see TargetSamplingRate
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetSamplingRate
         */
        Builder targetSamplingRate(String targetSamplingRate);

        /**
         * <p>
         * The sampling rate of the data after post processing by Amazon Lookout for Equipment. For example, if you
         * provide data that has been collected at a 1 second level and you want the system to resample the data at a 1
         * minute rate before training, the <code>TargetSamplingRate</code> is 1 minute.
         * </p>
         * <p>
         * When providing a value for the <code>TargetSamplingRate</code>, you must attach the prefix "PT" to the rate
         * you want. The value for a 1 second rate is therefore <i>PT1S</i>, the value for a 15 minute rate is
         * <i>PT15M</i>, and the value for a 1 hour rate is <i>PT1H</i>
         * </p>
         * 
         * @param targetSamplingRate
         *        The sampling rate of the data after post processing by Amazon Lookout for Equipment. For example, if
         *        you provide data that has been collected at a 1 second level and you want the system to resample the
         *        data at a 1 minute rate before training, the <code>TargetSamplingRate</code> is 1 minute.</p>
         *        <p>
         *        When providing a value for the <code>TargetSamplingRate</code>, you must attach the prefix "PT" to the
         *        rate you want. The value for a 1 second rate is therefore <i>PT1S</i>, the value for a 15 minute rate
         *        is <i>PT15M</i>, and the value for a 1 hour rate is <i>PT1H</i>
         * @see TargetSamplingRate
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetSamplingRate
         */
        Builder targetSamplingRate(TargetSamplingRate targetSamplingRate);
    }

    static final class BuilderImpl implements Builder {
        private String targetSamplingRate;

        private BuilderImpl() {
        }

        private BuilderImpl(DataPreProcessingConfiguration model) {
            targetSamplingRate(model.targetSamplingRate);
        }

        public final String getTargetSamplingRate() {
            return targetSamplingRate;
        }

        public final void setTargetSamplingRate(String targetSamplingRate) {
            this.targetSamplingRate = targetSamplingRate;
        }

        @Override
        public final Builder targetSamplingRate(String targetSamplingRate) {
            this.targetSamplingRate = targetSamplingRate;
            return this;
        }

        @Override
        public final Builder targetSamplingRate(TargetSamplingRate targetSamplingRate) {
            this.targetSamplingRate(targetSamplingRate == null ? null : targetSamplingRate.toString());
            return this;
        }

        @Override
        public DataPreProcessingConfiguration build() {
            return new DataPreProcessingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
