/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListModelsResponse extends LookoutEquipmentResponse implements
        ToCopyableBuilder<ListModelsResponse.Builder, ListModelsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListModelsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<ModelSummary>> MODEL_SUMMARIES_FIELD = SdkField
            .<List<ModelSummary>> builder(MarshallingType.LIST)
            .memberName("ModelSummaries")
            .getter(getter(ListModelsResponse::modelSummaries))
            .setter(setter(Builder::modelSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ModelSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ModelSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MODEL_SUMMARIES_FIELD));

    private final String nextToken;

    private final List<ModelSummary> modelSummaries;

    private ListModelsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.modelSummaries = builder.modelSummaries;
    }

    /**
     * <p>
     * An opaque pagination token indicating where to continue the listing of ML models.
     * </p>
     * 
     * @return An opaque pagination token indicating where to continue the listing of ML models.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ModelSummaries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasModelSummaries() {
        return modelSummaries != null && !(modelSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides information on the specified model, including created time, model and dataset ARNs, and status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasModelSummaries} method.
     * </p>
     * 
     * @return Provides information on the specified model, including created time, model and dataset ARNs, and status.
     */
    public final List<ModelSummary> modelSummaries() {
        return modelSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasModelSummaries() ? modelSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListModelsResponse)) {
            return false;
        }
        ListModelsResponse other = (ListModelsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasModelSummaries() == other.hasModelSummaries()
                && Objects.equals(modelSummaries(), other.modelSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListModelsResponse").add("NextToken", nextToken())
                .add("ModelSummaries", hasModelSummaries() ? modelSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ModelSummaries":
            return Optional.ofNullable(clazz.cast(modelSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListModelsResponse, T> g) {
        return obj -> g.apply((ListModelsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutEquipmentResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListModelsResponse> {
        /**
         * <p>
         * An opaque pagination token indicating where to continue the listing of ML models.
         * </p>
         * 
         * @param nextToken
         *        An opaque pagination token indicating where to continue the listing of ML models.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Provides information on the specified model, including created time, model and dataset ARNs, and status.
         * </p>
         * 
         * @param modelSummaries
         *        Provides information on the specified model, including created time, model and dataset ARNs, and
         *        status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelSummaries(Collection<ModelSummary> modelSummaries);

        /**
         * <p>
         * Provides information on the specified model, including created time, model and dataset ARNs, and status.
         * </p>
         * 
         * @param modelSummaries
         *        Provides information on the specified model, including created time, model and dataset ARNs, and
         *        status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelSummaries(ModelSummary... modelSummaries);

        /**
         * <p>
         * Provides information on the specified model, including created time, model and dataset ARNs, and status.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lookoutequipment.model.ModelSummary.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.lookoutequipment.model.ModelSummary#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lookoutequipment.model.ModelSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #modelSummaries(List<ModelSummary>)}.
         * 
         * @param modelSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lookoutequipment.model.ModelSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelSummaries(java.util.Collection<ModelSummary>)
         */
        Builder modelSummaries(Consumer<ModelSummary.Builder>... modelSummaries);
    }

    static final class BuilderImpl extends LookoutEquipmentResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ModelSummary> modelSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListModelsResponse model) {
            super(model);
            nextToken(model.nextToken);
            modelSummaries(model.modelSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ModelSummary.Builder> getModelSummaries() {
            List<ModelSummary.Builder> result = ModelSummariesCopier.copyToBuilder(this.modelSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModelSummaries(Collection<ModelSummary.BuilderImpl> modelSummaries) {
            this.modelSummaries = ModelSummariesCopier.copyFromBuilder(modelSummaries);
        }

        @Override
        public final Builder modelSummaries(Collection<ModelSummary> modelSummaries) {
            this.modelSummaries = ModelSummariesCopier.copy(modelSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelSummaries(ModelSummary... modelSummaries) {
            modelSummaries(Arrays.asList(modelSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelSummaries(Consumer<ModelSummary.Builder>... modelSummaries) {
            modelSummaries(Stream.of(modelSummaries).map(c -> ModelSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListModelsResponse build() {
            return new ListModelsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
