/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListModelsRequest extends LookoutEquipmentRequest implements
        ToCopyableBuilder<ListModelsRequest.Builder, ListModelsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListModelsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListModelsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ListModelsRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> MODEL_NAME_BEGINS_WITH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelNameBeginsWith").getter(getter(ListModelsRequest::modelNameBeginsWith))
            .setter(setter(Builder::modelNameBeginsWith))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelNameBeginsWith").build())
            .build();

    private static final SdkField<String> DATASET_NAME_BEGINS_WITH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetNameBeginsWith").getter(getter(ListModelsRequest::datasetNameBeginsWith))
            .setter(setter(Builder::datasetNameBeginsWith))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetNameBeginsWith").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, STATUS_FIELD, MODEL_NAME_BEGINS_WITH_FIELD, DATASET_NAME_BEGINS_WITH_FIELD));

    private final String nextToken;

    private final Integer maxResults;

    private final String status;

    private final String modelNameBeginsWith;

    private final String datasetNameBeginsWith;

    private ListModelsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.status = builder.status;
        this.modelNameBeginsWith = builder.modelNameBeginsWith;
        this.datasetNameBeginsWith = builder.datasetNameBeginsWith;
    }

    /**
     * <p>
     * An opaque pagination token indicating where to continue the listing of ML models.
     * </p>
     * 
     * @return An opaque pagination token indicating where to continue the listing of ML models.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Specifies the maximum number of ML models to list.
     * </p>
     * 
     * @return Specifies the maximum number of ML models to list.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The status of the ML model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ModelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the ML model.
     * @see ModelStatus
     */
    public final ModelStatus status() {
        return ModelStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the ML model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ModelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the ML model.
     * @see ModelStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The beginning of the name of the ML models being listed.
     * </p>
     * 
     * @return The beginning of the name of the ML models being listed.
     */
    public final String modelNameBeginsWith() {
        return modelNameBeginsWith;
    }

    /**
     * <p>
     * The beginning of the name of the dataset of the ML models to be listed.
     * </p>
     * 
     * @return The beginning of the name of the dataset of the ML models to be listed.
     */
    public final String datasetNameBeginsWith() {
        return datasetNameBeginsWith;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(modelNameBeginsWith());
        hashCode = 31 * hashCode + Objects.hashCode(datasetNameBeginsWith());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListModelsRequest)) {
            return false;
        }
        ListModelsRequest other = (ListModelsRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(modelNameBeginsWith(), other.modelNameBeginsWith())
                && Objects.equals(datasetNameBeginsWith(), other.datasetNameBeginsWith());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListModelsRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("Status", statusAsString()).add("ModelNameBeginsWith", modelNameBeginsWith())
                .add("DatasetNameBeginsWith", datasetNameBeginsWith()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "ModelNameBeginsWith":
            return Optional.ofNullable(clazz.cast(modelNameBeginsWith()));
        case "DatasetNameBeginsWith":
            return Optional.ofNullable(clazz.cast(datasetNameBeginsWith()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListModelsRequest, T> g) {
        return obj -> g.apply((ListModelsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutEquipmentRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListModelsRequest> {
        /**
         * <p>
         * An opaque pagination token indicating where to continue the listing of ML models.
         * </p>
         * 
         * @param nextToken
         *        An opaque pagination token indicating where to continue the listing of ML models.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Specifies the maximum number of ML models to list.
         * </p>
         * 
         * @param maxResults
         *        Specifies the maximum number of ML models to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The status of the ML model.
         * </p>
         * 
         * @param status
         *        The status of the ML model.
         * @see ModelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the ML model.
         * </p>
         * 
         * @param status
         *        The status of the ML model.
         * @see ModelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelStatus
         */
        Builder status(ModelStatus status);

        /**
         * <p>
         * The beginning of the name of the ML models being listed.
         * </p>
         * 
         * @param modelNameBeginsWith
         *        The beginning of the name of the ML models being listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelNameBeginsWith(String modelNameBeginsWith);

        /**
         * <p>
         * The beginning of the name of the dataset of the ML models to be listed.
         * </p>
         * 
         * @param datasetNameBeginsWith
         *        The beginning of the name of the dataset of the ML models to be listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetNameBeginsWith(String datasetNameBeginsWith);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LookoutEquipmentRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private String status;

        private String modelNameBeginsWith;

        private String datasetNameBeginsWith;

        private BuilderImpl() {
        }

        private BuilderImpl(ListModelsRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            status(model.status);
            modelNameBeginsWith(model.modelNameBeginsWith);
            datasetNameBeginsWith(model.datasetNameBeginsWith);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(ModelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getModelNameBeginsWith() {
            return modelNameBeginsWith;
        }

        public final void setModelNameBeginsWith(String modelNameBeginsWith) {
            this.modelNameBeginsWith = modelNameBeginsWith;
        }

        @Override
        @Transient
        public final Builder modelNameBeginsWith(String modelNameBeginsWith) {
            this.modelNameBeginsWith = modelNameBeginsWith;
            return this;
        }

        public final String getDatasetNameBeginsWith() {
            return datasetNameBeginsWith;
        }

        public final void setDatasetNameBeginsWith(String datasetNameBeginsWith) {
            this.datasetNameBeginsWith = datasetNameBeginsWith;
        }

        @Override
        @Transient
        public final Builder datasetNameBeginsWith(String datasetNameBeginsWith) {
            this.datasetNameBeginsWith = datasetNameBeginsWith;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListModelsRequest build() {
            return new ListModelsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
