/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInferenceSchedulersRequest extends LookoutEquipmentRequest implements
        ToCopyableBuilder<ListInferenceSchedulersRequest.Builder, ListInferenceSchedulersRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListInferenceSchedulersRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListInferenceSchedulersRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> INFERENCE_SCHEDULER_NAME_BEGINS_WITH_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InferenceSchedulerNameBeginsWith")
            .getter(getter(ListInferenceSchedulersRequest::inferenceSchedulerNameBeginsWith))
            .setter(setter(Builder::inferenceSchedulerNameBeginsWith))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSchedulerNameBeginsWith")
                    .build()).build();

    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelName").getter(getter(ListInferenceSchedulersRequest::modelName)).setter(setter(Builder::modelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, INFERENCE_SCHEDULER_NAME_BEGINS_WITH_FIELD, MODEL_NAME_FIELD));

    private final String nextToken;

    private final Integer maxResults;

    private final String inferenceSchedulerNameBeginsWith;

    private final String modelName;

    private ListInferenceSchedulersRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.inferenceSchedulerNameBeginsWith = builder.inferenceSchedulerNameBeginsWith;
        this.modelName = builder.modelName;
    }

    /**
     * <p>
     * An opaque pagination token indicating where to continue the listing of inference schedulers.
     * </p>
     * 
     * @return An opaque pagination token indicating where to continue the listing of inference schedulers.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Specifies the maximum number of inference schedulers to list.
     * </p>
     * 
     * @return Specifies the maximum number of inference schedulers to list.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The beginning of the name of the inference schedulers to be listed.
     * </p>
     * 
     * @return The beginning of the name of the inference schedulers to be listed.
     */
    public final String inferenceSchedulerNameBeginsWith() {
        return inferenceSchedulerNameBeginsWith;
    }

    /**
     * <p>
     * The name of the ML model used by the inference scheduler to be listed.
     * </p>
     * 
     * @return The name of the ML model used by the inference scheduler to be listed.
     */
    public final String modelName() {
        return modelName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(inferenceSchedulerNameBeginsWith());
        hashCode = 31 * hashCode + Objects.hashCode(modelName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInferenceSchedulersRequest)) {
            return false;
        }
        ListInferenceSchedulersRequest other = (ListInferenceSchedulersRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(inferenceSchedulerNameBeginsWith(), other.inferenceSchedulerNameBeginsWith())
                && Objects.equals(modelName(), other.modelName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListInferenceSchedulersRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("InferenceSchedulerNameBeginsWith", inferenceSchedulerNameBeginsWith()).add("ModelName", modelName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "InferenceSchedulerNameBeginsWith":
            return Optional.ofNullable(clazz.cast(inferenceSchedulerNameBeginsWith()));
        case "ModelName":
            return Optional.ofNullable(clazz.cast(modelName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListInferenceSchedulersRequest, T> g) {
        return obj -> g.apply((ListInferenceSchedulersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutEquipmentRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListInferenceSchedulersRequest> {
        /**
         * <p>
         * An opaque pagination token indicating where to continue the listing of inference schedulers.
         * </p>
         * 
         * @param nextToken
         *        An opaque pagination token indicating where to continue the listing of inference schedulers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Specifies the maximum number of inference schedulers to list.
         * </p>
         * 
         * @param maxResults
         *        Specifies the maximum number of inference schedulers to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The beginning of the name of the inference schedulers to be listed.
         * </p>
         * 
         * @param inferenceSchedulerNameBeginsWith
         *        The beginning of the name of the inference schedulers to be listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceSchedulerNameBeginsWith(String inferenceSchedulerNameBeginsWith);

        /**
         * <p>
         * The name of the ML model used by the inference scheduler to be listed.
         * </p>
         * 
         * @param modelName
         *        The name of the ML model used by the inference scheduler to be listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelName(String modelName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LookoutEquipmentRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private String inferenceSchedulerNameBeginsWith;

        private String modelName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInferenceSchedulersRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            inferenceSchedulerNameBeginsWith(model.inferenceSchedulerNameBeginsWith);
            modelName(model.modelName);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getInferenceSchedulerNameBeginsWith() {
            return inferenceSchedulerNameBeginsWith;
        }

        public final void setInferenceSchedulerNameBeginsWith(String inferenceSchedulerNameBeginsWith) {
            this.inferenceSchedulerNameBeginsWith = inferenceSchedulerNameBeginsWith;
        }

        @Override
        @Transient
        public final Builder inferenceSchedulerNameBeginsWith(String inferenceSchedulerNameBeginsWith) {
            this.inferenceSchedulerNameBeginsWith = inferenceSchedulerNameBeginsWith;
            return this;
        }

        public final String getModelName() {
            return modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        @Transient
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListInferenceSchedulersRequest build() {
            return new ListInferenceSchedulersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
