/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInferenceExecutionsRequest extends LookoutEquipmentRequest implements
        ToCopyableBuilder<ListInferenceExecutionsRequest.Builder, ListInferenceExecutionsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListInferenceExecutionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListInferenceExecutionsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> INFERENCE_SCHEDULER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InferenceSchedulerName").getter(getter(ListInferenceExecutionsRequest::inferenceSchedulerName))
            .setter(setter(Builder::inferenceSchedulerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSchedulerName").build())
            .build();

    private static final SdkField<Instant> DATA_START_TIME_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DataStartTimeAfter").getter(getter(ListInferenceExecutionsRequest::dataStartTimeAfter))
            .setter(setter(Builder::dataStartTimeAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataStartTimeAfter").build())
            .build();

    private static final SdkField<Instant> DATA_END_TIME_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DataEndTimeBefore").getter(getter(ListInferenceExecutionsRequest::dataEndTimeBefore))
            .setter(setter(Builder::dataEndTimeBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataEndTimeBefore").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ListInferenceExecutionsRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, INFERENCE_SCHEDULER_NAME_FIELD, DATA_START_TIME_AFTER_FIELD, DATA_END_TIME_BEFORE_FIELD,
            STATUS_FIELD));

    private final String nextToken;

    private final Integer maxResults;

    private final String inferenceSchedulerName;

    private final Instant dataStartTimeAfter;

    private final Instant dataEndTimeBefore;

    private final String status;

    private ListInferenceExecutionsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.inferenceSchedulerName = builder.inferenceSchedulerName;
        this.dataStartTimeAfter = builder.dataStartTimeAfter;
        this.dataEndTimeBefore = builder.dataEndTimeBefore;
        this.status = builder.status;
    }

    /**
     * <p>
     * An opaque pagination token indicating where to continue the listing of inference executions.
     * </p>
     * 
     * @return An opaque pagination token indicating where to continue the listing of inference executions.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Specifies the maximum number of inference executions to list.
     * </p>
     * 
     * @return Specifies the maximum number of inference executions to list.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The name of the inference scheduler for the inference execution listed.
     * </p>
     * 
     * @return The name of the inference scheduler for the inference execution listed.
     */
    public final String inferenceSchedulerName() {
        return inferenceSchedulerName;
    }

    /**
     * <p>
     * The time reference in the inferenced dataset after which Amazon Lookout for Equipment started the inference
     * execution.
     * </p>
     * 
     * @return The time reference in the inferenced dataset after which Amazon Lookout for Equipment started the
     *         inference execution.
     */
    public final Instant dataStartTimeAfter() {
        return dataStartTimeAfter;
    }

    /**
     * <p>
     * The time reference in the inferenced dataset before which Amazon Lookout for Equipment stopped the inference
     * execution.
     * </p>
     * 
     * @return The time reference in the inferenced dataset before which Amazon Lookout for Equipment stopped the
     *         inference execution.
     */
    public final Instant dataEndTimeBefore() {
        return dataEndTimeBefore;
    }

    /**
     * <p>
     * The status of the inference execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InferenceExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the inference execution.
     * @see InferenceExecutionStatus
     */
    public final InferenceExecutionStatus status() {
        return InferenceExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the inference execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InferenceExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the inference execution.
     * @see InferenceExecutionStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(inferenceSchedulerName());
        hashCode = 31 * hashCode + Objects.hashCode(dataStartTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(dataEndTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInferenceExecutionsRequest)) {
            return false;
        }
        ListInferenceExecutionsRequest other = (ListInferenceExecutionsRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(inferenceSchedulerName(), other.inferenceSchedulerName())
                && Objects.equals(dataStartTimeAfter(), other.dataStartTimeAfter())
                && Objects.equals(dataEndTimeBefore(), other.dataEndTimeBefore())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListInferenceExecutionsRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("InferenceSchedulerName", inferenceSchedulerName()).add("DataStartTimeAfter", dataStartTimeAfter())
                .add("DataEndTimeBefore", dataEndTimeBefore()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "InferenceSchedulerName":
            return Optional.ofNullable(clazz.cast(inferenceSchedulerName()));
        case "DataStartTimeAfter":
            return Optional.ofNullable(clazz.cast(dataStartTimeAfter()));
        case "DataEndTimeBefore":
            return Optional.ofNullable(clazz.cast(dataEndTimeBefore()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListInferenceExecutionsRequest, T> g) {
        return obj -> g.apply((ListInferenceExecutionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutEquipmentRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListInferenceExecutionsRequest> {
        /**
         * <p>
         * An opaque pagination token indicating where to continue the listing of inference executions.
         * </p>
         * 
         * @param nextToken
         *        An opaque pagination token indicating where to continue the listing of inference executions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Specifies the maximum number of inference executions to list.
         * </p>
         * 
         * @param maxResults
         *        Specifies the maximum number of inference executions to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The name of the inference scheduler for the inference execution listed.
         * </p>
         * 
         * @param inferenceSchedulerName
         *        The name of the inference scheduler for the inference execution listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceSchedulerName(String inferenceSchedulerName);

        /**
         * <p>
         * The time reference in the inferenced dataset after which Amazon Lookout for Equipment started the inference
         * execution.
         * </p>
         * 
         * @param dataStartTimeAfter
         *        The time reference in the inferenced dataset after which Amazon Lookout for Equipment started the
         *        inference execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataStartTimeAfter(Instant dataStartTimeAfter);

        /**
         * <p>
         * The time reference in the inferenced dataset before which Amazon Lookout for Equipment stopped the inference
         * execution.
         * </p>
         * 
         * @param dataEndTimeBefore
         *        The time reference in the inferenced dataset before which Amazon Lookout for Equipment stopped the
         *        inference execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataEndTimeBefore(Instant dataEndTimeBefore);

        /**
         * <p>
         * The status of the inference execution.
         * </p>
         * 
         * @param status
         *        The status of the inference execution.
         * @see InferenceExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferenceExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the inference execution.
         * </p>
         * 
         * @param status
         *        The status of the inference execution.
         * @see InferenceExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferenceExecutionStatus
         */
        Builder status(InferenceExecutionStatus status);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LookoutEquipmentRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private String inferenceSchedulerName;

        private Instant dataStartTimeAfter;

        private Instant dataEndTimeBefore;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInferenceExecutionsRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            inferenceSchedulerName(model.inferenceSchedulerName);
            dataStartTimeAfter(model.dataStartTimeAfter);
            dataEndTimeBefore(model.dataEndTimeBefore);
            status(model.status);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getInferenceSchedulerName() {
            return inferenceSchedulerName;
        }

        public final void setInferenceSchedulerName(String inferenceSchedulerName) {
            this.inferenceSchedulerName = inferenceSchedulerName;
        }

        @Override
        @Transient
        public final Builder inferenceSchedulerName(String inferenceSchedulerName) {
            this.inferenceSchedulerName = inferenceSchedulerName;
            return this;
        }

        public final Instant getDataStartTimeAfter() {
            return dataStartTimeAfter;
        }

        public final void setDataStartTimeAfter(Instant dataStartTimeAfter) {
            this.dataStartTimeAfter = dataStartTimeAfter;
        }

        @Override
        @Transient
        public final Builder dataStartTimeAfter(Instant dataStartTimeAfter) {
            this.dataStartTimeAfter = dataStartTimeAfter;
            return this;
        }

        public final Instant getDataEndTimeBefore() {
            return dataEndTimeBefore;
        }

        public final void setDataEndTimeBefore(Instant dataEndTimeBefore) {
            this.dataEndTimeBefore = dataEndTimeBefore;
        }

        @Override
        @Transient
        public final Builder dataEndTimeBefore(Instant dataEndTimeBefore) {
            this.dataEndTimeBefore = dataEndTimeBefore;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(InferenceExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListInferenceExecutionsRequest build() {
            return new ListInferenceExecutionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
