/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDatasetResponse extends LookoutEquipmentResponse implements
        ToCopyableBuilder<DescribeDatasetResponse.Builder, DescribeDatasetResponse> {
    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetName").getter(getter(DescribeDatasetResponse::datasetName)).setter(setter(Builder::datasetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetName").build()).build();

    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetArn").getter(getter(DescribeDatasetResponse::datasetArn)).setter(setter(Builder::datasetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetArn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(DescribeDatasetResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedAt").getter(getter(DescribeDatasetResponse::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeDatasetResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> SCHEMA_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Schema")
            .getter(getter(DescribeDatasetResponse::schema))
            .setter(setter(Builder::schema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build(),
                    JsonValueTrait.create()).build();

    private static final SdkField<String> SERVER_SIDE_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerSideKmsKeyId").getter(getter(DescribeDatasetResponse::serverSideKmsKeyId))
            .setter(setter(Builder::serverSideKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerSideKmsKeyId").build())
            .build();

    private static final SdkField<IngestionInputConfiguration> INGESTION_INPUT_CONFIGURATION_FIELD = SdkField
            .<IngestionInputConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("IngestionInputConfiguration")
            .getter(getter(DescribeDatasetResponse::ingestionInputConfiguration))
            .setter(setter(Builder::ingestionInputConfiguration))
            .constructor(IngestionInputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngestionInputConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_NAME_FIELD,
            DATASET_ARN_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, STATUS_FIELD, SCHEMA_FIELD, SERVER_SIDE_KMS_KEY_ID_FIELD,
            INGESTION_INPUT_CONFIGURATION_FIELD));

    private final String datasetName;

    private final String datasetArn;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private final String status;

    private final String schema;

    private final String serverSideKmsKeyId;

    private final IngestionInputConfiguration ingestionInputConfiguration;

    private DescribeDatasetResponse(BuilderImpl builder) {
        super(builder);
        this.datasetName = builder.datasetName;
        this.datasetArn = builder.datasetArn;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.status = builder.status;
        this.schema = builder.schema;
        this.serverSideKmsKeyId = builder.serverSideKmsKeyId;
        this.ingestionInputConfiguration = builder.ingestionInputConfiguration;
    }

    /**
     * <p>
     * The name of the dataset being described.
     * </p>
     * 
     * @return The name of the dataset being described.
     */
    public final String datasetName() {
        return datasetName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the dataset being described.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the dataset being described.
     */
    public final String datasetArn() {
        return datasetArn;
    }

    /**
     * <p>
     * Specifies the time the dataset was created in Amazon Lookout for Equipment.
     * </p>
     * 
     * @return Specifies the time the dataset was created in Amazon Lookout for Equipment.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Specifies the time the dataset was last updated, if it was.
     * </p>
     * 
     * @return Specifies the time the dataset was last updated, if it was.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * Indicates the status of the dataset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DatasetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates the status of the dataset.
     * @see DatasetStatus
     */
    public final DatasetStatus status() {
        return DatasetStatus.fromValue(status);
    }

    /**
     * <p>
     * Indicates the status of the dataset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DatasetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates the status of the dataset.
     * @see DatasetStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A JSON description of the data that is in each time series dataset, including names, column names, and data
     * types.
     * </p>
     * 
     * @return A JSON description of the data that is in each time series dataset, including names, column names, and
     *         data types.
     */
    public final String schema() {
        return schema;
    }

    /**
     * <p>
     * Provides the identifier of the KMS key used to encrypt dataset data by Amazon Lookout for Equipment.
     * </p>
     * 
     * @return Provides the identifier of the KMS key used to encrypt dataset data by Amazon Lookout for Equipment.
     */
    public final String serverSideKmsKeyId() {
        return serverSideKmsKeyId;
    }

    /**
     * <p>
     * Specifies the S3 location configuration for the data input for the data ingestion job.
     * </p>
     * 
     * @return Specifies the S3 location configuration for the data input for the data ingestion job.
     */
    public final IngestionInputConfiguration ingestionInputConfiguration() {
        return ingestionInputConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(schema());
        hashCode = 31 * hashCode + Objects.hashCode(serverSideKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(ingestionInputConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDatasetResponse)) {
            return false;
        }
        DescribeDatasetResponse other = (DescribeDatasetResponse) obj;
        return Objects.equals(datasetName(), other.datasetName()) && Objects.equals(datasetArn(), other.datasetArn())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(schema(), other.schema())
                && Objects.equals(serverSideKmsKeyId(), other.serverSideKmsKeyId())
                && Objects.equals(ingestionInputConfiguration(), other.ingestionInputConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDatasetResponse").add("DatasetName", datasetName()).add("DatasetArn", datasetArn())
                .add("CreatedAt", createdAt()).add("LastUpdatedAt", lastUpdatedAt()).add("Status", statusAsString())
                .add("Schema", schema()).add("ServerSideKmsKeyId", serverSideKmsKeyId())
                .add("IngestionInputConfiguration", ingestionInputConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatasetName":
            return Optional.ofNullable(clazz.cast(datasetName()));
        case "DatasetArn":
            return Optional.ofNullable(clazz.cast(datasetArn()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "LastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Schema":
            return Optional.ofNullable(clazz.cast(schema()));
        case "ServerSideKmsKeyId":
            return Optional.ofNullable(clazz.cast(serverSideKmsKeyId()));
        case "IngestionInputConfiguration":
            return Optional.ofNullable(clazz.cast(ingestionInputConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDatasetResponse, T> g) {
        return obj -> g.apply((DescribeDatasetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutEquipmentResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDatasetResponse> {
        /**
         * <p>
         * The name of the dataset being described.
         * </p>
         * 
         * @param datasetName
         *        The name of the dataset being described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetName(String datasetName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the dataset being described.
         * </p>
         * 
         * @param datasetArn
         *        The Amazon Resource Name (ARN) of the dataset being described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetArn(String datasetArn);

        /**
         * <p>
         * Specifies the time the dataset was created in Amazon Lookout for Equipment.
         * </p>
         * 
         * @param createdAt
         *        Specifies the time the dataset was created in Amazon Lookout for Equipment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Specifies the time the dataset was last updated, if it was.
         * </p>
         * 
         * @param lastUpdatedAt
         *        Specifies the time the dataset was last updated, if it was.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * Indicates the status of the dataset.
         * </p>
         * 
         * @param status
         *        Indicates the status of the dataset.
         * @see DatasetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Indicates the status of the dataset.
         * </p>
         * 
         * @param status
         *        Indicates the status of the dataset.
         * @see DatasetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetStatus
         */
        Builder status(DatasetStatus status);

        /**
         * <p>
         * A JSON description of the data that is in each time series dataset, including names, column names, and data
         * types.
         * </p>
         * 
         * @param schema
         *        A JSON description of the data that is in each time series dataset, including names, column names, and
         *        data types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(String schema);

        /**
         * <p>
         * Provides the identifier of the KMS key used to encrypt dataset data by Amazon Lookout for Equipment.
         * </p>
         * 
         * @param serverSideKmsKeyId
         *        Provides the identifier of the KMS key used to encrypt dataset data by Amazon Lookout for Equipment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverSideKmsKeyId(String serverSideKmsKeyId);

        /**
         * <p>
         * Specifies the S3 location configuration for the data input for the data ingestion job.
         * </p>
         * 
         * @param ingestionInputConfiguration
         *        Specifies the S3 location configuration for the data input for the data ingestion job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestionInputConfiguration(IngestionInputConfiguration ingestionInputConfiguration);

        /**
         * <p>
         * Specifies the S3 location configuration for the data input for the data ingestion job.
         * </p>
         * This is a convenience that creates an instance of the {@link IngestionInputConfiguration.Builder} avoiding
         * the need to create one manually via {@link IngestionInputConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link IngestionInputConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #ingestionInputConfiguration(IngestionInputConfiguration)}.
         * 
         * @param ingestionInputConfiguration
         *        a consumer that will call methods on {@link IngestionInputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ingestionInputConfiguration(IngestionInputConfiguration)
         */
        default Builder ingestionInputConfiguration(Consumer<IngestionInputConfiguration.Builder> ingestionInputConfiguration) {
            return ingestionInputConfiguration(IngestionInputConfiguration.builder().applyMutation(ingestionInputConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl extends LookoutEquipmentResponse.BuilderImpl implements Builder {
        private String datasetName;

        private String datasetArn;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private String status;

        private String schema;

        private String serverSideKmsKeyId;

        private IngestionInputConfiguration ingestionInputConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDatasetResponse model) {
            super(model);
            datasetName(model.datasetName);
            datasetArn(model.datasetArn);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
            status(model.status);
            schema(model.schema);
            serverSideKmsKeyId(model.serverSideKmsKeyId);
            ingestionInputConfiguration(model.ingestionInputConfiguration);
        }

        public final String getDatasetName() {
            return datasetName;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        @Override
        @Transient
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final String getDatasetArn() {
            return datasetArn;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        @Override
        @Transient
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        @Transient
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        @Transient
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(DatasetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getSchema() {
            return schema;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        @Override
        @Transient
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public final String getServerSideKmsKeyId() {
            return serverSideKmsKeyId;
        }

        public final void setServerSideKmsKeyId(String serverSideKmsKeyId) {
            this.serverSideKmsKeyId = serverSideKmsKeyId;
        }

        @Override
        @Transient
        public final Builder serverSideKmsKeyId(String serverSideKmsKeyId) {
            this.serverSideKmsKeyId = serverSideKmsKeyId;
            return this;
        }

        public final IngestionInputConfiguration.Builder getIngestionInputConfiguration() {
            return ingestionInputConfiguration != null ? ingestionInputConfiguration.toBuilder() : null;
        }

        public final void setIngestionInputConfiguration(IngestionInputConfiguration.BuilderImpl ingestionInputConfiguration) {
            this.ingestionInputConfiguration = ingestionInputConfiguration != null ? ingestionInputConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder ingestionInputConfiguration(IngestionInputConfiguration ingestionInputConfiguration) {
            this.ingestionInputConfiguration = ingestionInputConfiguration;
            return this;
        }

        @Override
        public DescribeDatasetResponse build() {
            return new DescribeDatasetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
