/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.lightsail.DefaultLightsailAsyncClient;
import software.amazon.awssdk.services.lightsail.DefaultLightsailBaseClientBuilder;
import software.amazon.awssdk.services.lightsail.LightsailAsyncClient;
import software.amazon.awssdk.services.lightsail.LightsailAsyncClientBuilder;
import software.amazon.awssdk.services.lightsail.LightsailServiceClientConfiguration;
import software.amazon.awssdk.services.lightsail.endpoints.LightsailEndpointProvider;

@SdkInternalApi
final class DefaultLightsailAsyncClientBuilder
extends DefaultLightsailBaseClientBuilder<LightsailAsyncClientBuilder, LightsailAsyncClient>
implements LightsailAsyncClientBuilder {
    DefaultLightsailAsyncClientBuilder() {
    }

    @Override
    public DefaultLightsailAsyncClientBuilder endpointProvider(LightsailEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final LightsailAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultLightsailAsyncClientBuilder.validateClientOptions(clientConfiguration);
        LightsailServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultLightsailAsyncClient client = new DefaultLightsailAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private LightsailServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return LightsailServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

