/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceType {
    CONTAINER_SERVICE("ContainerService"),
    INSTANCE("Instance"),
    STATIC_IP("StaticIp"),
    KEY_PAIR("KeyPair"),
    INSTANCE_SNAPSHOT("InstanceSnapshot"),
    DOMAIN("Domain"),
    PEERED_VPC("PeeredVpc"),
    LOAD_BALANCER("LoadBalancer"),
    LOAD_BALANCER_TLS_CERTIFICATE("LoadBalancerTlsCertificate"),
    DISK("Disk"),
    DISK_SNAPSHOT("DiskSnapshot"),
    RELATIONAL_DATABASE("RelationalDatabase"),
    RELATIONAL_DATABASE_SNAPSHOT("RelationalDatabaseSnapshot"),
    EXPORT_SNAPSHOT_RECORD("ExportSnapshotRecord"),
    CLOUD_FORMATION_STACK_RECORD("CloudFormationStackRecord"),
    ALARM("Alarm"),
    CONTACT_METHOD("ContactMethod"),
    DISTRIBUTION("Distribution"),
    CERTIFICATE("Certificate"),
    BUCKET("Bucket"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceType> VALUE_MAP;
    private final String value;

    private ResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceType> knownValues() {
        EnumSet<ResourceType> knownValues = EnumSet.allOf(ResourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceType.class, ResourceType::toString);
    }
}

