/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportSnapshotRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, ExportSnapshotRequest> {
    private static final SdkField<String> SOURCE_SNAPSHOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceSnapshotName").getter(ExportSnapshotRequest.getter(ExportSnapshotRequest::sourceSnapshotName)).setter(ExportSnapshotRequest.setter(Builder::sourceSnapshotName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceSnapshotName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_SNAPSHOT_NAME_FIELD));
    private final String sourceSnapshotName;

    private ExportSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.sourceSnapshotName = builder.sourceSnapshotName;
    }

    public final String sourceSnapshotName() {
        return this.sourceSnapshotName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceSnapshotName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportSnapshotRequest)) {
            return false;
        }
        ExportSnapshotRequest other = (ExportSnapshotRequest)((Object)obj);
        return Objects.equals(this.sourceSnapshotName(), other.sourceSnapshotName());
    }

    public final String toString() {
        return ToString.builder((String)"ExportSnapshotRequest").add("SourceSnapshotName", (Object)this.sourceSnapshotName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sourceSnapshotName": {
                return Optional.ofNullable(clazz.cast(this.sourceSnapshotName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportSnapshotRequest, T> g) {
        return obj -> g.apply((ExportSnapshotRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String sourceSnapshotName;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportSnapshotRequest model) {
            super(model);
            this.sourceSnapshotName(model.sourceSnapshotName);
        }

        public final String getSourceSnapshotName() {
            return this.sourceSnapshotName;
        }

        public final void setSourceSnapshotName(String sourceSnapshotName) {
            this.sourceSnapshotName = sourceSnapshotName;
        }

        @Override
        public final Builder sourceSnapshotName(String sourceSnapshotName) {
            this.sourceSnapshotName = sourceSnapshotName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExportSnapshotRequest build() {
            return new ExportSnapshotRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ExportSnapshotRequest> {
        public Builder sourceSnapshotName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

