/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.ResourceRecord;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DomainValidationRecord
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DomainValidationRecord> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainName").getter(DomainValidationRecord.getter(DomainValidationRecord::domainName)).setter(DomainValidationRecord.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()}).build();
    private static final SdkField<ResourceRecord> RESOURCE_RECORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resourceRecord").getter(DomainValidationRecord.getter(DomainValidationRecord::resourceRecord)).setter(DomainValidationRecord.setter(Builder::resourceRecord)).constructor(ResourceRecord::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceRecord").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, RESOURCE_RECORD_FIELD));
    private static final long serialVersionUID = 1L;
    private final String domainName;
    private final ResourceRecord resourceRecord;

    private DomainValidationRecord(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.resourceRecord = builder.resourceRecord;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final ResourceRecord resourceRecord() {
        return this.resourceRecord;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceRecord());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainValidationRecord)) {
            return false;
        }
        DomainValidationRecord other = (DomainValidationRecord)obj;
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.resourceRecord(), other.resourceRecord());
    }

    public final String toString() {
        return ToString.builder((String)"DomainValidationRecord").add("DomainName", (Object)this.domainName()).add("ResourceRecord", (Object)this.resourceRecord()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "resourceRecord": {
                return Optional.ofNullable(clazz.cast(this.resourceRecord()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainValidationRecord, T> g) {
        return obj -> g.apply((DomainValidationRecord)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private ResourceRecord resourceRecord;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainValidationRecord model) {
            this.domainName(model.domainName);
            this.resourceRecord(model.resourceRecord);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final ResourceRecord.Builder getResourceRecord() {
            return this.resourceRecord != null ? this.resourceRecord.toBuilder() : null;
        }

        public final void setResourceRecord(ResourceRecord.BuilderImpl resourceRecord) {
            this.resourceRecord = resourceRecord != null ? resourceRecord.build() : null;
        }

        @Override
        public final Builder resourceRecord(ResourceRecord resourceRecord) {
            this.resourceRecord = resourceRecord;
            return this;
        }

        public DomainValidationRecord build() {
            return new DomainValidationRecord(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DomainValidationRecord> {
        public Builder domainName(String var1);

        public Builder resourceRecord(ResourceRecord var1);

        default public Builder resourceRecord(Consumer<ResourceRecord.Builder> resourceRecord) {
            return this.resourceRecord((ResourceRecord)((ResourceRecord.Builder)ResourceRecord.builder().applyMutation(resourceRecord)).build());
        }
    }
}

