/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object which details a discovered Linux subscription.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Subscription implements SdkPojo, Serializable, ToCopyableBuilder<Subscription.Builder, Subscription> {
    private static final SdkField<Long> INSTANCE_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("InstanceCount").getter(getter(Subscription::instanceCount)).setter(setter(Builder::instanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Subscription::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Subscription::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_COUNT_FIELD,
            NAME_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long instanceCount;

    private final String name;

    private final String type;

    private Subscription(BuilderImpl builder) {
        this.instanceCount = builder.instanceCount;
        this.name = builder.name;
        this.type = builder.type;
    }

    /**
     * <p>
     * The total amount of running instances using this subscription.
     * </p>
     * 
     * @return The total amount of running instances using this subscription.
     */
    public final Long instanceCount() {
        return instanceCount;
    }

    /**
     * <p>
     * The name of the subscription.
     * </p>
     * 
     * @return The name of the subscription.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of subscription. The type can be subscription-included with Amazon EC2, Bring Your Own Subscription
     * model (BYOS), or from the Amazon Web Services Marketplace. Certain subscriptions may use licensing from the
     * Amazon Web Services Marketplace as well as OS licensing from Amazon EC2 or BYOS.
     * </p>
     * 
     * @return The type of subscription. The type can be subscription-included with Amazon EC2, Bring Your Own
     *         Subscription model (BYOS), or from the Amazon Web Services Marketplace. Certain subscriptions may use
     *         licensing from the Amazon Web Services Marketplace as well as OS licensing from Amazon EC2 or BYOS.
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Subscription)) {
            return false;
        }
        Subscription other = (Subscription) obj;
        return Objects.equals(instanceCount(), other.instanceCount()) && Objects.equals(name(), other.name())
                && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Subscription").add("InstanceCount", instanceCount()).add("Name", name()).add("Type", type())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceCount":
            return Optional.ofNullable(clazz.cast(instanceCount()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Subscription, T> g) {
        return obj -> g.apply((Subscription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Subscription> {
        /**
         * <p>
         * The total amount of running instances using this subscription.
         * </p>
         * 
         * @param instanceCount
         *        The total amount of running instances using this subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Long instanceCount);

        /**
         * <p>
         * The name of the subscription.
         * </p>
         * 
         * @param name
         *        The name of the subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of subscription. The type can be subscription-included with Amazon EC2, Bring Your Own Subscription
         * model (BYOS), or from the Amazon Web Services Marketplace. Certain subscriptions may use licensing from the
         * Amazon Web Services Marketplace as well as OS licensing from Amazon EC2 or BYOS.
         * </p>
         * 
         * @param type
         *        The type of subscription. The type can be subscription-included with Amazon EC2, Bring Your Own
         *        Subscription model (BYOS), or from the Amazon Web Services Marketplace. Certain subscriptions may use
         *        licensing from the Amazon Web Services Marketplace as well as OS licensing from Amazon EC2 or BYOS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private Long instanceCount;

        private String name;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Subscription model) {
            instanceCount(model.instanceCount);
            name(model.name);
            type(model.type);
        }

        public final Long getInstanceCount() {
            return instanceCount;
        }

        public final void setInstanceCount(Long instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Long instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public Subscription build() {
            return new Subscription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
