/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ReceivedStatus {
    PENDING_WORKFLOW("PENDING_WORKFLOW"),
    PENDING_ACCEPT("PENDING_ACCEPT"),
    REJECTED("REJECTED"),
    ACTIVE("ACTIVE"),
    FAILED_WORKFLOW("FAILED_WORKFLOW"),
    DELETED("DELETED"),
    DISABLED("DISABLED"),
    WORKFLOW_COMPLETED("WORKFLOW_COMPLETED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ReceivedStatus> VALUE_MAP;
    private final String value;

    private ReceivedStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ReceivedStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ReceivedStatus> knownValues() {
        EnumSet<ReceivedStatus> knownValues = EnumSet.allOf(ReceivedStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ReceivedStatus.class, ReceivedStatus::toString);
    }
}

