/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLicensesRequest extends LicenseManagerRequest implements
        ToCopyableBuilder<ListLicensesRequest.Builder, ListLicensesRequest> {
    private static final SdkField<List<String>> LICENSE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LicenseArns")
            .getter(getter(ListLicensesRequest::licenseArns))
            .setter(setter(Builder::licenseArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(ListLicensesRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListLicensesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListLicensesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LICENSE_ARNS_FIELD,
            FILTERS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final List<String> licenseArns;

    private final List<Filter> filters;

    private final String nextToken;

    private final Integer maxResults;

    private ListLicensesRequest(BuilderImpl builder) {
        super(builder);
        this.licenseArns = builder.licenseArns;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the LicenseArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLicenseArns() {
        return licenseArns != null && !(licenseArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Amazon Resource Names (ARNs) of the licenses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLicenseArns} method.
     * </p>
     * 
     * @return Amazon Resource Names (ARNs) of the licenses.
     */
    public final List<String> licenseArns() {
        return licenseArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters to scope the results. The following filters are supported:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Beneficiary</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ProductSKU</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Fingerprint</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Status</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return Filters to scope the results. The following filters are supported:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Beneficiary</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ProductSKU</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Fingerprint</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Status</code>
     *         </p>
     *         </li>
     */
    public final List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * Token for the next set of results.
     * </p>
     * 
     * @return Token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Maximum number of results to return in a single call.
     * </p>
     * 
     * @return Maximum number of results to return in a single call.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLicenseArns() ? licenseArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLicensesRequest)) {
            return false;
        }
        ListLicensesRequest other = (ListLicensesRequest) obj;
        return hasLicenseArns() == other.hasLicenseArns() && Objects.equals(licenseArns(), other.licenseArns())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLicensesRequest").add("LicenseArns", hasLicenseArns() ? licenseArns() : null)
                .add("Filters", hasFilters() ? filters() : null).add("NextToken", nextToken()).add("MaxResults", maxResults())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LicenseArns":
            return Optional.ofNullable(clazz.cast(licenseArns()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLicensesRequest, T> g) {
        return obj -> g.apply((ListLicensesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListLicensesRequest> {
        /**
         * <p>
         * Amazon Resource Names (ARNs) of the licenses.
         * </p>
         * 
         * @param licenseArns
         *        Amazon Resource Names (ARNs) of the licenses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseArns(Collection<String> licenseArns);

        /**
         * <p>
         * Amazon Resource Names (ARNs) of the licenses.
         * </p>
         * 
         * @param licenseArns
         *        Amazon Resource Names (ARNs) of the licenses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseArns(String... licenseArns);

        /**
         * <p>
         * Filters to scope the results. The following filters are supported:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Beneficiary</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ProductSKU</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Fingerprint</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Status</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        Filters to scope the results. The following filters are supported:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Beneficiary</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ProductSKU</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Fingerprint</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Status</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * Filters to scope the results. The following filters are supported:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Beneficiary</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ProductSKU</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Fingerprint</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Status</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        Filters to scope the results. The following filters are supported:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Beneficiary</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ProductSKU</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Fingerprint</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Status</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * Filters to scope the results. The following filters are supported:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Beneficiary</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ProductSKU</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Fingerprint</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Status</code>
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.licensemanager.model.Filter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.licensemanager.model.Filter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.licensemanager.model.Filter.Builder#build()} is called immediately and
         * its result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.licensemanager.model.Filter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * Token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        Token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Maximum number of results to return in a single call.
         * </p>
         * 
         * @param maxResults
         *        Maximum number of results to return in a single call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LicenseManagerRequest.BuilderImpl implements Builder {
        private List<String> licenseArns = DefaultSdkAutoConstructList.getInstance();

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLicensesRequest model) {
            super(model);
            licenseArns(model.licenseArns);
            filters(model.filters);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final Collection<String> getLicenseArns() {
            if (licenseArns instanceof SdkAutoConstructList) {
                return null;
            }
            return licenseArns;
        }

        public final void setLicenseArns(Collection<String> licenseArns) {
            this.licenseArns = ArnListCopier.copy(licenseArns);
        }

        @Override
        public final Builder licenseArns(Collection<String> licenseArns) {
            this.licenseArns = ArnListCopier.copy(licenseArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseArns(String... licenseArns) {
            licenseArns(Arrays.asList(licenseArns));
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListLicensesRequest build() {
            return new ListLicensesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
