/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CheckInLicenseRequest extends LicenseManagerRequest implements
        ToCopyableBuilder<CheckInLicenseRequest.Builder, CheckInLicenseRequest> {
    private static final SdkField<String> LICENSE_CONSUMPTION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseConsumptionToken").getter(getter(CheckInLicenseRequest::licenseConsumptionToken))
            .setter(setter(Builder::licenseConsumptionToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseConsumptionToken").build())
            .build();

    private static final SdkField<String> BENEFICIARY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Beneficiary").getter(getter(CheckInLicenseRequest::beneficiary)).setter(setter(Builder::beneficiary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Beneficiary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LICENSE_CONSUMPTION_TOKEN_FIELD, BENEFICIARY_FIELD));

    private final String licenseConsumptionToken;

    private final String beneficiary;

    private CheckInLicenseRequest(BuilderImpl builder) {
        super(builder);
        this.licenseConsumptionToken = builder.licenseConsumptionToken;
        this.beneficiary = builder.beneficiary;
    }

    /**
     * <p>
     * License consumption token.
     * </p>
     * 
     * @return License consumption token.
     */
    public final String licenseConsumptionToken() {
        return licenseConsumptionToken;
    }

    /**
     * <p>
     * License beneficiary.
     * </p>
     * 
     * @return License beneficiary.
     */
    public final String beneficiary() {
        return beneficiary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(licenseConsumptionToken());
        hashCode = 31 * hashCode + Objects.hashCode(beneficiary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckInLicenseRequest)) {
            return false;
        }
        CheckInLicenseRequest other = (CheckInLicenseRequest) obj;
        return Objects.equals(licenseConsumptionToken(), other.licenseConsumptionToken())
                && Objects.equals(beneficiary(), other.beneficiary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CheckInLicenseRequest").add("LicenseConsumptionToken", licenseConsumptionToken())
                .add("Beneficiary", beneficiary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LicenseConsumptionToken":
            return Optional.ofNullable(clazz.cast(licenseConsumptionToken()));
        case "Beneficiary":
            return Optional.ofNullable(clazz.cast(beneficiary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CheckInLicenseRequest, T> g) {
        return obj -> g.apply((CheckInLicenseRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CheckInLicenseRequest> {
        /**
         * <p>
         * License consumption token.
         * </p>
         * 
         * @param licenseConsumptionToken
         *        License consumption token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseConsumptionToken(String licenseConsumptionToken);

        /**
         * <p>
         * License beneficiary.
         * </p>
         * 
         * @param beneficiary
         *        License beneficiary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beneficiary(String beneficiary);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LicenseManagerRequest.BuilderImpl implements Builder {
        private String licenseConsumptionToken;

        private String beneficiary;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckInLicenseRequest model) {
            super(model);
            licenseConsumptionToken(model.licenseConsumptionToken);
            beneficiary(model.beneficiary);
        }

        public final String getLicenseConsumptionToken() {
            return licenseConsumptionToken;
        }

        public final void setLicenseConsumptionToken(String licenseConsumptionToken) {
            this.licenseConsumptionToken = licenseConsumptionToken;
        }

        @Override
        public final Builder licenseConsumptionToken(String licenseConsumptionToken) {
            this.licenseConsumptionToken = licenseConsumptionToken;
            return this;
        }

        public final String getBeneficiary() {
            return beneficiary;
        }

        public final void setBeneficiary(String beneficiary) {
            this.beneficiary = beneficiary;
        }

        @Override
        public final Builder beneficiary(String beneficiary) {
            this.beneficiary = beneficiary;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CheckInLicenseRequest build() {
            return new CheckInLicenseRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
