/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details for associating a license configuration with a resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LicenseSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<LicenseSpecification.Builder, LicenseSpecification> {
    private static final SdkField<String> LICENSE_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseConfigurationArn").getter(getter(LicenseSpecification::licenseConfigurationArn))
            .setter(setter(Builder::licenseConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseConfigurationArn").build())
            .build();

    private static final SdkField<String> AMI_ASSOCIATION_SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AmiAssociationScope").getter(getter(LicenseSpecification::amiAssociationScope))
            .setter(setter(Builder::amiAssociationScope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmiAssociationScope").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LICENSE_CONFIGURATION_ARN_FIELD, AMI_ASSOCIATION_SCOPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String licenseConfigurationArn;

    private final String amiAssociationScope;

    private LicenseSpecification(BuilderImpl builder) {
        this.licenseConfigurationArn = builder.licenseConfigurationArn;
        this.amiAssociationScope = builder.amiAssociationScope;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the license configuration.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the license configuration.
     */
    public final String licenseConfigurationArn() {
        return licenseConfigurationArn;
    }

    /**
     * <p>
     * Scope of AMI associations. The possible value is <code>cross-account</code>.
     * </p>
     * 
     * @return Scope of AMI associations. The possible value is <code>cross-account</code>.
     */
    public final String amiAssociationScope() {
        return amiAssociationScope;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(licenseConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(amiAssociationScope());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LicenseSpecification)) {
            return false;
        }
        LicenseSpecification other = (LicenseSpecification) obj;
        return Objects.equals(licenseConfigurationArn(), other.licenseConfigurationArn())
                && Objects.equals(amiAssociationScope(), other.amiAssociationScope());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LicenseSpecification").add("LicenseConfigurationArn", licenseConfigurationArn())
                .add("AmiAssociationScope", amiAssociationScope()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LicenseConfigurationArn":
            return Optional.ofNullable(clazz.cast(licenseConfigurationArn()));
        case "AmiAssociationScope":
            return Optional.ofNullable(clazz.cast(amiAssociationScope()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LicenseSpecification, T> g) {
        return obj -> g.apply((LicenseSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LicenseSpecification> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the license configuration.
         * </p>
         * 
         * @param licenseConfigurationArn
         *        Amazon Resource Name (ARN) of the license configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseConfigurationArn(String licenseConfigurationArn);

        /**
         * <p>
         * Scope of AMI associations. The possible value is <code>cross-account</code>.
         * </p>
         * 
         * @param amiAssociationScope
         *        Scope of AMI associations. The possible value is <code>cross-account</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amiAssociationScope(String amiAssociationScope);
    }

    static final class BuilderImpl implements Builder {
        private String licenseConfigurationArn;

        private String amiAssociationScope;

        private BuilderImpl() {
        }

        private BuilderImpl(LicenseSpecification model) {
            licenseConfigurationArn(model.licenseConfigurationArn);
            amiAssociationScope(model.amiAssociationScope);
        }

        public final String getLicenseConfigurationArn() {
            return licenseConfigurationArn;
        }

        public final void setLicenseConfigurationArn(String licenseConfigurationArn) {
            this.licenseConfigurationArn = licenseConfigurationArn;
        }

        @Override
        public final Builder licenseConfigurationArn(String licenseConfigurationArn) {
            this.licenseConfigurationArn = licenseConfigurationArn;
            return this;
        }

        public final String getAmiAssociationScope() {
            return amiAssociationScope;
        }

        public final void setAmiAssociationScope(String amiAssociationScope) {
            this.amiAssociationScope = amiAssociationScope;
        }

        @Override
        public final Builder amiAssociationScope(String amiAssociationScope) {
            this.amiAssociationScope = amiAssociationScope;
            return this;
        }

        @Override
        public LicenseSpecification build() {
            return new LicenseSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
