/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexruntimev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The time that a context is active. You can specify the time to live in seconds or in conversation turns.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActiveContextTimeToLive implements SdkPojo, Serializable,
        ToCopyableBuilder<ActiveContextTimeToLive.Builder, ActiveContextTimeToLive> {
    private static final SdkField<Integer> TIME_TO_LIVE_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("timeToLiveInSeconds").getter(getter(ActiveContextTimeToLive::timeToLiveInSeconds))
            .setter(setter(Builder::timeToLiveInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeToLiveInSeconds").build())
            .build();

    private static final SdkField<Integer> TURNS_TO_LIVE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("turnsToLive").getter(getter(ActiveContextTimeToLive::turnsToLive)).setter(setter(Builder::turnsToLive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("turnsToLive").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_TO_LIVE_IN_SECONDS_FIELD,
            TURNS_TO_LIVE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer timeToLiveInSeconds;

    private final Integer turnsToLive;

    private ActiveContextTimeToLive(BuilderImpl builder) {
        this.timeToLiveInSeconds = builder.timeToLiveInSeconds;
        this.turnsToLive = builder.turnsToLive;
    }

    /**
     * <p>
     * The number of seconds that the context is active. You can specify between 5 and 86400 seconds (24 hours).
     * </p>
     * 
     * @return The number of seconds that the context is active. You can specify between 5 and 86400 seconds (24 hours).
     */
    public final Integer timeToLiveInSeconds() {
        return timeToLiveInSeconds;
    }

    /**
     * <p>
     * The number of turns that the context is active. You can specify up to 20 turns. Each request and response from
     * the bot is a turn.
     * </p>
     * 
     * @return The number of turns that the context is active. You can specify up to 20 turns. Each request and response
     *         from the bot is a turn.
     */
    public final Integer turnsToLive() {
        return turnsToLive;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timeToLiveInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(turnsToLive());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActiveContextTimeToLive)) {
            return false;
        }
        ActiveContextTimeToLive other = (ActiveContextTimeToLive) obj;
        return Objects.equals(timeToLiveInSeconds(), other.timeToLiveInSeconds())
                && Objects.equals(turnsToLive(), other.turnsToLive());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActiveContextTimeToLive").add("TimeToLiveInSeconds", timeToLiveInSeconds())
                .add("TurnsToLive", turnsToLive()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "timeToLiveInSeconds":
            return Optional.ofNullable(clazz.cast(timeToLiveInSeconds()));
        case "turnsToLive":
            return Optional.ofNullable(clazz.cast(turnsToLive()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActiveContextTimeToLive, T> g) {
        return obj -> g.apply((ActiveContextTimeToLive) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActiveContextTimeToLive> {
        /**
         * <p>
         * The number of seconds that the context is active. You can specify between 5 and 86400 seconds (24 hours).
         * </p>
         * 
         * @param timeToLiveInSeconds
         *        The number of seconds that the context is active. You can specify between 5 and 86400 seconds (24
         *        hours).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeToLiveInSeconds(Integer timeToLiveInSeconds);

        /**
         * <p>
         * The number of turns that the context is active. You can specify up to 20 turns. Each request and response
         * from the bot is a turn.
         * </p>
         * 
         * @param turnsToLive
         *        The number of turns that the context is active. You can specify up to 20 turns. Each request and
         *        response from the bot is a turn.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder turnsToLive(Integer turnsToLive);
    }

    static final class BuilderImpl implements Builder {
        private Integer timeToLiveInSeconds;

        private Integer turnsToLive;

        private BuilderImpl() {
        }

        private BuilderImpl(ActiveContextTimeToLive model) {
            timeToLiveInSeconds(model.timeToLiveInSeconds);
            turnsToLive(model.turnsToLive);
        }

        public final Integer getTimeToLiveInSeconds() {
            return timeToLiveInSeconds;
        }

        public final void setTimeToLiveInSeconds(Integer timeToLiveInSeconds) {
            this.timeToLiveInSeconds = timeToLiveInSeconds;
        }

        @Override
        public final Builder timeToLiveInSeconds(Integer timeToLiveInSeconds) {
            this.timeToLiveInSeconds = timeToLiveInSeconds;
            return this;
        }

        public final Integer getTurnsToLive() {
            return turnsToLive;
        }

        public final void setTurnsToLive(Integer turnsToLive) {
            this.turnsToLive = turnsToLive;
        }

        @Override
        public final Builder turnsToLive(Integer turnsToLive) {
            this.turnsToLive = turnsToLive;
            return this;
        }

        @Override
        public ActiveContextTimeToLive build() {
            return new ActiveContextTimeToLive(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
