/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2AsyncClient;
import software.amazon.awssdk.services.lexmodelsv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetRecordsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetRecordsResponse;

public class ListTestSetRecordsPublisher
implements SdkPublisher<ListTestSetRecordsResponse> {
    private final LexModelsV2AsyncClient client;
    private final ListTestSetRecordsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTestSetRecordsPublisher(LexModelsV2AsyncClient client, ListTestSetRecordsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTestSetRecordsPublisher(LexModelsV2AsyncClient client, ListTestSetRecordsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTestSetRecordsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTestSetRecordsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListTestSetRecordsResponseFetcher
    implements AsyncPageFetcher<ListTestSetRecordsResponse> {
        private ListTestSetRecordsResponseFetcher() {
        }

        public boolean hasNextPage(ListTestSetRecordsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTestSetRecordsResponse> nextPage(ListTestSetRecordsResponse previousPage) {
            if (previousPage == null) {
                return ListTestSetRecordsPublisher.this.client.listTestSetRecords(ListTestSetRecordsPublisher.this.firstRequest);
            }
            return ListTestSetRecordsPublisher.this.client.listTestSetRecords((ListTestSetRecordsRequest)((Object)ListTestSetRecordsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

