/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2AsyncClient;
import software.amazon.awssdk.services.lexmodelsv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.lexmodelsv2.model.ListIntentStageMetricsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListIntentStageMetricsResponse;

public class ListIntentStageMetricsPublisher
implements SdkPublisher<ListIntentStageMetricsResponse> {
    private final LexModelsV2AsyncClient client;
    private final ListIntentStageMetricsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListIntentStageMetricsPublisher(LexModelsV2AsyncClient client, ListIntentStageMetricsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListIntentStageMetricsPublisher(LexModelsV2AsyncClient client, ListIntentStageMetricsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListIntentStageMetricsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListIntentStageMetricsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListIntentStageMetricsResponseFetcher
    implements AsyncPageFetcher<ListIntentStageMetricsResponse> {
        private ListIntentStageMetricsResponseFetcher() {
        }

        public boolean hasNextPage(ListIntentStageMetricsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListIntentStageMetricsResponse> nextPage(ListIntentStageMetricsResponse previousPage) {
            if (previousPage == null) {
                return ListIntentStageMetricsPublisher.this.client.listIntentStageMetrics(ListIntentStageMetricsPublisher.this.firstRequest);
            }
            return ListIntentStageMetricsPublisher.this.client.listIntentStageMetrics((ListIntentStageMetricsRequest)((Object)ListIntentStageMetricsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

