/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2AsyncClient;
import software.amazon.awssdk.services.lexmodelsv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.lexmodelsv2.model.ListCustomVocabularyItemsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListCustomVocabularyItemsResponse;

public class ListCustomVocabularyItemsPublisher
implements SdkPublisher<ListCustomVocabularyItemsResponse> {
    private final LexModelsV2AsyncClient client;
    private final ListCustomVocabularyItemsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCustomVocabularyItemsPublisher(LexModelsV2AsyncClient client, ListCustomVocabularyItemsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCustomVocabularyItemsPublisher(LexModelsV2AsyncClient client, ListCustomVocabularyItemsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCustomVocabularyItemsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCustomVocabularyItemsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListCustomVocabularyItemsResponseFetcher
    implements AsyncPageFetcher<ListCustomVocabularyItemsResponse> {
        private ListCustomVocabularyItemsResponseFetcher() {
        }

        public boolean hasNextPage(ListCustomVocabularyItemsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCustomVocabularyItemsResponse> nextPage(ListCustomVocabularyItemsResponse previousPage) {
            if (previousPage == null) {
                return ListCustomVocabularyItemsPublisher.this.client.listCustomVocabularyItems(ListCustomVocabularyItemsPublisher.this.firstRequest);
            }
            return ListCustomVocabularyItemsPublisher.this.client.listCustomVocabularyItems((ListCustomVocabularyItemsRequest)((Object)ListCustomVocabularyItemsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

