/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum VoiceEngine {
    STANDARD("standard"),
    NEURAL("neural"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, VoiceEngine> VALUE_MAP;
    private final String value;

    private VoiceEngine(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static VoiceEngine fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<VoiceEngine> knownValues() {
        EnumSet<VoiceEngine> knownValues = EnumSet.allOf(VoiceEngine.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(VoiceEngine.class, VoiceEngine::toString);
    }
}

