/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The object representing the filter that Amazon Lex will use to select the appropriate transcript.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TranscriptFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<TranscriptFilter.Builder, TranscriptFilter> {
    private static final SdkField<LexTranscriptFilter> LEX_TRANSCRIPT_FILTER_FIELD = SdkField
            .<LexTranscriptFilter> builder(MarshallingType.SDK_POJO).memberName("lexTranscriptFilter")
            .getter(getter(TranscriptFilter::lexTranscriptFilter)).setter(setter(Builder::lexTranscriptFilter))
            .constructor(LexTranscriptFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lexTranscriptFilter").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LEX_TRANSCRIPT_FILTER_FIELD));

    private static final long serialVersionUID = 1L;

    private final LexTranscriptFilter lexTranscriptFilter;

    private TranscriptFilter(BuilderImpl builder) {
        this.lexTranscriptFilter = builder.lexTranscriptFilter;
    }

    /**
     * <p>
     * The object representing the filter that Amazon Lex will use to select the appropriate transcript when the
     * transcript format is the Amazon Lex format.
     * </p>
     * 
     * @return The object representing the filter that Amazon Lex will use to select the appropriate transcript when the
     *         transcript format is the Amazon Lex format.
     */
    public final LexTranscriptFilter lexTranscriptFilter() {
        return lexTranscriptFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lexTranscriptFilter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TranscriptFilter)) {
            return false;
        }
        TranscriptFilter other = (TranscriptFilter) obj;
        return Objects.equals(lexTranscriptFilter(), other.lexTranscriptFilter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TranscriptFilter").add("LexTranscriptFilter", lexTranscriptFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lexTranscriptFilter":
            return Optional.ofNullable(clazz.cast(lexTranscriptFilter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TranscriptFilter, T> g) {
        return obj -> g.apply((TranscriptFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TranscriptFilter> {
        /**
         * <p>
         * The object representing the filter that Amazon Lex will use to select the appropriate transcript when the
         * transcript format is the Amazon Lex format.
         * </p>
         * 
         * @param lexTranscriptFilter
         *        The object representing the filter that Amazon Lex will use to select the appropriate transcript when
         *        the transcript format is the Amazon Lex format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lexTranscriptFilter(LexTranscriptFilter lexTranscriptFilter);

        /**
         * <p>
         * The object representing the filter that Amazon Lex will use to select the appropriate transcript when the
         * transcript format is the Amazon Lex format.
         * </p>
         * This is a convenience method that creates an instance of the {@link LexTranscriptFilter.Builder} avoiding the
         * need to create one manually via {@link LexTranscriptFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LexTranscriptFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #lexTranscriptFilter(LexTranscriptFilter)}.
         * 
         * @param lexTranscriptFilter
         *        a consumer that will call methods on {@link LexTranscriptFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lexTranscriptFilter(LexTranscriptFilter)
         */
        default Builder lexTranscriptFilter(Consumer<LexTranscriptFilter.Builder> lexTranscriptFilter) {
            return lexTranscriptFilter(LexTranscriptFilter.builder().applyMutation(lexTranscriptFilter).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LexTranscriptFilter lexTranscriptFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(TranscriptFilter model) {
            lexTranscriptFilter(model.lexTranscriptFilter);
        }

        public final LexTranscriptFilter.Builder getLexTranscriptFilter() {
            return lexTranscriptFilter != null ? lexTranscriptFilter.toBuilder() : null;
        }

        public final void setLexTranscriptFilter(LexTranscriptFilter.BuilderImpl lexTranscriptFilter) {
            this.lexTranscriptFilter = lexTranscriptFilter != null ? lexTranscriptFilter.build() : null;
        }

        @Override
        public final Builder lexTranscriptFilter(LexTranscriptFilter lexTranscriptFilter) {
            this.lexTranscriptFilter = lexTranscriptFilter;
            return this;
        }

        @Override
        public TranscriptFilter build() {
            return new TranscriptFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
