/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartBotRecommendationRequest extends LexModelsV2Request implements
        ToCopyableBuilder<StartBotRecommendationRequest.Builder, StartBotRecommendationRequest> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(StartBotRecommendationRequest::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(StartBotRecommendationRequest::botVersion))
            .setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botVersion").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(StartBotRecommendationRequest::localeId)).setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("localeId").build()).build();

    private static final SdkField<TranscriptSourceSetting> TRANSCRIPT_SOURCE_SETTING_FIELD = SdkField
            .<TranscriptSourceSetting> builder(MarshallingType.SDK_POJO).memberName("transcriptSourceSetting")
            .getter(getter(StartBotRecommendationRequest::transcriptSourceSetting))
            .setter(setter(Builder::transcriptSourceSetting)).constructor(TranscriptSourceSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transcriptSourceSetting").build())
            .build();

    private static final SdkField<EncryptionSetting> ENCRYPTION_SETTING_FIELD = SdkField
            .<EncryptionSetting> builder(MarshallingType.SDK_POJO).memberName("encryptionSetting")
            .getter(getter(StartBotRecommendationRequest::encryptionSetting)).setter(setter(Builder::encryptionSetting))
            .constructor(EncryptionSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionSetting").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            BOT_VERSION_FIELD, LOCALE_ID_FIELD, TRANSCRIPT_SOURCE_SETTING_FIELD, ENCRYPTION_SETTING_FIELD));

    private final String botId;

    private final String botVersion;

    private final String localeId;

    private final TranscriptSourceSetting transcriptSourceSetting;

    private final EncryptionSetting encryptionSetting;

    private StartBotRecommendationRequest(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.transcriptSourceSetting = builder.transcriptSourceSetting;
        this.encryptionSetting = builder.encryptionSetting;
    }

    /**
     * <p>
     * The unique identifier of the bot containing the bot recommendation.
     * </p>
     * 
     * @return The unique identifier of the bot containing the bot recommendation.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The version of the bot containing the bot recommendation.
     * </p>
     * 
     * @return The version of the bot containing the bot recommendation.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The identifier of the language and locale of the bot recommendation to start. The string must match one of the
     * supported locales. For more information, see <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>
     * </p>
     * 
     * @return The identifier of the language and locale of the bot recommendation to start. The string must match one
     *         of the supported locales. For more information, see <a
     *         href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>
     */
    public final String localeId() {
        return localeId;
    }

    /**
     * <p>
     * The object representing the Amazon S3 bucket containing the transcript, as well as the associated metadata.
     * </p>
     * 
     * @return The object representing the Amazon S3 bucket containing the transcript, as well as the associated
     *         metadata.
     */
    public final TranscriptSourceSetting transcriptSourceSetting() {
        return transcriptSourceSetting;
    }

    /**
     * <p>
     * The object representing the passwords that will be used to encrypt the data related to the bot recommendation
     * results, as well as the KMS key ARN used to encrypt the associated metadata.
     * </p>
     * 
     * @return The object representing the passwords that will be used to encrypt the data related to the bot
     *         recommendation results, as well as the KMS key ARN used to encrypt the associated metadata.
     */
    public final EncryptionSetting encryptionSetting() {
        return encryptionSetting;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        hashCode = 31 * hashCode + Objects.hashCode(transcriptSourceSetting());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionSetting());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartBotRecommendationRequest)) {
            return false;
        }
        StartBotRecommendationRequest other = (StartBotRecommendationRequest) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(botVersion(), other.botVersion())
                && Objects.equals(localeId(), other.localeId())
                && Objects.equals(transcriptSourceSetting(), other.transcriptSourceSetting())
                && Objects.equals(encryptionSetting(), other.encryptionSetting());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartBotRecommendationRequest").add("BotId", botId()).add("BotVersion", botVersion())
                .add("LocaleId", localeId()).add("TranscriptSourceSetting", transcriptSourceSetting())
                .add("EncryptionSetting", encryptionSetting()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        case "transcriptSourceSetting":
            return Optional.ofNullable(clazz.cast(transcriptSourceSetting()));
        case "encryptionSetting":
            return Optional.ofNullable(clazz.cast(encryptionSetting()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartBotRecommendationRequest, T> g) {
        return obj -> g.apply((StartBotRecommendationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Request.Builder, SdkPojo, CopyableBuilder<Builder, StartBotRecommendationRequest> {
        /**
         * <p>
         * The unique identifier of the bot containing the bot recommendation.
         * </p>
         * 
         * @param botId
         *        The unique identifier of the bot containing the bot recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The version of the bot containing the bot recommendation.
         * </p>
         * 
         * @param botVersion
         *        The version of the bot containing the bot recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The identifier of the language and locale of the bot recommendation to start. The string must match one of
         * the supported locales. For more information, see <a
         * href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>
         * </p>
         * 
         * @param localeId
         *        The identifier of the language and locale of the bot recommendation to start. The string must match
         *        one of the supported locales. For more information, see <a
         *        href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);

        /**
         * <p>
         * The object representing the Amazon S3 bucket containing the transcript, as well as the associated metadata.
         * </p>
         * 
         * @param transcriptSourceSetting
         *        The object representing the Amazon S3 bucket containing the transcript, as well as the associated
         *        metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transcriptSourceSetting(TranscriptSourceSetting transcriptSourceSetting);

        /**
         * <p>
         * The object representing the Amazon S3 bucket containing the transcript, as well as the associated metadata.
         * </p>
         * This is a convenience method that creates an instance of the {@link TranscriptSourceSetting.Builder} avoiding
         * the need to create one manually via {@link TranscriptSourceSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TranscriptSourceSetting.Builder#build()} is called immediately
         * and its result is passed to {@link #transcriptSourceSetting(TranscriptSourceSetting)}.
         * 
         * @param transcriptSourceSetting
         *        a consumer that will call methods on {@link TranscriptSourceSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transcriptSourceSetting(TranscriptSourceSetting)
         */
        default Builder transcriptSourceSetting(Consumer<TranscriptSourceSetting.Builder> transcriptSourceSetting) {
            return transcriptSourceSetting(TranscriptSourceSetting.builder().applyMutation(transcriptSourceSetting).build());
        }

        /**
         * <p>
         * The object representing the passwords that will be used to encrypt the data related to the bot recommendation
         * results, as well as the KMS key ARN used to encrypt the associated metadata.
         * </p>
         * 
         * @param encryptionSetting
         *        The object representing the passwords that will be used to encrypt the data related to the bot
         *        recommendation results, as well as the KMS key ARN used to encrypt the associated metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionSetting(EncryptionSetting encryptionSetting);

        /**
         * <p>
         * The object representing the passwords that will be used to encrypt the data related to the bot recommendation
         * results, as well as the KMS key ARN used to encrypt the associated metadata.
         * </p>
         * This is a convenience method that creates an instance of the {@link EncryptionSetting.Builder} avoiding the
         * need to create one manually via {@link EncryptionSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionSetting.Builder#build()} is called immediately and its
         * result is passed to {@link #encryptionSetting(EncryptionSetting)}.
         * 
         * @param encryptionSetting
         *        a consumer that will call methods on {@link EncryptionSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionSetting(EncryptionSetting)
         */
        default Builder encryptionSetting(Consumer<EncryptionSetting.Builder> encryptionSetting) {
            return encryptionSetting(EncryptionSetting.builder().applyMutation(encryptionSetting).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelsV2Request.BuilderImpl implements Builder {
        private String botId;

        private String botVersion;

        private String localeId;

        private TranscriptSourceSetting transcriptSourceSetting;

        private EncryptionSetting encryptionSetting;

        private BuilderImpl() {
        }

        private BuilderImpl(StartBotRecommendationRequest model) {
            super(model);
            botId(model.botId);
            botVersion(model.botVersion);
            localeId(model.localeId);
            transcriptSourceSetting(model.transcriptSourceSetting);
            encryptionSetting(model.encryptionSetting);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final TranscriptSourceSetting.Builder getTranscriptSourceSetting() {
            return transcriptSourceSetting != null ? transcriptSourceSetting.toBuilder() : null;
        }

        public final void setTranscriptSourceSetting(TranscriptSourceSetting.BuilderImpl transcriptSourceSetting) {
            this.transcriptSourceSetting = transcriptSourceSetting != null ? transcriptSourceSetting.build() : null;
        }

        @Override
        public final Builder transcriptSourceSetting(TranscriptSourceSetting transcriptSourceSetting) {
            this.transcriptSourceSetting = transcriptSourceSetting;
            return this;
        }

        public final EncryptionSetting.Builder getEncryptionSetting() {
            return encryptionSetting != null ? encryptionSetting.toBuilder() : null;
        }

        public final void setEncryptionSetting(EncryptionSetting.BuilderImpl encryptionSetting) {
            this.encryptionSetting = encryptionSetting != null ? encryptionSetting.build() : null;
        }

        @Override
        public final Builder encryptionSetting(EncryptionSetting encryptionSetting) {
            this.encryptionSetting = encryptionSetting;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartBotRecommendationRequest build() {
            return new StartBotRecommendationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
