/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies attributes for sorting a list of slot types.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SlotTypeSortBy implements SdkPojo, Serializable, ToCopyableBuilder<SlotTypeSortBy.Builder, SlotTypeSortBy> {
    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("attribute").getter(getter(SlotTypeSortBy::attributeAsString)).setter(setter(Builder::attribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attribute").build()).build();

    private static final SdkField<String> ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("order")
            .getter(getter(SlotTypeSortBy::orderAsString)).setter(setter(Builder::order))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("order").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_FIELD, ORDER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String attribute;

    private final String order;

    private SlotTypeSortBy(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.order = builder.order;
    }

    /**
     * <p>
     * The attribute to use to sort the list of slot types.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link SlotTypeSortAttribute#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #attributeAsString}.
     * </p>
     * 
     * @return The attribute to use to sort the list of slot types.
     * @see SlotTypeSortAttribute
     */
    public final SlotTypeSortAttribute attribute() {
        return SlotTypeSortAttribute.fromValue(attribute);
    }

    /**
     * <p>
     * The attribute to use to sort the list of slot types.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link SlotTypeSortAttribute#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #attributeAsString}.
     * </p>
     * 
     * @return The attribute to use to sort the list of slot types.
     * @see SlotTypeSortAttribute
     */
    public final String attributeAsString() {
        return attribute;
    }

    /**
     * <p>
     * The order to sort the list. You can say ascending or descending.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #order} will return
     * {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #orderAsString}.
     * </p>
     * 
     * @return The order to sort the list. You can say ascending or descending.
     * @see SortOrder
     */
    public final SortOrder order() {
        return SortOrder.fromValue(order);
    }

    /**
     * <p>
     * The order to sort the list. You can say ascending or descending.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #order} will return
     * {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #orderAsString}.
     * </p>
     * 
     * @return The order to sort the list. You can say ascending or descending.
     * @see SortOrder
     */
    public final String orderAsString() {
        return order;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(orderAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlotTypeSortBy)) {
            return false;
        }
        SlotTypeSortBy other = (SlotTypeSortBy) obj;
        return Objects.equals(attributeAsString(), other.attributeAsString())
                && Objects.equals(orderAsString(), other.orderAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SlotTypeSortBy").add("Attribute", attributeAsString()).add("Order", orderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attribute":
            return Optional.ofNullable(clazz.cast(attributeAsString()));
        case "order":
            return Optional.ofNullable(clazz.cast(orderAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SlotTypeSortBy, T> g) {
        return obj -> g.apply((SlotTypeSortBy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SlotTypeSortBy> {
        /**
         * <p>
         * The attribute to use to sort the list of slot types.
         * </p>
         * 
         * @param attribute
         *        The attribute to use to sort the list of slot types.
         * @see SlotTypeSortAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SlotTypeSortAttribute
         */
        Builder attribute(String attribute);

        /**
         * <p>
         * The attribute to use to sort the list of slot types.
         * </p>
         * 
         * @param attribute
         *        The attribute to use to sort the list of slot types.
         * @see SlotTypeSortAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SlotTypeSortAttribute
         */
        Builder attribute(SlotTypeSortAttribute attribute);

        /**
         * <p>
         * The order to sort the list. You can say ascending or descending.
         * </p>
         * 
         * @param order
         *        The order to sort the list. You can say ascending or descending.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder order(String order);

        /**
         * <p>
         * The order to sort the list. You can say ascending or descending.
         * </p>
         * 
         * @param order
         *        The order to sort the list. You can say ascending or descending.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder order(SortOrder order);
    }

    static final class BuilderImpl implements Builder {
        private String attribute;

        private String order;

        private BuilderImpl() {
        }

        private BuilderImpl(SlotTypeSortBy model) {
            attribute(model.attribute);
            order(model.order);
        }

        public final String getAttribute() {
            return attribute;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(SlotTypeSortAttribute attribute) {
            this.attribute(attribute == null ? null : attribute.toString());
            return this;
        }

        public final String getOrder() {
            return order;
        }

        public final void setOrder(String order) {
            this.order = order;
        }

        @Override
        public final Builder order(String order) {
            this.order = order;
            return this;
        }

        @Override
        public final Builder order(SortOrder order) {
            this.order(order == null ? null : order.toString());
            return this;
        }

        @Override
        public SlotTypeSortBy build() {
            return new SlotTypeSortBy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
