/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The object representing the URL of the bot definition, the URL of the associated transcript, and a statistical
 * summary of the bot recommendation results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BotRecommendationResults implements SdkPojo, Serializable,
        ToCopyableBuilder<BotRecommendationResults.Builder, BotRecommendationResults> {
    private static final SdkField<String> BOT_LOCALE_EXPORT_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botLocaleExportUrl").getter(getter(BotRecommendationResults::botLocaleExportUrl))
            .setter(setter(Builder::botLocaleExportUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botLocaleExportUrl").build())
            .build();

    private static final SdkField<String> ASSOCIATED_TRANSCRIPTS_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("associatedTranscriptsUrl").getter(getter(BotRecommendationResults::associatedTranscriptsUrl))
            .setter(setter(Builder::associatedTranscriptsUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedTranscriptsUrl").build())
            .build();

    private static final SdkField<BotRecommendationResultStatistics> STATISTICS_FIELD = SdkField
            .<BotRecommendationResultStatistics> builder(MarshallingType.SDK_POJO).memberName("statistics")
            .getter(getter(BotRecommendationResults::statistics)).setter(setter(Builder::statistics))
            .constructor(BotRecommendationResultStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statistics").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_LOCALE_EXPORT_URL_FIELD,
            ASSOCIATED_TRANSCRIPTS_URL_FIELD, STATISTICS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String botLocaleExportUrl;

    private final String associatedTranscriptsUrl;

    private final BotRecommendationResultStatistics statistics;

    private BotRecommendationResults(BuilderImpl builder) {
        this.botLocaleExportUrl = builder.botLocaleExportUrl;
        this.associatedTranscriptsUrl = builder.associatedTranscriptsUrl;
        this.statistics = builder.statistics;
    }

    /**
     * <p>
     * The presigned URL link of the recommended bot definition.
     * </p>
     * 
     * @return The presigned URL link of the recommended bot definition.
     */
    public final String botLocaleExportUrl() {
        return botLocaleExportUrl;
    }

    /**
     * <p>
     * The presigned url link of the associated transcript.
     * </p>
     * 
     * @return The presigned url link of the associated transcript.
     */
    public final String associatedTranscriptsUrl() {
        return associatedTranscriptsUrl;
    }

    /**
     * <p>
     * The statistical summary of the bot recommendation results.
     * </p>
     * 
     * @return The statistical summary of the bot recommendation results.
     */
    public final BotRecommendationResultStatistics statistics() {
        return statistics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(botLocaleExportUrl());
        hashCode = 31 * hashCode + Objects.hashCode(associatedTranscriptsUrl());
        hashCode = 31 * hashCode + Objects.hashCode(statistics());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BotRecommendationResults)) {
            return false;
        }
        BotRecommendationResults other = (BotRecommendationResults) obj;
        return Objects.equals(botLocaleExportUrl(), other.botLocaleExportUrl())
                && Objects.equals(associatedTranscriptsUrl(), other.associatedTranscriptsUrl())
                && Objects.equals(statistics(), other.statistics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BotRecommendationResults").add("BotLocaleExportUrl", botLocaleExportUrl())
                .add("AssociatedTranscriptsUrl", associatedTranscriptsUrl()).add("Statistics", statistics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botLocaleExportUrl":
            return Optional.ofNullable(clazz.cast(botLocaleExportUrl()));
        case "associatedTranscriptsUrl":
            return Optional.ofNullable(clazz.cast(associatedTranscriptsUrl()));
        case "statistics":
            return Optional.ofNullable(clazz.cast(statistics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BotRecommendationResults, T> g) {
        return obj -> g.apply((BotRecommendationResults) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BotRecommendationResults> {
        /**
         * <p>
         * The presigned URL link of the recommended bot definition.
         * </p>
         * 
         * @param botLocaleExportUrl
         *        The presigned URL link of the recommended bot definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botLocaleExportUrl(String botLocaleExportUrl);

        /**
         * <p>
         * The presigned url link of the associated transcript.
         * </p>
         * 
         * @param associatedTranscriptsUrl
         *        The presigned url link of the associated transcript.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedTranscriptsUrl(String associatedTranscriptsUrl);

        /**
         * <p>
         * The statistical summary of the bot recommendation results.
         * </p>
         * 
         * @param statistics
         *        The statistical summary of the bot recommendation results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statistics(BotRecommendationResultStatistics statistics);

        /**
         * <p>
         * The statistical summary of the bot recommendation results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link BotRecommendationResultStatistics.Builder} avoiding the need to create one manually via
         * {@link BotRecommendationResultStatistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BotRecommendationResultStatistics.Builder#build()} is called
         * immediately and its result is passed to {@link #statistics(BotRecommendationResultStatistics)}.
         * 
         * @param statistics
         *        a consumer that will call methods on {@link BotRecommendationResultStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statistics(BotRecommendationResultStatistics)
         */
        default Builder statistics(Consumer<BotRecommendationResultStatistics.Builder> statistics) {
            return statistics(BotRecommendationResultStatistics.builder().applyMutation(statistics).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String botLocaleExportUrl;

        private String associatedTranscriptsUrl;

        private BotRecommendationResultStatistics statistics;

        private BuilderImpl() {
        }

        private BuilderImpl(BotRecommendationResults model) {
            botLocaleExportUrl(model.botLocaleExportUrl);
            associatedTranscriptsUrl(model.associatedTranscriptsUrl);
            statistics(model.statistics);
        }

        public final String getBotLocaleExportUrl() {
            return botLocaleExportUrl;
        }

        public final void setBotLocaleExportUrl(String botLocaleExportUrl) {
            this.botLocaleExportUrl = botLocaleExportUrl;
        }

        @Override
        public final Builder botLocaleExportUrl(String botLocaleExportUrl) {
            this.botLocaleExportUrl = botLocaleExportUrl;
            return this;
        }

        public final String getAssociatedTranscriptsUrl() {
            return associatedTranscriptsUrl;
        }

        public final void setAssociatedTranscriptsUrl(String associatedTranscriptsUrl) {
            this.associatedTranscriptsUrl = associatedTranscriptsUrl;
        }

        @Override
        public final Builder associatedTranscriptsUrl(String associatedTranscriptsUrl) {
            this.associatedTranscriptsUrl = associatedTranscriptsUrl;
            return this;
        }

        public final BotRecommendationResultStatistics.Builder getStatistics() {
            return statistics != null ? statistics.toBuilder() : null;
        }

        public final void setStatistics(BotRecommendationResultStatistics.BuilderImpl statistics) {
            this.statistics = statistics != null ? statistics.build() : null;
        }

        @Override
        public final Builder statistics(BotRecommendationResultStatistics statistics) {
            this.statistics = statistics;
            return this;
        }

        @Override
        public BotRecommendationResults build() {
            return new BotRecommendationResults(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
