/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the audio and DTMF input specification.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AudioAndDTMFInputSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<AudioAndDTMFInputSpecification.Builder, AudioAndDTMFInputSpecification> {
    private static final SdkField<Integer> START_TIMEOUT_MS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("startTimeoutMs").getter(getter(AudioAndDTMFInputSpecification::startTimeoutMs))
            .setter(setter(Builder::startTimeoutMs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTimeoutMs").build()).build();

    private static final SdkField<AudioSpecification> AUDIO_SPECIFICATION_FIELD = SdkField
            .<AudioSpecification> builder(MarshallingType.SDK_POJO).memberName("audioSpecification")
            .getter(getter(AudioAndDTMFInputSpecification::audioSpecification)).setter(setter(Builder::audioSpecification))
            .constructor(AudioSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioSpecification").build())
            .build();

    private static final SdkField<DTMFSpecification> DTMF_SPECIFICATION_FIELD = SdkField
            .<DTMFSpecification> builder(MarshallingType.SDK_POJO).memberName("dtmfSpecification")
            .getter(getter(AudioAndDTMFInputSpecification::dtmfSpecification)).setter(setter(Builder::dtmfSpecification))
            .constructor(DTMFSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dtmfSpecification").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIMEOUT_MS_FIELD,
            AUDIO_SPECIFICATION_FIELD, DTMF_SPECIFICATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer startTimeoutMs;

    private final AudioSpecification audioSpecification;

    private final DTMFSpecification dtmfSpecification;

    private AudioAndDTMFInputSpecification(BuilderImpl builder) {
        this.startTimeoutMs = builder.startTimeoutMs;
        this.audioSpecification = builder.audioSpecification;
        this.dtmfSpecification = builder.dtmfSpecification;
    }

    /**
     * <p>
     * Time for which a bot waits before assuming that the customer isn't going to speak or press a key. This timeout is
     * shared between Audio and DTMF inputs.
     * </p>
     * 
     * @return Time for which a bot waits before assuming that the customer isn't going to speak or press a key. This
     *         timeout is shared between Audio and DTMF inputs.
     */
    public final Integer startTimeoutMs() {
        return startTimeoutMs;
    }

    /**
     * <p>
     * Specifies the settings on audio input.
     * </p>
     * 
     * @return Specifies the settings on audio input.
     */
    public final AudioSpecification audioSpecification() {
        return audioSpecification;
    }

    /**
     * <p>
     * Specifies the settings on DTMF input.
     * </p>
     * 
     * @return Specifies the settings on DTMF input.
     */
    public final DTMFSpecification dtmfSpecification() {
        return dtmfSpecification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startTimeoutMs());
        hashCode = 31 * hashCode + Objects.hashCode(audioSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(dtmfSpecification());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioAndDTMFInputSpecification)) {
            return false;
        }
        AudioAndDTMFInputSpecification other = (AudioAndDTMFInputSpecification) obj;
        return Objects.equals(startTimeoutMs(), other.startTimeoutMs())
                && Objects.equals(audioSpecification(), other.audioSpecification())
                && Objects.equals(dtmfSpecification(), other.dtmfSpecification());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AudioAndDTMFInputSpecification").add("StartTimeoutMs", startTimeoutMs())
                .add("AudioSpecification", audioSpecification()).add("DtmfSpecification", dtmfSpecification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "startTimeoutMs":
            return Optional.ofNullable(clazz.cast(startTimeoutMs()));
        case "audioSpecification":
            return Optional.ofNullable(clazz.cast(audioSpecification()));
        case "dtmfSpecification":
            return Optional.ofNullable(clazz.cast(dtmfSpecification()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudioAndDTMFInputSpecification, T> g) {
        return obj -> g.apply((AudioAndDTMFInputSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AudioAndDTMFInputSpecification> {
        /**
         * <p>
         * Time for which a bot waits before assuming that the customer isn't going to speak or press a key. This
         * timeout is shared between Audio and DTMF inputs.
         * </p>
         * 
         * @param startTimeoutMs
         *        Time for which a bot waits before assuming that the customer isn't going to speak or press a key. This
         *        timeout is shared between Audio and DTMF inputs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimeoutMs(Integer startTimeoutMs);

        /**
         * <p>
         * Specifies the settings on audio input.
         * </p>
         * 
         * @param audioSpecification
         *        Specifies the settings on audio input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioSpecification(AudioSpecification audioSpecification);

        /**
         * <p>
         * Specifies the settings on audio input.
         * </p>
         * This is a convenience method that creates an instance of the {@link AudioSpecification.Builder} avoiding the
         * need to create one manually via {@link AudioSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AudioSpecification.Builder#build()} is called immediately and its
         * result is passed to {@link #audioSpecification(AudioSpecification)}.
         * 
         * @param audioSpecification
         *        a consumer that will call methods on {@link AudioSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #audioSpecification(AudioSpecification)
         */
        default Builder audioSpecification(Consumer<AudioSpecification.Builder> audioSpecification) {
            return audioSpecification(AudioSpecification.builder().applyMutation(audioSpecification).build());
        }

        /**
         * <p>
         * Specifies the settings on DTMF input.
         * </p>
         * 
         * @param dtmfSpecification
         *        Specifies the settings on DTMF input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dtmfSpecification(DTMFSpecification dtmfSpecification);

        /**
         * <p>
         * Specifies the settings on DTMF input.
         * </p>
         * This is a convenience method that creates an instance of the {@link DTMFSpecification.Builder} avoiding the
         * need to create one manually via {@link DTMFSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DTMFSpecification.Builder#build()} is called immediately and its
         * result is passed to {@link #dtmfSpecification(DTMFSpecification)}.
         * 
         * @param dtmfSpecification
         *        a consumer that will call methods on {@link DTMFSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dtmfSpecification(DTMFSpecification)
         */
        default Builder dtmfSpecification(Consumer<DTMFSpecification.Builder> dtmfSpecification) {
            return dtmfSpecification(DTMFSpecification.builder().applyMutation(dtmfSpecification).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer startTimeoutMs;

        private AudioSpecification audioSpecification;

        private DTMFSpecification dtmfSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioAndDTMFInputSpecification model) {
            startTimeoutMs(model.startTimeoutMs);
            audioSpecification(model.audioSpecification);
            dtmfSpecification(model.dtmfSpecification);
        }

        public final Integer getStartTimeoutMs() {
            return startTimeoutMs;
        }

        public final void setStartTimeoutMs(Integer startTimeoutMs) {
            this.startTimeoutMs = startTimeoutMs;
        }

        @Override
        public final Builder startTimeoutMs(Integer startTimeoutMs) {
            this.startTimeoutMs = startTimeoutMs;
            return this;
        }

        public final AudioSpecification.Builder getAudioSpecification() {
            return audioSpecification != null ? audioSpecification.toBuilder() : null;
        }

        public final void setAudioSpecification(AudioSpecification.BuilderImpl audioSpecification) {
            this.audioSpecification = audioSpecification != null ? audioSpecification.build() : null;
        }

        @Override
        public final Builder audioSpecification(AudioSpecification audioSpecification) {
            this.audioSpecification = audioSpecification;
            return this;
        }

        public final DTMFSpecification.Builder getDtmfSpecification() {
            return dtmfSpecification != null ? dtmfSpecification.toBuilder() : null;
        }

        public final void setDtmfSpecification(DTMFSpecification.BuilderImpl dtmfSpecification) {
            this.dtmfSpecification = dtmfSpecification != null ? dtmfSpecification.build() : null;
        }

        @Override
        public final Builder dtmfSpecification(DTMFSpecification dtmfSpecification) {
            this.dtmfSpecification = dtmfSpecification;
            return this;
        }

        @Override
        public AudioAndDTMFInputSpecification build() {
            return new AudioAndDTMFInputSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
