/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the allowed input types.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AllowedInputTypes implements SdkPojo, Serializable,
        ToCopyableBuilder<AllowedInputTypes.Builder, AllowedInputTypes> {
    private static final SdkField<Boolean> ALLOW_AUDIO_INPUT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("allowAudioInput").getter(getter(AllowedInputTypes::allowAudioInput))
            .setter(setter(Builder::allowAudioInput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowAudioInput").build()).build();

    private static final SdkField<Boolean> ALLOW_DTMF_INPUT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("allowDTMFInput").getter(getter(AllowedInputTypes::allowDTMFInput))
            .setter(setter(Builder::allowDTMFInput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowDTMFInput").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOW_AUDIO_INPUT_FIELD,
            ALLOW_DTMF_INPUT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean allowAudioInput;

    private final Boolean allowDTMFInput;

    private AllowedInputTypes(BuilderImpl builder) {
        this.allowAudioInput = builder.allowAudioInput;
        this.allowDTMFInput = builder.allowDTMFInput;
    }

    /**
     * <p>
     * Indicates whether audio input is allowed.
     * </p>
     * 
     * @return Indicates whether audio input is allowed.
     */
    public final Boolean allowAudioInput() {
        return allowAudioInput;
    }

    /**
     * <p>
     * Indicates whether DTMF input is allowed.
     * </p>
     * 
     * @return Indicates whether DTMF input is allowed.
     */
    public final Boolean allowDTMFInput() {
        return allowDTMFInput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allowAudioInput());
        hashCode = 31 * hashCode + Objects.hashCode(allowDTMFInput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllowedInputTypes)) {
            return false;
        }
        AllowedInputTypes other = (AllowedInputTypes) obj;
        return Objects.equals(allowAudioInput(), other.allowAudioInput())
                && Objects.equals(allowDTMFInput(), other.allowDTMFInput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AllowedInputTypes").add("AllowAudioInput", allowAudioInput())
                .add("AllowDTMFInput", allowDTMFInput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "allowAudioInput":
            return Optional.ofNullable(clazz.cast(allowAudioInput()));
        case "allowDTMFInput":
            return Optional.ofNullable(clazz.cast(allowDTMFInput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AllowedInputTypes, T> g) {
        return obj -> g.apply((AllowedInputTypes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AllowedInputTypes> {
        /**
         * <p>
         * Indicates whether audio input is allowed.
         * </p>
         * 
         * @param allowAudioInput
         *        Indicates whether audio input is allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowAudioInput(Boolean allowAudioInput);

        /**
         * <p>
         * Indicates whether DTMF input is allowed.
         * </p>
         * 
         * @param allowDTMFInput
         *        Indicates whether DTMF input is allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowDTMFInput(Boolean allowDTMFInput);
    }

    static final class BuilderImpl implements Builder {
        private Boolean allowAudioInput;

        private Boolean allowDTMFInput;

        private BuilderImpl() {
        }

        private BuilderImpl(AllowedInputTypes model) {
            allowAudioInput(model.allowAudioInput);
            allowDTMFInput(model.allowDTMFInput);
        }

        public final Boolean getAllowAudioInput() {
            return allowAudioInput;
        }

        public final void setAllowAudioInput(Boolean allowAudioInput) {
            this.allowAudioInput = allowAudioInput;
        }

        @Override
        public final Builder allowAudioInput(Boolean allowAudioInput) {
            this.allowAudioInput = allowAudioInput;
            return this;
        }

        public final Boolean getAllowDTMFInput() {
            return allowDTMFInput;
        }

        public final void setAllowDTMFInput(Boolean allowDTMFInput) {
            this.allowDTMFInput = allowDTMFInput;
        }

        @Override
        public final Builder allowDTMFInput(Boolean allowDTMFInput) {
            this.allowDTMFInput = allowDTMFInput;
            return this;
        }

        @Override
        public AllowedInputTypes build() {
            return new AllowedInputTypes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
