/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the user messages in the turn in the input.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserTurnInputSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<UserTurnInputSpecification.Builder, UserTurnInputSpecification> {
    private static final SdkField<UtteranceInputSpecification> UTTERANCE_INPUT_FIELD = SdkField
            .<UtteranceInputSpecification> builder(MarshallingType.SDK_POJO).memberName("utteranceInput")
            .getter(getter(UserTurnInputSpecification::utteranceInput)).setter(setter(Builder::utteranceInput))
            .constructor(UtteranceInputSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("utteranceInput").build()).build();

    private static final SdkField<Map<String, String>> REQUEST_ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("requestAttributes")
            .getter(getter(UserTurnInputSpecification::requestAttributes))
            .setter(setter(Builder::requestAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<InputSessionStateSpecification> SESSION_STATE_FIELD = SdkField
            .<InputSessionStateSpecification> builder(MarshallingType.SDK_POJO).memberName("sessionState")
            .getter(getter(UserTurnInputSpecification::sessionState)).setter(setter(Builder::sessionState))
            .constructor(InputSessionStateSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UTTERANCE_INPUT_FIELD,
            REQUEST_ATTRIBUTES_FIELD, SESSION_STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final UtteranceInputSpecification utteranceInput;

    private final Map<String, String> requestAttributes;

    private final InputSessionStateSpecification sessionState;

    private UserTurnInputSpecification(BuilderImpl builder) {
        this.utteranceInput = builder.utteranceInput;
        this.requestAttributes = builder.requestAttributes;
        this.sessionState = builder.sessionState;
    }

    /**
     * <p>
     * The utterance input in the user turn.
     * </p>
     * 
     * @return The utterance input in the user turn.
     */
    public final UtteranceInputSpecification utteranceInput() {
        return utteranceInput;
    }

    /**
     * For responses, this returns true if the service returned a value for the RequestAttributes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRequestAttributes() {
        return requestAttributes != null && !(requestAttributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Request attributes of the user turn.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRequestAttributes} method.
     * </p>
     * 
     * @return Request attributes of the user turn.
     */
    public final Map<String, String> requestAttributes() {
        return requestAttributes;
    }

    /**
     * <p>
     * Contains information about the session state in the input.
     * </p>
     * 
     * @return Contains information about the session state in the input.
     */
    public final InputSessionStateSpecification sessionState() {
        return sessionState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(utteranceInput());
        hashCode = 31 * hashCode + Objects.hashCode(hasRequestAttributes() ? requestAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sessionState());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserTurnInputSpecification)) {
            return false;
        }
        UserTurnInputSpecification other = (UserTurnInputSpecification) obj;
        return Objects.equals(utteranceInput(), other.utteranceInput()) && hasRequestAttributes() == other.hasRequestAttributes()
                && Objects.equals(requestAttributes(), other.requestAttributes())
                && Objects.equals(sessionState(), other.sessionState());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserTurnInputSpecification").add("UtteranceInput", utteranceInput())
                .add("RequestAttributes", hasRequestAttributes() ? requestAttributes() : null)
                .add("SessionState", sessionState()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "utteranceInput":
            return Optional.ofNullable(clazz.cast(utteranceInput()));
        case "requestAttributes":
            return Optional.ofNullable(clazz.cast(requestAttributes()));
        case "sessionState":
            return Optional.ofNullable(clazz.cast(sessionState()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserTurnInputSpecification, T> g) {
        return obj -> g.apply((UserTurnInputSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserTurnInputSpecification> {
        /**
         * <p>
         * The utterance input in the user turn.
         * </p>
         * 
         * @param utteranceInput
         *        The utterance input in the user turn.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder utteranceInput(UtteranceInputSpecification utteranceInput);

        /**
         * <p>
         * The utterance input in the user turn.
         * </p>
         * This is a convenience method that creates an instance of the {@link UtteranceInputSpecification.Builder}
         * avoiding the need to create one manually via {@link UtteranceInputSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UtteranceInputSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #utteranceInput(UtteranceInputSpecification)}.
         * 
         * @param utteranceInput
         *        a consumer that will call methods on {@link UtteranceInputSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #utteranceInput(UtteranceInputSpecification)
         */
        default Builder utteranceInput(Consumer<UtteranceInputSpecification.Builder> utteranceInput) {
            return utteranceInput(UtteranceInputSpecification.builder().applyMutation(utteranceInput).build());
        }

        /**
         * <p>
         * Request attributes of the user turn.
         * </p>
         * 
         * @param requestAttributes
         *        Request attributes of the user turn.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestAttributes(Map<String, String> requestAttributes);

        /**
         * <p>
         * Contains information about the session state in the input.
         * </p>
         * 
         * @param sessionState
         *        Contains information about the session state in the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionState(InputSessionStateSpecification sessionState);

        /**
         * <p>
         * Contains information about the session state in the input.
         * </p>
         * This is a convenience method that creates an instance of the {@link InputSessionStateSpecification.Builder}
         * avoiding the need to create one manually via {@link InputSessionStateSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InputSessionStateSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #sessionState(InputSessionStateSpecification)}.
         * 
         * @param sessionState
         *        a consumer that will call methods on {@link InputSessionStateSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sessionState(InputSessionStateSpecification)
         */
        default Builder sessionState(Consumer<InputSessionStateSpecification.Builder> sessionState) {
            return sessionState(InputSessionStateSpecification.builder().applyMutation(sessionState).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private UtteranceInputSpecification utteranceInput;

        private Map<String, String> requestAttributes = DefaultSdkAutoConstructMap.getInstance();

        private InputSessionStateSpecification sessionState;

        private BuilderImpl() {
        }

        private BuilderImpl(UserTurnInputSpecification model) {
            utteranceInput(model.utteranceInput);
            requestAttributes(model.requestAttributes);
            sessionState(model.sessionState);
        }

        public final UtteranceInputSpecification.Builder getUtteranceInput() {
            return utteranceInput != null ? utteranceInput.toBuilder() : null;
        }

        public final void setUtteranceInput(UtteranceInputSpecification.BuilderImpl utteranceInput) {
            this.utteranceInput = utteranceInput != null ? utteranceInput.build() : null;
        }

        @Override
        public final Builder utteranceInput(UtteranceInputSpecification utteranceInput) {
            this.utteranceInput = utteranceInput;
            return this;
        }

        public final Map<String, String> getRequestAttributes() {
            if (requestAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return requestAttributes;
        }

        public final void setRequestAttributes(Map<String, String> requestAttributes) {
            this.requestAttributes = StringMapCopier.copy(requestAttributes);
        }

        @Override
        public final Builder requestAttributes(Map<String, String> requestAttributes) {
            this.requestAttributes = StringMapCopier.copy(requestAttributes);
            return this;
        }

        public final InputSessionStateSpecification.Builder getSessionState() {
            return sessionState != null ? sessionState.toBuilder() : null;
        }

        public final void setSessionState(InputSessionStateSpecification.BuilderImpl sessionState) {
            this.sessionState = sessionState != null ? sessionState.build() : null;
        }

        @Override
        public final Builder sessionState(InputSessionStateSpecification sessionState) {
            this.sessionState = sessionState;
            return this;
        }

        @Override
        public UserTurnInputSpecification build() {
            return new UserTurnInputSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
