/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the bot used for the test execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestExecutionTarget implements SdkPojo, Serializable,
        ToCopyableBuilder<TestExecutionTarget.Builder, TestExecutionTarget> {
    private static final SdkField<BotAliasTestExecutionTarget> BOT_ALIAS_TARGET_FIELD = SdkField
            .<BotAliasTestExecutionTarget> builder(MarshallingType.SDK_POJO).memberName("botAliasTarget")
            .getter(getter(TestExecutionTarget::botAliasTarget)).setter(setter(Builder::botAliasTarget))
            .constructor(BotAliasTestExecutionTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botAliasTarget").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ALIAS_TARGET_FIELD));

    private static final long serialVersionUID = 1L;

    private final BotAliasTestExecutionTarget botAliasTarget;

    private TestExecutionTarget(BuilderImpl builder) {
        this.botAliasTarget = builder.botAliasTarget;
    }

    /**
     * <p>
     * Contains information about the bot alias used for the test execution.
     * </p>
     * 
     * @return Contains information about the bot alias used for the test execution.
     */
    public final BotAliasTestExecutionTarget botAliasTarget() {
        return botAliasTarget;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(botAliasTarget());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestExecutionTarget)) {
            return false;
        }
        TestExecutionTarget other = (TestExecutionTarget) obj;
        return Objects.equals(botAliasTarget(), other.botAliasTarget());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestExecutionTarget").add("BotAliasTarget", botAliasTarget()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botAliasTarget":
            return Optional.ofNullable(clazz.cast(botAliasTarget()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestExecutionTarget, T> g) {
        return obj -> g.apply((TestExecutionTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TestExecutionTarget> {
        /**
         * <p>
         * Contains information about the bot alias used for the test execution.
         * </p>
         * 
         * @param botAliasTarget
         *        Contains information about the bot alias used for the test execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botAliasTarget(BotAliasTestExecutionTarget botAliasTarget);

        /**
         * <p>
         * Contains information about the bot alias used for the test execution.
         * </p>
         * This is a convenience method that creates an instance of the {@link BotAliasTestExecutionTarget.Builder}
         * avoiding the need to create one manually via {@link BotAliasTestExecutionTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BotAliasTestExecutionTarget.Builder#build()} is called
         * immediately and its result is passed to {@link #botAliasTarget(BotAliasTestExecutionTarget)}.
         * 
         * @param botAliasTarget
         *        a consumer that will call methods on {@link BotAliasTestExecutionTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #botAliasTarget(BotAliasTestExecutionTarget)
         */
        default Builder botAliasTarget(Consumer<BotAliasTestExecutionTarget.Builder> botAliasTarget) {
            return botAliasTarget(BotAliasTestExecutionTarget.builder().applyMutation(botAliasTarget).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private BotAliasTestExecutionTarget botAliasTarget;

        private BuilderImpl() {
        }

        private BuilderImpl(TestExecutionTarget model) {
            botAliasTarget(model.botAliasTarget);
        }

        public final BotAliasTestExecutionTarget.Builder getBotAliasTarget() {
            return botAliasTarget != null ? botAliasTarget.toBuilder() : null;
        }

        public final void setBotAliasTarget(BotAliasTestExecutionTarget.BuilderImpl botAliasTarget) {
            this.botAliasTarget = botAliasTarget != null ? botAliasTarget.build() : null;
        }

        @Override
        public final Builder botAliasTarget(BotAliasTestExecutionTarget botAliasTarget) {
            this.botAliasTarget = botAliasTarget;
            return this;
        }

        @Override
        public TestExecutionTarget build() {
            return new TestExecutionTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
