/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The object representing the Amazon S3 bucket containing the transcript, as well as the associated metadata.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3BucketTranscriptSource implements SdkPojo, Serializable,
        ToCopyableBuilder<S3BucketTranscriptSource.Builder, S3BucketTranscriptSource> {
    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3BucketName").getter(getter(S3BucketTranscriptSource::s3BucketName))
            .setter(setter(Builder::s3BucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3BucketName").build()).build();

    private static final SdkField<PathFormat> PATH_FORMAT_FIELD = SdkField.<PathFormat> builder(MarshallingType.SDK_POJO)
            .memberName("pathFormat").getter(getter(S3BucketTranscriptSource::pathFormat)).setter(setter(Builder::pathFormat))
            .constructor(PathFormat::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pathFormat").build()).build();

    private static final SdkField<String> TRANSCRIPT_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("transcriptFormat").getter(getter(S3BucketTranscriptSource::transcriptFormatAsString))
            .setter(setter(Builder::transcriptFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transcriptFormat").build()).build();

    private static final SdkField<TranscriptFilter> TRANSCRIPT_FILTER_FIELD = SdkField
            .<TranscriptFilter> builder(MarshallingType.SDK_POJO).memberName("transcriptFilter")
            .getter(getter(S3BucketTranscriptSource::transcriptFilter)).setter(setter(Builder::transcriptFilter))
            .constructor(TranscriptFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transcriptFilter").build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyArn").getter(getter(S3BucketTranscriptSource::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_NAME_FIELD,
            PATH_FORMAT_FIELD, TRANSCRIPT_FORMAT_FIELD, TRANSCRIPT_FILTER_FIELD, KMS_KEY_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String s3BucketName;

    private final PathFormat pathFormat;

    private final String transcriptFormat;

    private final TranscriptFilter transcriptFilter;

    private final String kmsKeyArn;

    private S3BucketTranscriptSource(BuilderImpl builder) {
        this.s3BucketName = builder.s3BucketName;
        this.pathFormat = builder.pathFormat;
        this.transcriptFormat = builder.transcriptFormat;
        this.transcriptFilter = builder.transcriptFilter;
        this.kmsKeyArn = builder.kmsKeyArn;
    }

    /**
     * <p>
     * The name of the bucket containing the transcript and the associated metadata.
     * </p>
     * 
     * @return The name of the bucket containing the transcript and the associated metadata.
     */
    public final String s3BucketName() {
        return s3BucketName;
    }

    /**
     * <p>
     * The object that contains a path format that will be applied when Amazon Lex reads the transcript file in the
     * bucket you provide. Specify this object if you only want Lex to read a subset of files in your Amazon S3 bucket.
     * </p>
     * 
     * @return The object that contains a path format that will be applied when Amazon Lex reads the transcript file in
     *         the bucket you provide. Specify this object if you only want Lex to read a subset of files in your Amazon
     *         S3 bucket.
     */
    public final PathFormat pathFormat() {
        return pathFormat;
    }

    /**
     * <p>
     * The format of the transcript content. Currently, Genie only supports the Amazon Lex transcript format.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #transcriptFormat}
     * will return {@link TranscriptFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #transcriptFormatAsString}.
     * </p>
     * 
     * @return The format of the transcript content. Currently, Genie only supports the Amazon Lex transcript format.
     * @see TranscriptFormat
     */
    public final TranscriptFormat transcriptFormat() {
        return TranscriptFormat.fromValue(transcriptFormat);
    }

    /**
     * <p>
     * The format of the transcript content. Currently, Genie only supports the Amazon Lex transcript format.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #transcriptFormat}
     * will return {@link TranscriptFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #transcriptFormatAsString}.
     * </p>
     * 
     * @return The format of the transcript content. Currently, Genie only supports the Amazon Lex transcript format.
     * @see TranscriptFormat
     */
    public final String transcriptFormatAsString() {
        return transcriptFormat;
    }

    /**
     * <p>
     * The object that contains the filter which will be applied when Amazon Lex reads through the Amazon S3 bucket.
     * Specify this object if you want Amazon Lex to read only a subset of the Amazon S3 bucket based on the filter you
     * provide.
     * </p>
     * 
     * @return The object that contains the filter which will be applied when Amazon Lex reads through the Amazon S3
     *         bucket. Specify this object if you want Amazon Lex to read only a subset of the Amazon S3 bucket based on
     *         the filter you provide.
     */
    public final TranscriptFilter transcriptFilter() {
        return transcriptFilter;
    }

    /**
     * <p>
     * The ARN of the KMS key that customer use to encrypt their Amazon S3 bucket. Only use this field if your bucket is
     * encrypted using a customer managed KMS key.
     * </p>
     * 
     * @return The ARN of the KMS key that customer use to encrypt their Amazon S3 bucket. Only use this field if your
     *         bucket is encrypted using a customer managed KMS key.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(pathFormat());
        hashCode = 31 * hashCode + Objects.hashCode(transcriptFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(transcriptFilter());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3BucketTranscriptSource)) {
            return false;
        }
        S3BucketTranscriptSource other = (S3BucketTranscriptSource) obj;
        return Objects.equals(s3BucketName(), other.s3BucketName()) && Objects.equals(pathFormat(), other.pathFormat())
                && Objects.equals(transcriptFormatAsString(), other.transcriptFormatAsString())
                && Objects.equals(transcriptFilter(), other.transcriptFilter()) && Objects.equals(kmsKeyArn(), other.kmsKeyArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3BucketTranscriptSource").add("S3BucketName", s3BucketName()).add("PathFormat", pathFormat())
                .add("TranscriptFormat", transcriptFormatAsString()).add("TranscriptFilter", transcriptFilter())
                .add("KmsKeyArn", kmsKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3BucketName":
            return Optional.ofNullable(clazz.cast(s3BucketName()));
        case "pathFormat":
            return Optional.ofNullable(clazz.cast(pathFormat()));
        case "transcriptFormat":
            return Optional.ofNullable(clazz.cast(transcriptFormatAsString()));
        case "transcriptFilter":
            return Optional.ofNullable(clazz.cast(transcriptFilter()));
        case "kmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3BucketTranscriptSource, T> g) {
        return obj -> g.apply((S3BucketTranscriptSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3BucketTranscriptSource> {
        /**
         * <p>
         * The name of the bucket containing the transcript and the associated metadata.
         * </p>
         * 
         * @param s3BucketName
         *        The name of the bucket containing the transcript and the associated metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketName(String s3BucketName);

        /**
         * <p>
         * The object that contains a path format that will be applied when Amazon Lex reads the transcript file in the
         * bucket you provide. Specify this object if you only want Lex to read a subset of files in your Amazon S3
         * bucket.
         * </p>
         * 
         * @param pathFormat
         *        The object that contains a path format that will be applied when Amazon Lex reads the transcript file
         *        in the bucket you provide. Specify this object if you only want Lex to read a subset of files in your
         *        Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pathFormat(PathFormat pathFormat);

        /**
         * <p>
         * The object that contains a path format that will be applied when Amazon Lex reads the transcript file in the
         * bucket you provide. Specify this object if you only want Lex to read a subset of files in your Amazon S3
         * bucket.
         * </p>
         * This is a convenience method that creates an instance of the {@link PathFormat.Builder} avoiding the need to
         * create one manually via {@link PathFormat#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PathFormat.Builder#build()} is called immediately and its result
         * is passed to {@link #pathFormat(PathFormat)}.
         * 
         * @param pathFormat
         *        a consumer that will call methods on {@link PathFormat.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pathFormat(PathFormat)
         */
        default Builder pathFormat(Consumer<PathFormat.Builder> pathFormat) {
            return pathFormat(PathFormat.builder().applyMutation(pathFormat).build());
        }

        /**
         * <p>
         * The format of the transcript content. Currently, Genie only supports the Amazon Lex transcript format.
         * </p>
         * 
         * @param transcriptFormat
         *        The format of the transcript content. Currently, Genie only supports the Amazon Lex transcript format.
         * @see TranscriptFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TranscriptFormat
         */
        Builder transcriptFormat(String transcriptFormat);

        /**
         * <p>
         * The format of the transcript content. Currently, Genie only supports the Amazon Lex transcript format.
         * </p>
         * 
         * @param transcriptFormat
         *        The format of the transcript content. Currently, Genie only supports the Amazon Lex transcript format.
         * @see TranscriptFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TranscriptFormat
         */
        Builder transcriptFormat(TranscriptFormat transcriptFormat);

        /**
         * <p>
         * The object that contains the filter which will be applied when Amazon Lex reads through the Amazon S3 bucket.
         * Specify this object if you want Amazon Lex to read only a subset of the Amazon S3 bucket based on the filter
         * you provide.
         * </p>
         * 
         * @param transcriptFilter
         *        The object that contains the filter which will be applied when Amazon Lex reads through the Amazon S3
         *        bucket. Specify this object if you want Amazon Lex to read only a subset of the Amazon S3 bucket based
         *        on the filter you provide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transcriptFilter(TranscriptFilter transcriptFilter);

        /**
         * <p>
         * The object that contains the filter which will be applied when Amazon Lex reads through the Amazon S3 bucket.
         * Specify this object if you want Amazon Lex to read only a subset of the Amazon S3 bucket based on the filter
         * you provide.
         * </p>
         * This is a convenience method that creates an instance of the {@link TranscriptFilter.Builder} avoiding the
         * need to create one manually via {@link TranscriptFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TranscriptFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #transcriptFilter(TranscriptFilter)}.
         * 
         * @param transcriptFilter
         *        a consumer that will call methods on {@link TranscriptFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transcriptFilter(TranscriptFilter)
         */
        default Builder transcriptFilter(Consumer<TranscriptFilter.Builder> transcriptFilter) {
            return transcriptFilter(TranscriptFilter.builder().applyMutation(transcriptFilter).build());
        }

        /**
         * <p>
         * The ARN of the KMS key that customer use to encrypt their Amazon S3 bucket. Only use this field if your
         * bucket is encrypted using a customer managed KMS key.
         * </p>
         * 
         * @param kmsKeyArn
         *        The ARN of the KMS key that customer use to encrypt their Amazon S3 bucket. Only use this field if
         *        your bucket is encrypted using a customer managed KMS key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);
    }

    static final class BuilderImpl implements Builder {
        private String s3BucketName;

        private PathFormat pathFormat;

        private String transcriptFormat;

        private TranscriptFilter transcriptFilter;

        private String kmsKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(S3BucketTranscriptSource model) {
            s3BucketName(model.s3BucketName);
            pathFormat(model.pathFormat);
            transcriptFormat(model.transcriptFormat);
            transcriptFilter(model.transcriptFilter);
            kmsKeyArn(model.kmsKeyArn);
        }

        public final String getS3BucketName() {
            return s3BucketName;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final PathFormat.Builder getPathFormat() {
            return pathFormat != null ? pathFormat.toBuilder() : null;
        }

        public final void setPathFormat(PathFormat.BuilderImpl pathFormat) {
            this.pathFormat = pathFormat != null ? pathFormat.build() : null;
        }

        @Override
        public final Builder pathFormat(PathFormat pathFormat) {
            this.pathFormat = pathFormat;
            return this;
        }

        public final String getTranscriptFormat() {
            return transcriptFormat;
        }

        public final void setTranscriptFormat(String transcriptFormat) {
            this.transcriptFormat = transcriptFormat;
        }

        @Override
        public final Builder transcriptFormat(String transcriptFormat) {
            this.transcriptFormat = transcriptFormat;
            return this;
        }

        @Override
        public final Builder transcriptFormat(TranscriptFormat transcriptFormat) {
            this.transcriptFormat(transcriptFormat == null ? null : transcriptFormat.toString());
            return this;
        }

        public final TranscriptFilter.Builder getTranscriptFilter() {
            return transcriptFilter != null ? transcriptFilter.toBuilder() : null;
        }

        public final void setTranscriptFilter(TranscriptFilter.BuilderImpl transcriptFilter) {
            this.transcriptFilter = transcriptFilter != null ? transcriptFilter.build() : null;
        }

        @Override
        public final Builder transcriptFilter(TranscriptFilter transcriptFilter) {
            this.transcriptFilter = transcriptFilter;
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        @Override
        public S3BucketTranscriptSource build() {
            return new S3BucketTranscriptSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
