/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTestExecutionResultItemsRequest extends LexModelsV2Request implements
        ToCopyableBuilder<ListTestExecutionResultItemsRequest.Builder, ListTestExecutionResultItemsRequest> {
    private static final SdkField<String> TEST_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testExecutionId").getter(getter(ListTestExecutionResultItemsRequest::testExecutionId))
            .setter(setter(Builder::testExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("testExecutionId").build()).build();

    private static final SdkField<TestExecutionResultFilterBy> RESULT_FILTER_BY_FIELD = SdkField
            .<TestExecutionResultFilterBy> builder(MarshallingType.SDK_POJO).memberName("resultFilterBy")
            .getter(getter(ListTestExecutionResultItemsRequest::resultFilterBy)).setter(setter(Builder::resultFilterBy))
            .constructor(TestExecutionResultFilterBy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resultFilterBy").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListTestExecutionResultItemsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListTestExecutionResultItemsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_EXECUTION_ID_FIELD,
            RESULT_FILTER_BY_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String testExecutionId;

    private final TestExecutionResultFilterBy resultFilterBy;

    private final Integer maxResults;

    private final String nextToken;

    private ListTestExecutionResultItemsRequest(BuilderImpl builder) {
        super(builder);
        this.testExecutionId = builder.testExecutionId;
        this.resultFilterBy = builder.resultFilterBy;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The unique identifier of the test execution to list the result items.
     * </p>
     * 
     * @return The unique identifier of the test execution to list the result items.
     */
    public final String testExecutionId() {
        return testExecutionId;
    }

    /**
     * <p>
     * The filter for the list of results from the test set execution.
     * </p>
     * 
     * @return The filter for the list of results from the test set execution.
     */
    public final TestExecutionResultFilterBy resultFilterBy() {
        return resultFilterBy;
    }

    /**
     * <p>
     * The maximum number of test execution result items to return in each page. If there are fewer results than the max
     * page size, only the actual number of results are returned.
     * </p>
     * 
     * @return The maximum number of test execution result items to return in each page. If there are fewer results than
     *         the max page size, only the actual number of results are returned.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If the response from the <code>ListTestExecutionResultItems</code> operation contains more results than specified
     * in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the
     * <code>nextToken</code> parameter to return the next page of results.
     * </p>
     * 
     * @return If the response from the <code>ListTestExecutionResultItems</code> operation contains more results than
     *         specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token
     *         in the <code>nextToken</code> parameter to return the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(testExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(resultFilterBy());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTestExecutionResultItemsRequest)) {
            return false;
        }
        ListTestExecutionResultItemsRequest other = (ListTestExecutionResultItemsRequest) obj;
        return Objects.equals(testExecutionId(), other.testExecutionId())
                && Objects.equals(resultFilterBy(), other.resultFilterBy()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTestExecutionResultItemsRequest").add("TestExecutionId", testExecutionId())
                .add("ResultFilterBy", resultFilterBy()).add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "testExecutionId":
            return Optional.ofNullable(clazz.cast(testExecutionId()));
        case "resultFilterBy":
            return Optional.ofNullable(clazz.cast(resultFilterBy()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTestExecutionResultItemsRequest, T> g) {
        return obj -> g.apply((ListTestExecutionResultItemsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, ListTestExecutionResultItemsRequest> {
        /**
         * <p>
         * The unique identifier of the test execution to list the result items.
         * </p>
         * 
         * @param testExecutionId
         *        The unique identifier of the test execution to list the result items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testExecutionId(String testExecutionId);

        /**
         * <p>
         * The filter for the list of results from the test set execution.
         * </p>
         * 
         * @param resultFilterBy
         *        The filter for the list of results from the test set execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultFilterBy(TestExecutionResultFilterBy resultFilterBy);

        /**
         * <p>
         * The filter for the list of results from the test set execution.
         * </p>
         * This is a convenience method that creates an instance of the {@link TestExecutionResultFilterBy.Builder}
         * avoiding the need to create one manually via {@link TestExecutionResultFilterBy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TestExecutionResultFilterBy.Builder#build()} is called
         * immediately and its result is passed to {@link #resultFilterBy(TestExecutionResultFilterBy)}.
         * 
         * @param resultFilterBy
         *        a consumer that will call methods on {@link TestExecutionResultFilterBy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resultFilterBy(TestExecutionResultFilterBy)
         */
        default Builder resultFilterBy(Consumer<TestExecutionResultFilterBy.Builder> resultFilterBy) {
            return resultFilterBy(TestExecutionResultFilterBy.builder().applyMutation(resultFilterBy).build());
        }

        /**
         * <p>
         * The maximum number of test execution result items to return in each page. If there are fewer results than the
         * max page size, only the actual number of results are returned.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of test execution result items to return in each page. If there are fewer results
         *        than the max page size, only the actual number of results are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If the response from the <code>ListTestExecutionResultItems</code> operation contains more results than
         * specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in
         * the <code>nextToken</code> parameter to return the next page of results.
         * </p>
         * 
         * @param nextToken
         *        If the response from the <code>ListTestExecutionResultItems</code> operation contains more results
         *        than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that
         *        token in the <code>nextToken</code> parameter to return the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelsV2Request.BuilderImpl implements Builder {
        private String testExecutionId;

        private TestExecutionResultFilterBy resultFilterBy;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTestExecutionResultItemsRequest model) {
            super(model);
            testExecutionId(model.testExecutionId);
            resultFilterBy(model.resultFilterBy);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getTestExecutionId() {
            return testExecutionId;
        }

        public final void setTestExecutionId(String testExecutionId) {
            this.testExecutionId = testExecutionId;
        }

        @Override
        public final Builder testExecutionId(String testExecutionId) {
            this.testExecutionId = testExecutionId;
            return this;
        }

        public final TestExecutionResultFilterBy.Builder getResultFilterBy() {
            return resultFilterBy != null ? resultFilterBy.toBuilder() : null;
        }

        public final void setResultFilterBy(TestExecutionResultFilterBy.BuilderImpl resultFilterBy) {
            this.resultFilterBy = resultFilterBy != null ? resultFilterBy.build() : null;
        }

        @Override
        public final Builder resultFilterBy(TestExecutionResultFilterBy resultFilterBy) {
            this.resultFilterBy = resultFilterBy;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTestExecutionResultItemsRequest build() {
            return new ListTestExecutionResultItemsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
