/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBuiltInIntentsResponse extends LexModelsV2Response implements
        ToCopyableBuilder<ListBuiltInIntentsResponse.Builder, ListBuiltInIntentsResponse> {
    private static final SdkField<List<BuiltInIntentSummary>> BUILT_IN_INTENT_SUMMARIES_FIELD = SdkField
            .<List<BuiltInIntentSummary>> builder(MarshallingType.LIST)
            .memberName("builtInIntentSummaries")
            .getter(getter(ListBuiltInIntentsResponse::builtInIntentSummaries))
            .setter(setter(Builder::builtInIntentSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("builtInIntentSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BuiltInIntentSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(BuiltInIntentSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListBuiltInIntentsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(ListBuiltInIntentsResponse::localeId)).setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            BUILT_IN_INTENT_SUMMARIES_FIELD, NEXT_TOKEN_FIELD, LOCALE_ID_FIELD));

    private final List<BuiltInIntentSummary> builtInIntentSummaries;

    private final String nextToken;

    private final String localeId;

    private ListBuiltInIntentsResponse(BuilderImpl builder) {
        super(builder);
        this.builtInIntentSummaries = builder.builtInIntentSummaries;
        this.nextToken = builder.nextToken;
        this.localeId = builder.localeId;
    }

    /**
     * For responses, this returns true if the service returned a value for the BuiltInIntentSummaries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasBuiltInIntentSummaries() {
        return builtInIntentSummaries != null && !(builtInIntentSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Summary information for the built-in intents that meet the filter criteria specified in the request. The length
     * of the list is specified in the <code>maxResults</code> parameter of the request. If there are more intents
     * available, the <code>nextToken</code> field contains a token to get the next page of results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBuiltInIntentSummaries} method.
     * </p>
     * 
     * @return Summary information for the built-in intents that meet the filter criteria specified in the request. The
     *         length of the list is specified in the <code>maxResults</code> parameter of the request. If there are
     *         more intents available, the <code>nextToken</code> field contains a token to get the next page of
     *         results.
     */
    public final List<BuiltInIntentSummary> builtInIntentSummaries() {
        return builtInIntentSummaries;
    }

    /**
     * <p>
     * A token that indicates whether there are more results to return in a response to the
     * <code>ListBuiltInIntents</code> operation. If the <code>nextToken</code> field is present, you send the contents
     * as the <code>nextToken</code> parameter of a <code>ListBotAliases</code> operation request to get the next page
     * of results.
     * </p>
     * 
     * @return A token that indicates whether there are more results to return in a response to the
     *         <code>ListBuiltInIntents</code> operation. If the <code>nextToken</code> field is present, you send the
     *         contents as the <code>nextToken</code> parameter of a <code>ListBotAliases</code> operation request to
     *         get the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The language and locale of the intents in the list.
     * </p>
     * 
     * @return The language and locale of the intents in the list.
     */
    public final String localeId() {
        return localeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBuiltInIntentSummaries() ? builtInIntentSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBuiltInIntentsResponse)) {
            return false;
        }
        ListBuiltInIntentsResponse other = (ListBuiltInIntentsResponse) obj;
        return hasBuiltInIntentSummaries() == other.hasBuiltInIntentSummaries()
                && Objects.equals(builtInIntentSummaries(), other.builtInIntentSummaries())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(localeId(), other.localeId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBuiltInIntentsResponse")
                .add("BuiltInIntentSummaries", hasBuiltInIntentSummaries() ? builtInIntentSummaries() : null)
                .add("NextToken", nextToken()).add("LocaleId", localeId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "builtInIntentSummaries":
            return Optional.ofNullable(clazz.cast(builtInIntentSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBuiltInIntentsResponse, T> g) {
        return obj -> g.apply((ListBuiltInIntentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Response.Builder, SdkPojo, CopyableBuilder<Builder, ListBuiltInIntentsResponse> {
        /**
         * <p>
         * Summary information for the built-in intents that meet the filter criteria specified in the request. The
         * length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more
         * intents available, the <code>nextToken</code> field contains a token to get the next page of results.
         * </p>
         * 
         * @param builtInIntentSummaries
         *        Summary information for the built-in intents that meet the filter criteria specified in the request.
         *        The length of the list is specified in the <code>maxResults</code> parameter of the request. If there
         *        are more intents available, the <code>nextToken</code> field contains a token to get the next page of
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder builtInIntentSummaries(Collection<BuiltInIntentSummary> builtInIntentSummaries);

        /**
         * <p>
         * Summary information for the built-in intents that meet the filter criteria specified in the request. The
         * length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more
         * intents available, the <code>nextToken</code> field contains a token to get the next page of results.
         * </p>
         * 
         * @param builtInIntentSummaries
         *        Summary information for the built-in intents that meet the filter criteria specified in the request.
         *        The length of the list is specified in the <code>maxResults</code> parameter of the request. If there
         *        are more intents available, the <code>nextToken</code> field contains a token to get the next page of
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder builtInIntentSummaries(BuiltInIntentSummary... builtInIntentSummaries);

        /**
         * <p>
         * Summary information for the built-in intents that meet the filter criteria specified in the request. The
         * length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more
         * intents available, the <code>nextToken</code> field contains a token to get the next page of results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.BuiltInIntentSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.BuiltInIntentSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.BuiltInIntentSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #builtInIntentSummaries(List<BuiltInIntentSummary>)}.
         * 
         * @param builtInIntentSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.BuiltInIntentSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #builtInIntentSummaries(java.util.Collection<BuiltInIntentSummary>)
         */
        Builder builtInIntentSummaries(Consumer<BuiltInIntentSummary.Builder>... builtInIntentSummaries);

        /**
         * <p>
         * A token that indicates whether there are more results to return in a response to the
         * <code>ListBuiltInIntents</code> operation. If the <code>nextToken</code> field is present, you send the
         * contents as the <code>nextToken</code> parameter of a <code>ListBotAliases</code> operation request to get
         * the next page of results.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates whether there are more results to return in a response to the
         *        <code>ListBuiltInIntents</code> operation. If the <code>nextToken</code> field is present, you send
         *        the contents as the <code>nextToken</code> parameter of a <code>ListBotAliases</code> operation
         *        request to get the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The language and locale of the intents in the list.
         * </p>
         * 
         * @param localeId
         *        The language and locale of the intents in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private List<BuiltInIntentSummary> builtInIntentSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private String localeId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBuiltInIntentsResponse model) {
            super(model);
            builtInIntentSummaries(model.builtInIntentSummaries);
            nextToken(model.nextToken);
            localeId(model.localeId);
        }

        public final List<BuiltInIntentSummary.Builder> getBuiltInIntentSummaries() {
            List<BuiltInIntentSummary.Builder> result = BuiltInIntentSummaryListCopier.copyToBuilder(this.builtInIntentSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBuiltInIntentSummaries(Collection<BuiltInIntentSummary.BuilderImpl> builtInIntentSummaries) {
            this.builtInIntentSummaries = BuiltInIntentSummaryListCopier.copyFromBuilder(builtInIntentSummaries);
        }

        @Override
        public final Builder builtInIntentSummaries(Collection<BuiltInIntentSummary> builtInIntentSummaries) {
            this.builtInIntentSummaries = BuiltInIntentSummaryListCopier.copy(builtInIntentSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder builtInIntentSummaries(BuiltInIntentSummary... builtInIntentSummaries) {
            builtInIntentSummaries(Arrays.asList(builtInIntentSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder builtInIntentSummaries(Consumer<BuiltInIntentSummary.Builder>... builtInIntentSummaries) {
            builtInIntentSummaries(Stream.of(builtInIntentSummaries)
                    .map(c -> BuiltInIntentSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getLocaleId() {
            return localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        @Override
        public ListBuiltInIntentsResponse build() {
            return new ListBuiltInIntentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
