/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about intent-level slot resolution in a test result.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IntentLevelSlotResolutionTestResultItem implements SdkPojo, Serializable,
        ToCopyableBuilder<IntentLevelSlotResolutionTestResultItem.Builder, IntentLevelSlotResolutionTestResultItem> {
    private static final SdkField<String> INTENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("intentName").getter(getter(IntentLevelSlotResolutionTestResultItem::intentName))
            .setter(setter(Builder::intentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentName").build()).build();

    private static final SdkField<Boolean> MULTI_TURN_CONVERSATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("multiTurnConversation").getter(getter(IntentLevelSlotResolutionTestResultItem::multiTurnConversation))
            .setter(setter(Builder::multiTurnConversation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiTurnConversation").build())
            .build();

    private static final SdkField<List<SlotResolutionTestResultItem>> SLOT_RESOLUTION_RESULTS_FIELD = SdkField
            .<List<SlotResolutionTestResultItem>> builder(MarshallingType.LIST)
            .memberName("slotResolutionResults")
            .getter(getter(IntentLevelSlotResolutionTestResultItem::slotResolutionResults))
            .setter(setter(Builder::slotResolutionResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotResolutionResults").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SlotResolutionTestResultItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(SlotResolutionTestResultItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTENT_NAME_FIELD,
            MULTI_TURN_CONVERSATION_FIELD, SLOT_RESOLUTION_RESULTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String intentName;

    private final Boolean multiTurnConversation;

    private final List<SlotResolutionTestResultItem> slotResolutionResults;

    private IntentLevelSlotResolutionTestResultItem(BuilderImpl builder) {
        this.intentName = builder.intentName;
        this.multiTurnConversation = builder.multiTurnConversation;
        this.slotResolutionResults = builder.slotResolutionResults;
    }

    /**
     * <p>
     * The name of the intent that was recognized.
     * </p>
     * 
     * @return The name of the intent that was recognized.
     */
    public final String intentName() {
        return intentName;
    }

    /**
     * <p>
     * Indicates whether the conversation involves multiple turns or not.
     * </p>
     * 
     * @return Indicates whether the conversation involves multiple turns or not.
     */
    public final Boolean multiTurnConversation() {
        return multiTurnConversation;
    }

    /**
     * For responses, this returns true if the service returned a value for the SlotResolutionResults property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSlotResolutionResults() {
        return slotResolutionResults != null && !(slotResolutionResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The results for the slot resolution in the test execution result.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSlotResolutionResults} method.
     * </p>
     * 
     * @return The results for the slot resolution in the test execution result.
     */
    public final List<SlotResolutionTestResultItem> slotResolutionResults() {
        return slotResolutionResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(intentName());
        hashCode = 31 * hashCode + Objects.hashCode(multiTurnConversation());
        hashCode = 31 * hashCode + Objects.hashCode(hasSlotResolutionResults() ? slotResolutionResults() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntentLevelSlotResolutionTestResultItem)) {
            return false;
        }
        IntentLevelSlotResolutionTestResultItem other = (IntentLevelSlotResolutionTestResultItem) obj;
        return Objects.equals(intentName(), other.intentName())
                && Objects.equals(multiTurnConversation(), other.multiTurnConversation())
                && hasSlotResolutionResults() == other.hasSlotResolutionResults()
                && Objects.equals(slotResolutionResults(), other.slotResolutionResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IntentLevelSlotResolutionTestResultItem").add("IntentName", intentName())
                .add("MultiTurnConversation", multiTurnConversation())
                .add("SlotResolutionResults", hasSlotResolutionResults() ? slotResolutionResults() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "intentName":
            return Optional.ofNullable(clazz.cast(intentName()));
        case "multiTurnConversation":
            return Optional.ofNullable(clazz.cast(multiTurnConversation()));
        case "slotResolutionResults":
            return Optional.ofNullable(clazz.cast(slotResolutionResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IntentLevelSlotResolutionTestResultItem, T> g) {
        return obj -> g.apply((IntentLevelSlotResolutionTestResultItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IntentLevelSlotResolutionTestResultItem> {
        /**
         * <p>
         * The name of the intent that was recognized.
         * </p>
         * 
         * @param intentName
         *        The name of the intent that was recognized.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentName(String intentName);

        /**
         * <p>
         * Indicates whether the conversation involves multiple turns or not.
         * </p>
         * 
         * @param multiTurnConversation
         *        Indicates whether the conversation involves multiple turns or not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiTurnConversation(Boolean multiTurnConversation);

        /**
         * <p>
         * The results for the slot resolution in the test execution result.
         * </p>
         * 
         * @param slotResolutionResults
         *        The results for the slot resolution in the test execution result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotResolutionResults(Collection<SlotResolutionTestResultItem> slotResolutionResults);

        /**
         * <p>
         * The results for the slot resolution in the test execution result.
         * </p>
         * 
         * @param slotResolutionResults
         *        The results for the slot resolution in the test execution result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotResolutionResults(SlotResolutionTestResultItem... slotResolutionResults);

        /**
         * <p>
         * The results for the slot resolution in the test execution result.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.SlotResolutionTestResultItem.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.SlotResolutionTestResultItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.SlotResolutionTestResultItem.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #slotResolutionResults(List<SlotResolutionTestResultItem>)}.
         * 
         * @param slotResolutionResults
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.SlotResolutionTestResultItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slotResolutionResults(java.util.Collection<SlotResolutionTestResultItem>)
         */
        Builder slotResolutionResults(Consumer<SlotResolutionTestResultItem.Builder>... slotResolutionResults);
    }

    static final class BuilderImpl implements Builder {
        private String intentName;

        private Boolean multiTurnConversation;

        private List<SlotResolutionTestResultItem> slotResolutionResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IntentLevelSlotResolutionTestResultItem model) {
            intentName(model.intentName);
            multiTurnConversation(model.multiTurnConversation);
            slotResolutionResults(model.slotResolutionResults);
        }

        public final String getIntentName() {
            return intentName;
        }

        public final void setIntentName(String intentName) {
            this.intentName = intentName;
        }

        @Override
        public final Builder intentName(String intentName) {
            this.intentName = intentName;
            return this;
        }

        public final Boolean getMultiTurnConversation() {
            return multiTurnConversation;
        }

        public final void setMultiTurnConversation(Boolean multiTurnConversation) {
            this.multiTurnConversation = multiTurnConversation;
        }

        @Override
        public final Builder multiTurnConversation(Boolean multiTurnConversation) {
            this.multiTurnConversation = multiTurnConversation;
            return this;
        }

        public final List<SlotResolutionTestResultItem.Builder> getSlotResolutionResults() {
            List<SlotResolutionTestResultItem.Builder> result = SlotResolutionTestResultItemsCopier
                    .copyToBuilder(this.slotResolutionResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSlotResolutionResults(Collection<SlotResolutionTestResultItem.BuilderImpl> slotResolutionResults) {
            this.slotResolutionResults = SlotResolutionTestResultItemsCopier.copyFromBuilder(slotResolutionResults);
        }

        @Override
        public final Builder slotResolutionResults(Collection<SlotResolutionTestResultItem> slotResolutionResults) {
            this.slotResolutionResults = SlotResolutionTestResultItemsCopier.copy(slotResolutionResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slotResolutionResults(SlotResolutionTestResultItem... slotResolutionResults) {
            slotResolutionResults(Arrays.asList(slotResolutionResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slotResolutionResults(Consumer<SlotResolutionTestResultItem.Builder>... slotResolutionResults) {
            slotResolutionResults(Stream.of(slotResolutionResults)
                    .map(c -> SlotResolutionTestResultItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public IntentLevelSlotResolutionTestResultItem build() {
            return new IntentLevelSlotResolutionTestResultItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
