/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The item listing the evaluation of intent level success or failure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConversationLevelIntentClassificationResultItem
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<ConversationLevelIntentClassificationResultItem.Builder, ConversationLevelIntentClassificationResultItem> {
    private static final SdkField<String> INTENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("intentName").getter(getter(ConversationLevelIntentClassificationResultItem::intentName))
            .setter(setter(Builder::intentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentName").build()).build();

    private static final SdkField<String> MATCH_RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("matchResult").getter(getter(ConversationLevelIntentClassificationResultItem::matchResultAsString))
            .setter(setter(Builder::matchResult))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matchResult").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTENT_NAME_FIELD,
            MATCH_RESULT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String intentName;

    private final String matchResult;

    private ConversationLevelIntentClassificationResultItem(BuilderImpl builder) {
        this.intentName = builder.intentName;
        this.matchResult = builder.matchResult;
    }

    /**
     * <p>
     * The intent name used in the evaluation of intent level success or failure.
     * </p>
     * 
     * @return The intent name used in the evaluation of intent level success or failure.
     */
    public final String intentName() {
        return intentName;
    }

    /**
     * <p>
     * The number of times the specific intent is used in the evaluation of intent level success or failure.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #matchResult} will
     * return {@link TestResultMatchStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #matchResultAsString}.
     * </p>
     * 
     * @return The number of times the specific intent is used in the evaluation of intent level success or failure.
     * @see TestResultMatchStatus
     */
    public final TestResultMatchStatus matchResult() {
        return TestResultMatchStatus.fromValue(matchResult);
    }

    /**
     * <p>
     * The number of times the specific intent is used in the evaluation of intent level success or failure.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #matchResult} will
     * return {@link TestResultMatchStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #matchResultAsString}.
     * </p>
     * 
     * @return The number of times the specific intent is used in the evaluation of intent level success or failure.
     * @see TestResultMatchStatus
     */
    public final String matchResultAsString() {
        return matchResult;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(intentName());
        hashCode = 31 * hashCode + Objects.hashCode(matchResultAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConversationLevelIntentClassificationResultItem)) {
            return false;
        }
        ConversationLevelIntentClassificationResultItem other = (ConversationLevelIntentClassificationResultItem) obj;
        return Objects.equals(intentName(), other.intentName())
                && Objects.equals(matchResultAsString(), other.matchResultAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConversationLevelIntentClassificationResultItem").add("IntentName", intentName())
                .add("MatchResult", matchResultAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "intentName":
            return Optional.ofNullable(clazz.cast(intentName()));
        case "matchResult":
            return Optional.ofNullable(clazz.cast(matchResultAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConversationLevelIntentClassificationResultItem, T> g) {
        return obj -> g.apply((ConversationLevelIntentClassificationResultItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConversationLevelIntentClassificationResultItem> {
        /**
         * <p>
         * The intent name used in the evaluation of intent level success or failure.
         * </p>
         * 
         * @param intentName
         *        The intent name used in the evaluation of intent level success or failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentName(String intentName);

        /**
         * <p>
         * The number of times the specific intent is used in the evaluation of intent level success or failure.
         * </p>
         * 
         * @param matchResult
         *        The number of times the specific intent is used in the evaluation of intent level success or failure.
         * @see TestResultMatchStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestResultMatchStatus
         */
        Builder matchResult(String matchResult);

        /**
         * <p>
         * The number of times the specific intent is used in the evaluation of intent level success or failure.
         * </p>
         * 
         * @param matchResult
         *        The number of times the specific intent is used in the evaluation of intent level success or failure.
         * @see TestResultMatchStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestResultMatchStatus
         */
        Builder matchResult(TestResultMatchStatus matchResult);
    }

    static final class BuilderImpl implements Builder {
        private String intentName;

        private String matchResult;

        private BuilderImpl() {
        }

        private BuilderImpl(ConversationLevelIntentClassificationResultItem model) {
            intentName(model.intentName);
            matchResult(model.matchResult);
        }

        public final String getIntentName() {
            return intentName;
        }

        public final void setIntentName(String intentName) {
            this.intentName = intentName;
        }

        @Override
        public final Builder intentName(String intentName) {
            this.intentName = intentName;
            return this;
        }

        public final String getMatchResult() {
            return matchResult;
        }

        public final void setMatchResult(String matchResult) {
            this.matchResult = matchResult;
        }

        @Override
        public final Builder matchResult(String matchResult) {
            this.matchResult = matchResult;
            return this;
        }

        @Override
        public final Builder matchResult(TestResultMatchStatus matchResult) {
            this.matchResult(matchResult == null ? null : matchResult.toString());
            return this;
        }

        @Override
        public ConversationLevelIntentClassificationResultItem build() {
            return new ConversationLevelIntentClassificationResultItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
