/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that specifies the last used intent at the time of the utterance as an attribute to return.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalyticsUtteranceAttribute implements SdkPojo, Serializable,
        ToCopyableBuilder<AnalyticsUtteranceAttribute.Builder, AnalyticsUtteranceAttribute> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AnalyticsUtteranceAttribute::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private AnalyticsUtteranceAttribute(BuilderImpl builder) {
        this.name = builder.name;
    }

    /**
     * <p>
     * An attribute to return. The only available attribute is the intent that the bot mapped the utterance to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link AnalyticsUtteranceAttributeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #nameAsString}.
     * </p>
     * 
     * @return An attribute to return. The only available attribute is the intent that the bot mapped the utterance to.
     * @see AnalyticsUtteranceAttributeName
     */
    public final AnalyticsUtteranceAttributeName name() {
        return AnalyticsUtteranceAttributeName.fromValue(name);
    }

    /**
     * <p>
     * An attribute to return. The only available attribute is the intent that the bot mapped the utterance to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link AnalyticsUtteranceAttributeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #nameAsString}.
     * </p>
     * 
     * @return An attribute to return. The only available attribute is the intent that the bot mapped the utterance to.
     * @see AnalyticsUtteranceAttributeName
     */
    public final String nameAsString() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyticsUtteranceAttribute)) {
            return false;
        }
        AnalyticsUtteranceAttribute other = (AnalyticsUtteranceAttribute) obj;
        return Objects.equals(nameAsString(), other.nameAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnalyticsUtteranceAttribute").add("Name", nameAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnalyticsUtteranceAttribute, T> g) {
        return obj -> g.apply((AnalyticsUtteranceAttribute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalyticsUtteranceAttribute> {
        /**
         * <p>
         * An attribute to return. The only available attribute is the intent that the bot mapped the utterance to.
         * </p>
         * 
         * @param name
         *        An attribute to return. The only available attribute is the intent that the bot mapped the utterance
         *        to.
         * @see AnalyticsUtteranceAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalyticsUtteranceAttributeName
         */
        Builder name(String name);

        /**
         * <p>
         * An attribute to return. The only available attribute is the intent that the bot mapped the utterance to.
         * </p>
         * 
         * @param name
         *        An attribute to return. The only available attribute is the intent that the bot mapped the utterance
         *        to.
         * @see AnalyticsUtteranceAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalyticsUtteranceAttributeName
         */
        Builder name(AnalyticsUtteranceAttributeName name);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalyticsUtteranceAttribute model) {
            name(model.name);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(AnalyticsUtteranceAttributeName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        @Override
        public AnalyticsUtteranceAttribute build() {
            return new AnalyticsUtteranceAttribute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
