/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Locale {
    DE_DE("de-DE"),
    EN_AU("en-AU"),
    EN_GB("en-GB"),
    EN_IN("en-IN"),
    EN_US("en-US"),
    ES_419("es-419"),
    ES_ES("es-ES"),
    ES_US("es-US"),
    FR_FR("fr-FR"),
    FR_CA("fr-CA"),
    IT_IT("it-IT"),
    JA_JP("ja-JP"),
    KO_KR("ko-KR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Locale> VALUE_MAP;
    private final String value;

    private Locale(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Locale fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Locale> knownValues() {
        EnumSet<Locale> knownValues = EnumSet.allOf(Locale.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Locale.class, Locale::toString);
    }
}

