/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelbuilding.model.ObfuscationSetting;
import software.amazon.awssdk.services.lexmodelbuilding.model.Prompt;
import software.amazon.awssdk.services.lexmodelbuilding.model.SlotConstraint;
import software.amazon.awssdk.services.lexmodelbuilding.model.SlotDefaultValueSpec;
import software.amazon.awssdk.services.lexmodelbuilding.model.SlotUtteranceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Slot
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Slot> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Slot.getter(Slot::name)).setter(Slot.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(Slot.getter(Slot::description)).setter(Slot.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> SLOT_CONSTRAINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("slotConstraint").getter(Slot.getter(Slot::slotConstraintAsString)).setter(Slot.setter(Builder::slotConstraint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotConstraint").build()}).build();
    private static final SdkField<String> SLOT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("slotType").getter(Slot.getter(Slot::slotType)).setter(Slot.setter(Builder::slotType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotType").build()}).build();
    private static final SdkField<String> SLOT_TYPE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("slotTypeVersion").getter(Slot.getter(Slot::slotTypeVersion)).setter(Slot.setter(Builder::slotTypeVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotTypeVersion").build()}).build();
    private static final SdkField<Prompt> VALUE_ELICITATION_PROMPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("valueElicitationPrompt").getter(Slot.getter(Slot::valueElicitationPrompt)).setter(Slot.setter(Builder::valueElicitationPrompt)).constructor(Prompt::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("valueElicitationPrompt").build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("priority").getter(Slot.getter(Slot::priority)).setter(Slot.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()}).build();
    private static final SdkField<List<String>> SAMPLE_UTTERANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sampleUtterances").getter(Slot.getter(Slot::sampleUtterances)).setter(Slot.setter(Builder::sampleUtterances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleUtterances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RESPONSE_CARD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("responseCard").getter(Slot.getter(Slot::responseCard)).setter(Slot.setter(Builder::responseCard)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseCard").build()}).build();
    private static final SdkField<String> OBFUSCATION_SETTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("obfuscationSetting").getter(Slot.getter(Slot::obfuscationSettingAsString)).setter(Slot.setter(Builder::obfuscationSetting)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("obfuscationSetting").build()}).build();
    private static final SdkField<SlotDefaultValueSpec> DEFAULT_VALUE_SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("defaultValueSpec").getter(Slot.getter(Slot::defaultValueSpec)).setter(Slot.setter(Builder::defaultValueSpec)).constructor(SlotDefaultValueSpec::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultValueSpec").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, SLOT_CONSTRAINT_FIELD, SLOT_TYPE_FIELD, SLOT_TYPE_VERSION_FIELD, VALUE_ELICITATION_PROMPT_FIELD, PRIORITY_FIELD, SAMPLE_UTTERANCES_FIELD, RESPONSE_CARD_FIELD, OBFUSCATION_SETTING_FIELD, DEFAULT_VALUE_SPEC_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final String slotConstraint;
    private final String slotType;
    private final String slotTypeVersion;
    private final Prompt valueElicitationPrompt;
    private final Integer priority;
    private final List<String> sampleUtterances;
    private final String responseCard;
    private final String obfuscationSetting;
    private final SlotDefaultValueSpec defaultValueSpec;

    private Slot(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.slotConstraint = builder.slotConstraint;
        this.slotType = builder.slotType;
        this.slotTypeVersion = builder.slotTypeVersion;
        this.valueElicitationPrompt = builder.valueElicitationPrompt;
        this.priority = builder.priority;
        this.sampleUtterances = builder.sampleUtterances;
        this.responseCard = builder.responseCard;
        this.obfuscationSetting = builder.obfuscationSetting;
        this.defaultValueSpec = builder.defaultValueSpec;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final SlotConstraint slotConstraint() {
        return SlotConstraint.fromValue(this.slotConstraint);
    }

    public final String slotConstraintAsString() {
        return this.slotConstraint;
    }

    public final String slotType() {
        return this.slotType;
    }

    public final String slotTypeVersion() {
        return this.slotTypeVersion;
    }

    public final Prompt valueElicitationPrompt() {
        return this.valueElicitationPrompt;
    }

    public final Integer priority() {
        return this.priority;
    }

    public final boolean hasSampleUtterances() {
        return this.sampleUtterances != null && !(this.sampleUtterances instanceof SdkAutoConstructList);
    }

    public final List<String> sampleUtterances() {
        return this.sampleUtterances;
    }

    public final String responseCard() {
        return this.responseCard;
    }

    public final ObfuscationSetting obfuscationSetting() {
        return ObfuscationSetting.fromValue(this.obfuscationSetting);
    }

    public final String obfuscationSettingAsString() {
        return this.obfuscationSetting;
    }

    public final SlotDefaultValueSpec defaultValueSpec() {
        return this.defaultValueSpec;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.slotConstraintAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.slotType());
        hashCode = 31 * hashCode + Objects.hashCode(this.slotTypeVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.valueElicitationPrompt());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSampleUtterances() ? this.sampleUtterances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.responseCard());
        hashCode = 31 * hashCode + Objects.hashCode(this.obfuscationSettingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValueSpec());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Slot)) {
            return false;
        }
        Slot other = (Slot)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.slotConstraintAsString(), other.slotConstraintAsString()) && Objects.equals(this.slotType(), other.slotType()) && Objects.equals(this.slotTypeVersion(), other.slotTypeVersion()) && Objects.equals(this.valueElicitationPrompt(), other.valueElicitationPrompt()) && Objects.equals(this.priority(), other.priority()) && this.hasSampleUtterances() == other.hasSampleUtterances() && Objects.equals(this.sampleUtterances(), other.sampleUtterances()) && Objects.equals(this.responseCard(), other.responseCard()) && Objects.equals(this.obfuscationSettingAsString(), other.obfuscationSettingAsString()) && Objects.equals(this.defaultValueSpec(), other.defaultValueSpec());
    }

    public final String toString() {
        return ToString.builder((String)"Slot").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("SlotConstraint", (Object)this.slotConstraintAsString()).add("SlotType", (Object)this.slotType()).add("SlotTypeVersion", (Object)this.slotTypeVersion()).add("ValueElicitationPrompt", (Object)this.valueElicitationPrompt()).add("Priority", (Object)this.priority()).add("SampleUtterances", this.hasSampleUtterances() ? this.sampleUtterances() : null).add("ResponseCard", (Object)this.responseCard()).add("ObfuscationSetting", (Object)this.obfuscationSettingAsString()).add("DefaultValueSpec", (Object)this.defaultValueSpec()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "slotConstraint": {
                return Optional.ofNullable(clazz.cast(this.slotConstraintAsString()));
            }
            case "slotType": {
                return Optional.ofNullable(clazz.cast(this.slotType()));
            }
            case "slotTypeVersion": {
                return Optional.ofNullable(clazz.cast(this.slotTypeVersion()));
            }
            case "valueElicitationPrompt": {
                return Optional.ofNullable(clazz.cast(this.valueElicitationPrompt()));
            }
            case "priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "sampleUtterances": {
                return Optional.ofNullable(clazz.cast(this.sampleUtterances()));
            }
            case "responseCard": {
                return Optional.ofNullable(clazz.cast(this.responseCard()));
            }
            case "obfuscationSetting": {
                return Optional.ofNullable(clazz.cast(this.obfuscationSettingAsString()));
            }
            case "defaultValueSpec": {
                return Optional.ofNullable(clazz.cast(this.defaultValueSpec()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Slot, T> g) {
        return obj -> g.apply((Slot)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String slotConstraint;
        private String slotType;
        private String slotTypeVersion;
        private Prompt valueElicitationPrompt;
        private Integer priority;
        private List<String> sampleUtterances = DefaultSdkAutoConstructList.getInstance();
        private String responseCard;
        private String obfuscationSetting;
        private SlotDefaultValueSpec defaultValueSpec;

        private BuilderImpl() {
        }

        private BuilderImpl(Slot model) {
            this.name(model.name);
            this.description(model.description);
            this.slotConstraint(model.slotConstraint);
            this.slotType(model.slotType);
            this.slotTypeVersion(model.slotTypeVersion);
            this.valueElicitationPrompt(model.valueElicitationPrompt);
            this.priority(model.priority);
            this.sampleUtterances(model.sampleUtterances);
            this.responseCard(model.responseCard);
            this.obfuscationSetting(model.obfuscationSetting);
            this.defaultValueSpec(model.defaultValueSpec);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getSlotConstraint() {
            return this.slotConstraint;
        }

        public final void setSlotConstraint(String slotConstraint) {
            this.slotConstraint = slotConstraint;
        }

        @Override
        public final Builder slotConstraint(String slotConstraint) {
            this.slotConstraint = slotConstraint;
            return this;
        }

        @Override
        public final Builder slotConstraint(SlotConstraint slotConstraint) {
            this.slotConstraint(slotConstraint == null ? null : slotConstraint.toString());
            return this;
        }

        public final String getSlotType() {
            return this.slotType;
        }

        public final void setSlotType(String slotType) {
            this.slotType = slotType;
        }

        @Override
        public final Builder slotType(String slotType) {
            this.slotType = slotType;
            return this;
        }

        public final String getSlotTypeVersion() {
            return this.slotTypeVersion;
        }

        public final void setSlotTypeVersion(String slotTypeVersion) {
            this.slotTypeVersion = slotTypeVersion;
        }

        @Override
        public final Builder slotTypeVersion(String slotTypeVersion) {
            this.slotTypeVersion = slotTypeVersion;
            return this;
        }

        public final Prompt.Builder getValueElicitationPrompt() {
            return this.valueElicitationPrompt != null ? this.valueElicitationPrompt.toBuilder() : null;
        }

        public final void setValueElicitationPrompt(Prompt.BuilderImpl valueElicitationPrompt) {
            this.valueElicitationPrompt = valueElicitationPrompt != null ? valueElicitationPrompt.build() : null;
        }

        @Override
        public final Builder valueElicitationPrompt(Prompt valueElicitationPrompt) {
            this.valueElicitationPrompt = valueElicitationPrompt;
            return this;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final Collection<String> getSampleUtterances() {
            if (this.sampleUtterances instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sampleUtterances;
        }

        public final void setSampleUtterances(Collection<String> sampleUtterances) {
            this.sampleUtterances = SlotUtteranceListCopier.copy(sampleUtterances);
        }

        @Override
        public final Builder sampleUtterances(Collection<String> sampleUtterances) {
            this.sampleUtterances = SlotUtteranceListCopier.copy(sampleUtterances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sampleUtterances(String ... sampleUtterances) {
            this.sampleUtterances(Arrays.asList(sampleUtterances));
            return this;
        }

        public final String getResponseCard() {
            return this.responseCard;
        }

        public final void setResponseCard(String responseCard) {
            this.responseCard = responseCard;
        }

        @Override
        public final Builder responseCard(String responseCard) {
            this.responseCard = responseCard;
            return this;
        }

        public final String getObfuscationSetting() {
            return this.obfuscationSetting;
        }

        public final void setObfuscationSetting(String obfuscationSetting) {
            this.obfuscationSetting = obfuscationSetting;
        }

        @Override
        public final Builder obfuscationSetting(String obfuscationSetting) {
            this.obfuscationSetting = obfuscationSetting;
            return this;
        }

        @Override
        public final Builder obfuscationSetting(ObfuscationSetting obfuscationSetting) {
            this.obfuscationSetting(obfuscationSetting == null ? null : obfuscationSetting.toString());
            return this;
        }

        public final SlotDefaultValueSpec.Builder getDefaultValueSpec() {
            return this.defaultValueSpec != null ? this.defaultValueSpec.toBuilder() : null;
        }

        public final void setDefaultValueSpec(SlotDefaultValueSpec.BuilderImpl defaultValueSpec) {
            this.defaultValueSpec = defaultValueSpec != null ? defaultValueSpec.build() : null;
        }

        @Override
        public final Builder defaultValueSpec(SlotDefaultValueSpec defaultValueSpec) {
            this.defaultValueSpec = defaultValueSpec;
            return this;
        }

        public Slot build() {
            return new Slot(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Slot> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder slotConstraint(String var1);

        public Builder slotConstraint(SlotConstraint var1);

        public Builder slotType(String var1);

        public Builder slotTypeVersion(String var1);

        public Builder valueElicitationPrompt(Prompt var1);

        default public Builder valueElicitationPrompt(Consumer<Prompt.Builder> valueElicitationPrompt) {
            return this.valueElicitationPrompt((Prompt)((Prompt.Builder)Prompt.builder().applyMutation(valueElicitationPrompt)).build());
        }

        public Builder priority(Integer var1);

        public Builder sampleUtterances(Collection<String> var1);

        public Builder sampleUtterances(String ... var1);

        public Builder responseCard(String var1);

        public Builder obfuscationSetting(String var1);

        public Builder obfuscationSetting(ObfuscationSetting var1);

        public Builder defaultValueSpec(SlotDefaultValueSpec var1);

        default public Builder defaultValueSpec(Consumer<SlotDefaultValueSpec.Builder> defaultValueSpec) {
            return this.defaultValueSpec((SlotDefaultValueSpec)((SlotDefaultValueSpec.Builder)SlotDefaultValueSpec.builder().applyMutation(defaultValueSpec)).build());
        }
    }
}

