/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelbuilding.LexModelBuildingAsyncClient;
import software.amazon.awssdk.services.lexmodelbuilding.internal.UserAgentUtils;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotChannelAssociationsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotChannelAssociationsResponse;

public class GetBotChannelAssociationsPublisher
implements SdkPublisher<GetBotChannelAssociationsResponse> {
    private final LexModelBuildingAsyncClient client;
    private final GetBotChannelAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetBotChannelAssociationsPublisher(LexModelBuildingAsyncClient client, GetBotChannelAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetBotChannelAssociationsPublisher(LexModelBuildingAsyncClient client, GetBotChannelAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetBotChannelAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetBotChannelAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetBotChannelAssociationsResponseFetcher
    implements AsyncPageFetcher<GetBotChannelAssociationsResponse> {
        private GetBotChannelAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(GetBotChannelAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetBotChannelAssociationsResponse> nextPage(GetBotChannelAssociationsResponse previousPage) {
            if (previousPage == null) {
                return GetBotChannelAssociationsPublisher.this.client.getBotChannelAssociations(GetBotChannelAssociationsPublisher.this.firstRequest);
            }
            return GetBotChannelAssociationsPublisher.this.client.getBotChannelAssociations((GetBotChannelAssociationsRequest)((Object)GetBotChannelAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

