/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The code for the Lambda function. You can either specify an object in Amazon S3, upload a .zip file archive
 * deployment package directly, or specify the URI of a container image.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FunctionCode implements SdkPojo, Serializable, ToCopyableBuilder<FunctionCode.Builder, FunctionCode> {
    private static final SdkField<SdkBytes> ZIP_FILE_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("ZipFile").getter(getter(FunctionCode::zipFile)).setter(setter(Builder::zipFile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZipFile").build()).build();

    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3Bucket").getter(getter(FunctionCode::s3Bucket)).setter(setter(Builder::s3Bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Bucket").build()).build();

    private static final SdkField<String> S3_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("S3Key")
            .getter(getter(FunctionCode::s3Key)).setter(setter(Builder::s3Key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Key").build()).build();

    private static final SdkField<String> S3_OBJECT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3ObjectVersion").getter(getter(FunctionCode::s3ObjectVersion)).setter(setter(Builder::s3ObjectVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ObjectVersion").build()).build();

    private static final SdkField<String> IMAGE_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageUri").getter(getter(FunctionCode::imageUri)).setter(setter(Builder::imageUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageUri").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ZIP_FILE_FIELD,
            S3_BUCKET_FIELD, S3_KEY_FIELD, S3_OBJECT_VERSION_FIELD, IMAGE_URI_FIELD));

    private static final long serialVersionUID = 1L;

    private final SdkBytes zipFile;

    private final String s3Bucket;

    private final String s3Key;

    private final String s3ObjectVersion;

    private final String imageUri;

    private FunctionCode(BuilderImpl builder) {
        this.zipFile = builder.zipFile;
        this.s3Bucket = builder.s3Bucket;
        this.s3Key = builder.s3Key;
        this.s3ObjectVersion = builder.s3ObjectVersion;
        this.imageUri = builder.imageUri;
    }

    /**
     * <p>
     * The base64-encoded contents of the deployment package. Amazon Web Services SDK and CLI clients handle the
     * encoding for you.
     * </p>
     * 
     * @return The base64-encoded contents of the deployment package. Amazon Web Services SDK and CLI clients handle the
     *         encoding for you.
     */
    public final SdkBytes zipFile() {
        return zipFile;
    }

    /**
     * <p>
     * An Amazon S3 bucket in the same Amazon Web Services Region as your function. The bucket can be in a different
     * Amazon Web Services account.
     * </p>
     * 
     * @return An Amazon S3 bucket in the same Amazon Web Services Region as your function. The bucket can be in a
     *         different Amazon Web Services account.
     */
    public final String s3Bucket() {
        return s3Bucket;
    }

    /**
     * <p>
     * The Amazon S3 key of the deployment package.
     * </p>
     * 
     * @return The Amazon S3 key of the deployment package.
     */
    public final String s3Key() {
        return s3Key;
    }

    /**
     * <p>
     * For versioned objects, the version of the deployment package object to use.
     * </p>
     * 
     * @return For versioned objects, the version of the deployment package object to use.
     */
    public final String s3ObjectVersion() {
        return s3ObjectVersion;
    }

    /**
     * <p>
     * URI of a <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-images.html">container image</a> in the
     * Amazon ECR registry.
     * </p>
     * 
     * @return URI of a <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-images.html">container image</a> in
     *         the Amazon ECR registry.
     */
    public final String imageUri() {
        return imageUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(zipFile());
        hashCode = 31 * hashCode + Objects.hashCode(s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(s3Key());
        hashCode = 31 * hashCode + Objects.hashCode(s3ObjectVersion());
        hashCode = 31 * hashCode + Objects.hashCode(imageUri());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionCode)) {
            return false;
        }
        FunctionCode other = (FunctionCode) obj;
        return Objects.equals(zipFile(), other.zipFile()) && Objects.equals(s3Bucket(), other.s3Bucket())
                && Objects.equals(s3Key(), other.s3Key()) && Objects.equals(s3ObjectVersion(), other.s3ObjectVersion())
                && Objects.equals(imageUri(), other.imageUri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FunctionCode").add("ZipFile", zipFile() == null ? null : "*** Sensitive Data Redacted ***")
                .add("S3Bucket", s3Bucket()).add("S3Key", s3Key()).add("S3ObjectVersion", s3ObjectVersion())
                .add("ImageUri", imageUri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ZipFile":
            return Optional.ofNullable(clazz.cast(zipFile()));
        case "S3Bucket":
            return Optional.ofNullable(clazz.cast(s3Bucket()));
        case "S3Key":
            return Optional.ofNullable(clazz.cast(s3Key()));
        case "S3ObjectVersion":
            return Optional.ofNullable(clazz.cast(s3ObjectVersion()));
        case "ImageUri":
            return Optional.ofNullable(clazz.cast(imageUri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FunctionCode, T> g) {
        return obj -> g.apply((FunctionCode) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FunctionCode> {
        /**
         * <p>
         * The base64-encoded contents of the deployment package. Amazon Web Services SDK and CLI clients handle the
         * encoding for you.
         * </p>
         * 
         * @param zipFile
         *        The base64-encoded contents of the deployment package. Amazon Web Services SDK and CLI clients handle
         *        the encoding for you.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zipFile(SdkBytes zipFile);

        /**
         * <p>
         * An Amazon S3 bucket in the same Amazon Web Services Region as your function. The bucket can be in a different
         * Amazon Web Services account.
         * </p>
         * 
         * @param s3Bucket
         *        An Amazon S3 bucket in the same Amazon Web Services Region as your function. The bucket can be in a
         *        different Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Bucket(String s3Bucket);

        /**
         * <p>
         * The Amazon S3 key of the deployment package.
         * </p>
         * 
         * @param s3Key
         *        The Amazon S3 key of the deployment package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Key(String s3Key);

        /**
         * <p>
         * For versioned objects, the version of the deployment package object to use.
         * </p>
         * 
         * @param s3ObjectVersion
         *        For versioned objects, the version of the deployment package object to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ObjectVersion(String s3ObjectVersion);

        /**
         * <p>
         * URI of a <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-images.html">container image</a> in the
         * Amazon ECR registry.
         * </p>
         * 
         * @param imageUri
         *        URI of a <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-images.html">container image</a>
         *        in the Amazon ECR registry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageUri(String imageUri);
    }

    static final class BuilderImpl implements Builder {
        private SdkBytes zipFile;

        private String s3Bucket;

        private String s3Key;

        private String s3ObjectVersion;

        private String imageUri;

        private BuilderImpl() {
        }

        private BuilderImpl(FunctionCode model) {
            zipFile(model.zipFile);
            s3Bucket(model.s3Bucket);
            s3Key(model.s3Key);
            s3ObjectVersion(model.s3ObjectVersion);
            imageUri(model.imageUri);
        }

        public final ByteBuffer getZipFile() {
            return zipFile == null ? null : zipFile.asByteBuffer();
        }

        public final void setZipFile(ByteBuffer zipFile) {
            zipFile(zipFile == null ? null : SdkBytes.fromByteBuffer(zipFile));
        }

        @Override
        public final Builder zipFile(SdkBytes zipFile) {
            this.zipFile = zipFile;
            return this;
        }

        public final String getS3Bucket() {
            return s3Bucket;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final String getS3Key() {
            return s3Key;
        }

        public final void setS3Key(String s3Key) {
            this.s3Key = s3Key;
        }

        @Override
        public final Builder s3Key(String s3Key) {
            this.s3Key = s3Key;
            return this;
        }

        public final String getS3ObjectVersion() {
            return s3ObjectVersion;
        }

        public final void setS3ObjectVersion(String s3ObjectVersion) {
            this.s3ObjectVersion = s3ObjectVersion;
        }

        @Override
        public final Builder s3ObjectVersion(String s3ObjectVersion) {
            this.s3ObjectVersion = s3ObjectVersion;
            return this;
        }

        public final String getImageUri() {
            return imageUri;
        }

        public final void setImageUri(String imageUri) {
            this.imageUri = imageUri;
        }

        @Override
        public final Builder imageUri(String imageUri) {
            this.imageUri = imageUri;
            return this;
        }

        @Override
        public FunctionCode build() {
            return new FunctionCode(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
