/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateLfTagRequest extends LakeFormationRequest implements
        ToCopyableBuilder<UpdateLfTagRequest.Builder, UpdateLfTagRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogId").getter(getter(UpdateLfTagRequest::catalogId)).setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<String> TAG_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("TagKey")
            .getter(getter(UpdateLfTagRequest::tagKey)).setter(setter(Builder::tagKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagKey").build()).build();

    private static final SdkField<List<String>> TAG_VALUES_TO_DELETE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TagValuesToDelete")
            .getter(getter(UpdateLfTagRequest::tagValuesToDelete))
            .setter(setter(Builder::tagValuesToDelete))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagValuesToDelete").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> TAG_VALUES_TO_ADD_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TagValuesToAdd")
            .getter(getter(UpdateLfTagRequest::tagValuesToAdd))
            .setter(setter(Builder::tagValuesToAdd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagValuesToAdd").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD,
            TAG_KEY_FIELD, TAG_VALUES_TO_DELETE_FIELD, TAG_VALUES_TO_ADD_FIELD));

    private final String catalogId;

    private final String tagKey;

    private final List<String> tagValuesToDelete;

    private final List<String> tagValuesToAdd;

    private UpdateLfTagRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.tagKey = builder.tagKey;
        this.tagValuesToDelete = builder.tagValuesToDelete;
        this.tagValuesToAdd = builder.tagValuesToAdd;
    }

    /**
     * <p>
     * The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata
     * store. It contains database definitions, table definitions, and other control information to manage your Lake
     * Formation environment.
     * </p>
     * 
     * @return The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent
     *         metadata store. It contains database definitions, table definitions, and other control information to
     *         manage your Lake Formation environment.
     */
    public final String catalogId() {
        return catalogId;
    }

    /**
     * <p>
     * The key-name for the LF-tag for which to add or delete values.
     * </p>
     * 
     * @return The key-name for the LF-tag for which to add or delete values.
     */
    public final String tagKey() {
        return tagKey;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagValuesToDelete property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTagValuesToDelete() {
        return tagValuesToDelete != null && !(tagValuesToDelete instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of LF-tag values to delete from the LF-tag.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagValuesToDelete} method.
     * </p>
     * 
     * @return A list of LF-tag values to delete from the LF-tag.
     */
    public final List<String> tagValuesToDelete() {
        return tagValuesToDelete;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagValuesToAdd property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTagValuesToAdd() {
        return tagValuesToAdd != null && !(tagValuesToAdd instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of LF-tag values to add from the LF-tag.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagValuesToAdd} method.
     * </p>
     * 
     * @return A list of LF-tag values to add from the LF-tag.
     */
    public final List<String> tagValuesToAdd() {
        return tagValuesToAdd;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(tagKey());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagValuesToDelete() ? tagValuesToDelete() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTagValuesToAdd() ? tagValuesToAdd() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLfTagRequest)) {
            return false;
        }
        UpdateLfTagRequest other = (UpdateLfTagRequest) obj;
        return Objects.equals(catalogId(), other.catalogId()) && Objects.equals(tagKey(), other.tagKey())
                && hasTagValuesToDelete() == other.hasTagValuesToDelete()
                && Objects.equals(tagValuesToDelete(), other.tagValuesToDelete())
                && hasTagValuesToAdd() == other.hasTagValuesToAdd() && Objects.equals(tagValuesToAdd(), other.tagValuesToAdd());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateLfTagRequest").add("CatalogId", catalogId()).add("TagKey", tagKey())
                .add("TagValuesToDelete", hasTagValuesToDelete() ? tagValuesToDelete() : null)
                .add("TagValuesToAdd", hasTagValuesToAdd() ? tagValuesToAdd() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "TagKey":
            return Optional.ofNullable(clazz.cast(tagKey()));
        case "TagValuesToDelete":
            return Optional.ofNullable(clazz.cast(tagValuesToDelete()));
        case "TagValuesToAdd":
            return Optional.ofNullable(clazz.cast(tagValuesToAdd()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLfTagRequest, T> g) {
        return obj -> g.apply((UpdateLfTagRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LakeFormationRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateLfTagRequest> {
        /**
         * <p>
         * The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata
         * store. It contains database definitions, table definitions, and other control information to manage your Lake
         * Formation environment.
         * </p>
         * 
         * @param catalogId
         *        The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent
         *        metadata store. It contains database definitions, table definitions, and other control information to
         *        manage your Lake Formation environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * The key-name for the LF-tag for which to add or delete values.
         * </p>
         * 
         * @param tagKey
         *        The key-name for the LF-tag for which to add or delete values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagKey(String tagKey);

        /**
         * <p>
         * A list of LF-tag values to delete from the LF-tag.
         * </p>
         * 
         * @param tagValuesToDelete
         *        A list of LF-tag values to delete from the LF-tag.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagValuesToDelete(Collection<String> tagValuesToDelete);

        /**
         * <p>
         * A list of LF-tag values to delete from the LF-tag.
         * </p>
         * 
         * @param tagValuesToDelete
         *        A list of LF-tag values to delete from the LF-tag.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagValuesToDelete(String... tagValuesToDelete);

        /**
         * <p>
         * A list of LF-tag values to add from the LF-tag.
         * </p>
         * 
         * @param tagValuesToAdd
         *        A list of LF-tag values to add from the LF-tag.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagValuesToAdd(Collection<String> tagValuesToAdd);

        /**
         * <p>
         * A list of LF-tag values to add from the LF-tag.
         * </p>
         * 
         * @param tagValuesToAdd
         *        A list of LF-tag values to add from the LF-tag.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagValuesToAdd(String... tagValuesToAdd);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LakeFormationRequest.BuilderImpl implements Builder {
        private String catalogId;

        private String tagKey;

        private List<String> tagValuesToDelete = DefaultSdkAutoConstructList.getInstance();

        private List<String> tagValuesToAdd = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLfTagRequest model) {
            super(model);
            catalogId(model.catalogId);
            tagKey(model.tagKey);
            tagValuesToDelete(model.tagValuesToDelete);
            tagValuesToAdd(model.tagValuesToAdd);
        }

        public final String getCatalogId() {
            return catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getTagKey() {
            return tagKey;
        }

        public final void setTagKey(String tagKey) {
            this.tagKey = tagKey;
        }

        @Override
        public final Builder tagKey(String tagKey) {
            this.tagKey = tagKey;
            return this;
        }

        public final Collection<String> getTagValuesToDelete() {
            if (tagValuesToDelete instanceof SdkAutoConstructList) {
                return null;
            }
            return tagValuesToDelete;
        }

        public final void setTagValuesToDelete(Collection<String> tagValuesToDelete) {
            this.tagValuesToDelete = TagValueListCopier.copy(tagValuesToDelete);
        }

        @Override
        public final Builder tagValuesToDelete(Collection<String> tagValuesToDelete) {
            this.tagValuesToDelete = TagValueListCopier.copy(tagValuesToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagValuesToDelete(String... tagValuesToDelete) {
            tagValuesToDelete(Arrays.asList(tagValuesToDelete));
            return this;
        }

        public final Collection<String> getTagValuesToAdd() {
            if (tagValuesToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return tagValuesToAdd;
        }

        public final void setTagValuesToAdd(Collection<String> tagValuesToAdd) {
            this.tagValuesToAdd = TagValueListCopier.copy(tagValuesToAdd);
        }

        @Override
        public final Builder tagValuesToAdd(Collection<String> tagValuesToAdd) {
            this.tagValuesToAdd = TagValueListCopier.copy(tagValuesToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagValuesToAdd(String... tagValuesToAdd) {
            tagValuesToAdd(Arrays.asList(tagValuesToAdd));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLfTagRequest build() {
            return new UpdateLfTagRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
