/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Statistics related to the processing of a query statement.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecutionStatistics implements SdkPojo, Serializable,
        ToCopyableBuilder<ExecutionStatistics.Builder, ExecutionStatistics> {
    private static final SdkField<Long> AVERAGE_EXECUTION_TIME_MILLIS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("AverageExecutionTimeMillis")
            .getter(getter(ExecutionStatistics::averageExecutionTimeMillis))
            .setter(setter(Builder::averageExecutionTimeMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AverageExecutionTimeMillis").build())
            .build();

    private static final SdkField<Long> DATA_SCANNED_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("DataScannedBytes").getter(getter(ExecutionStatistics::dataScannedBytes))
            .setter(setter(Builder::dataScannedBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataScannedBytes").build()).build();

    private static final SdkField<Long> WORK_UNITS_EXECUTED_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("WorkUnitsExecutedCount").getter(getter(ExecutionStatistics::workUnitsExecutedCount))
            .setter(setter(Builder::workUnitsExecutedCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkUnitsExecutedCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AVERAGE_EXECUTION_TIME_MILLIS_FIELD, DATA_SCANNED_BYTES_FIELD, WORK_UNITS_EXECUTED_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long averageExecutionTimeMillis;

    private final Long dataScannedBytes;

    private final Long workUnitsExecutedCount;

    private ExecutionStatistics(BuilderImpl builder) {
        this.averageExecutionTimeMillis = builder.averageExecutionTimeMillis;
        this.dataScannedBytes = builder.dataScannedBytes;
        this.workUnitsExecutedCount = builder.workUnitsExecutedCount;
    }

    /**
     * <p>
     * The average time the request took to be executed.
     * </p>
     * 
     * @return The average time the request took to be executed.
     */
    public final Long averageExecutionTimeMillis() {
        return averageExecutionTimeMillis;
    }

    /**
     * <p>
     * The amount of data that was scanned in bytes.
     * </p>
     * 
     * @return The amount of data that was scanned in bytes.
     */
    public final Long dataScannedBytes() {
        return dataScannedBytes;
    }

    /**
     * <p>
     * The number of work units executed.
     * </p>
     * 
     * @return The number of work units executed.
     */
    public final Long workUnitsExecutedCount() {
        return workUnitsExecutedCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(averageExecutionTimeMillis());
        hashCode = 31 * hashCode + Objects.hashCode(dataScannedBytes());
        hashCode = 31 * hashCode + Objects.hashCode(workUnitsExecutedCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionStatistics)) {
            return false;
        }
        ExecutionStatistics other = (ExecutionStatistics) obj;
        return Objects.equals(averageExecutionTimeMillis(), other.averageExecutionTimeMillis())
                && Objects.equals(dataScannedBytes(), other.dataScannedBytes())
                && Objects.equals(workUnitsExecutedCount(), other.workUnitsExecutedCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecutionStatistics").add("AverageExecutionTimeMillis", averageExecutionTimeMillis())
                .add("DataScannedBytes", dataScannedBytes()).add("WorkUnitsExecutedCount", workUnitsExecutedCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AverageExecutionTimeMillis":
            return Optional.ofNullable(clazz.cast(averageExecutionTimeMillis()));
        case "DataScannedBytes":
            return Optional.ofNullable(clazz.cast(dataScannedBytes()));
        case "WorkUnitsExecutedCount":
            return Optional.ofNullable(clazz.cast(workUnitsExecutedCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecutionStatistics, T> g) {
        return obj -> g.apply((ExecutionStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExecutionStatistics> {
        /**
         * <p>
         * The average time the request took to be executed.
         * </p>
         * 
         * @param averageExecutionTimeMillis
         *        The average time the request took to be executed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder averageExecutionTimeMillis(Long averageExecutionTimeMillis);

        /**
         * <p>
         * The amount of data that was scanned in bytes.
         * </p>
         * 
         * @param dataScannedBytes
         *        The amount of data that was scanned in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataScannedBytes(Long dataScannedBytes);

        /**
         * <p>
         * The number of work units executed.
         * </p>
         * 
         * @param workUnitsExecutedCount
         *        The number of work units executed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workUnitsExecutedCount(Long workUnitsExecutedCount);
    }

    static final class BuilderImpl implements Builder {
        private Long averageExecutionTimeMillis;

        private Long dataScannedBytes;

        private Long workUnitsExecutedCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionStatistics model) {
            averageExecutionTimeMillis(model.averageExecutionTimeMillis);
            dataScannedBytes(model.dataScannedBytes);
            workUnitsExecutedCount(model.workUnitsExecutedCount);
        }

        public final Long getAverageExecutionTimeMillis() {
            return averageExecutionTimeMillis;
        }

        public final void setAverageExecutionTimeMillis(Long averageExecutionTimeMillis) {
            this.averageExecutionTimeMillis = averageExecutionTimeMillis;
        }

        @Override
        public final Builder averageExecutionTimeMillis(Long averageExecutionTimeMillis) {
            this.averageExecutionTimeMillis = averageExecutionTimeMillis;
            return this;
        }

        public final Long getDataScannedBytes() {
            return dataScannedBytes;
        }

        public final void setDataScannedBytes(Long dataScannedBytes) {
            this.dataScannedBytes = dataScannedBytes;
        }

        @Override
        public final Builder dataScannedBytes(Long dataScannedBytes) {
            this.dataScannedBytes = dataScannedBytes;
            return this;
        }

        public final Long getWorkUnitsExecutedCount() {
            return workUnitsExecutedCount;
        }

        public final void setWorkUnitsExecutedCount(Long workUnitsExecutedCount) {
            this.workUnitsExecutedCount = workUnitsExecutedCount;
        }

        @Override
        public final Builder workUnitsExecutedCount(Long workUnitsExecutedCount) {
            this.workUnitsExecutedCount = workUnitsExecutedCount;
            return this;
        }

        @Override
        public ExecutionStatistics build() {
            return new ExecutionStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
